/*
 * Decompiled with CFR 0.152.
 */
package terrails.terracore.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import terrails.terracore.util.MathUtils;

public class WorldUtils {
    public static boolean equalsState(IBlockState state1, IBlockState state2) {
        Block block1 = state1.func_177230_c();
        Block block2 = state2.func_177230_c();
        return block1.func_176201_c(state1) == block2.func_176201_c(state2) && block1 == block2;
    }

    public static boolean isReplaceable(IBlockState state) {
        return state.func_185904_a().func_76222_j() || WorldUtils.isLiquid(state);
    }

    public static boolean isLiquid(IBlockState state) {
        return state instanceof BlockLiquid || state instanceof BlockLiquidWrapper || state instanceof IFluidBlock || state.func_185904_a().func_76224_d();
    }

    public static class Checker {
        private final IBlockState[] blockStates;
        private final BlockPos pos;
        private final IBlockAccess world;
        private final CheckerProperties.Kind kind;
        private final CheckerProperties.Check check;
        private final CheckerProperties.BlockType blockType;
        private final EnumFacing facing;
        private final int radiusX;
        private final int radiusY;
        private final int radiusZ;

        public Checker(CheckerProperties properties, EnumFacing facing, IBlockAccess world, BlockPos pos, int radiusX, int radiusY, int radiusZ, IBlockState ... blockStates) {
            this.blockStates = blockStates;
            this.kind = properties.kind;
            this.check = properties.check;
            this.blockType = properties.blockType;
            this.radiusX = radiusX;
            this.radiusY = radiusY;
            this.radiusZ = radiusZ;
            this.facing = facing;
            this.world = world;
            this.pos = pos;
        }

        public Checker(CheckerProperties properties, EnumFacing facing, IBlockAccess world, BlockPos pos, int radius, IBlockState ... blockStates) {
            this(properties, facing, world, pos, radius, radius, radius, blockStates);
        }

        public Checker(CheckerProperties properties, EnumFacing facing, IBlockAccess world, BlockPos pos, int radius) {
            this(properties, facing, world, pos, radius, radius, radius, (IBlockState[])null);
        }

        public Checker(CheckerProperties properties, IBlockAccess world, BlockPos pos, int radius, IBlockState ... blockStates) {
            this(properties, null, world, pos, radius, radius, radius, blockStates);
        }

        public Checker(CheckerProperties properties, IBlockAccess world, BlockPos pos, int radiusX, int radiusY, int radiusZ) {
            this(properties, null, world, pos, radiusX, radiusY, radiusZ, (IBlockState[])null);
        }

        public Checker(CheckerProperties properties, IBlockAccess world, BlockPos pos, int radius) {
            this(properties, null, world, pos, radius, radius, radius, (IBlockState[])null);
        }

        public boolean check() {
            boolean value = false;
            for (BlockPos pos : this.getPositions()) {
                IBlockState state = this.world.func_180495_p(pos);
                boolean isBlock = this.isCorrectBlock(state);
                if (this.check == CheckerProperties.Check.ANY && isBlock) {
                    return true;
                }
                if (this.check != CheckerProperties.Check.ALL) continue;
                if (!isBlock) {
                    return false;
                }
                value = true;
            }
            return value;
        }

        public int count() {
            int value = 0;
            for (BlockPos pos : this.getPositions()) {
                IBlockState state = this.world.func_180495_p(pos);
                boolean isBlock = this.isCorrectBlock(state);
                if (!isBlock) continue;
                ++value;
            }
            return value;
        }

        private boolean isCorrectBlock(IBlockState state) {
            Block block = state.func_177230_c();
            boolean isSolid = !block.equals(Blocks.field_150350_a) && !block.func_176200_f(this.world, this.pos);
            boolean isAir = block.equals(Blocks.field_150350_a) && !(state instanceof BlockLiquid) && !(state instanceof BlockLiquidWrapper) && !(state instanceof IFluidBlock) && !state.func_185904_a().func_76224_d();
            boolean i = isAir && this.blockType == CheckerProperties.BlockType.AIR || isSolid && this.blockType == CheckerProperties.BlockType.SOLID || this.blockType == CheckerProperties.BlockType.ALL;
            return this.blockStates != null && Arrays.stream(this.blockStates).map(state1 -> WorldUtils.equalsState(state1, state)).findAny().orElse(Boolean.FALSE) != false || i;
        }

        private List<BlockPos> getPositions() {
            int radiusX = this.radiusX;
            int radiusZ = this.radiusZ;
            int radiusY = this.kind == CheckerProperties.Kind.FLAT ? 0 : this.radiusY;
            int radiusYs = this.facing == EnumFacing.UP ? 0 : radiusY;
            int radiusYe = this.facing == EnumFacing.DOWN ? 0 : radiusY;
            ArrayList positions = Lists.newArrayList();
            for (int y = -radiusYs; y <= radiusYe; ++y) {
                for (int x = -radiusX; x <= radiusX; ++x) {
                    block8: for (int z = -radiusZ; z <= radiusZ; ++z) {
                        BlockPos pos = this.pos.func_177982_a(x, y, z);
                        switch (this.kind) {
                            case HOLLOW: {
                                boolean c;
                                boolean a;
                                boolean bl = a = Math.abs(x) == Math.abs(radiusX);
                                boolean b = y < 0 ? Math.abs(y) == Math.abs(radiusYs) : Math.abs(y) == Math.abs(radiusYe);
                                boolean bl2 = c = Math.abs(z) == Math.abs(radiusZ);
                                if (!a && !b && !c) continue block8;
                                positions.add(pos);
                                continue block8;
                            }
                            case WALL: {
                                boolean b;
                                boolean a = Math.abs(x) == Math.abs(radiusX);
                                boolean bl = b = Math.abs(z) == Math.abs(radiusZ);
                                if (!a && !b) continue block8;
                                positions.add(pos);
                                continue block8;
                            }
                            case FLAT: {
                                if (pos.func_177956_o() != this.pos.func_177956_o()) continue block8;
                                positions.add(pos);
                                continue block8;
                            }
                            case NORMAL: {
                                positions.add(pos);
                            }
                        }
                    }
                }
            }
            return positions;
        }

        public static class CheckerProperties {
            private Kind kind = Kind.NORMAL;
            private Check check = Check.ALL;
            private BlockType blockType = BlockType.ALL;

            public Kind getKind() {
                return this.kind;
            }

            public Check getCheck() {
                return this.check;
            }

            public BlockType getBlockType() {
                return this.blockType;
            }

            public CheckerProperties setKind(Kind kind) {
                this.kind = kind;
                return this;
            }

            public CheckerProperties setCheck(Check check) {
                this.check = check;
                return this;
            }

            public CheckerProperties setBlockType(BlockType blockType) {
                this.blockType = blockType;
                return this;
            }

            public static enum BlockType {
                ALL,
                SOLID,
                AIR;

            }

            public static enum Check {
                ALL,
                ANY;

            }

            public static enum Kind {
                NORMAL,
                HOLLOW,
                WALL,
                FLAT;

            }
        }
    }

    public static class Placement {
        private final IBlockState blockState;
        private final BlockPos pos;
        private final World world;
        private final PlacementProperties.Type type;
        private final PlacementProperties.Kind kind;
        private final PlacementProperties.DeleteBlocks deleteBlocks;
        private final EnumFacing facing;
        private final int radiusX;
        private final int radiusY;
        private final int radiusZ;

        public Placement(PlacementProperties properties, EnumFacing facing, World world, BlockPos pos, int radiusX, int radiusY, int radiusZ, IBlockState blockState) {
            this.blockState = blockState;
            this.type = properties.type;
            this.kind = properties.kind;
            this.deleteBlocks = properties.deleteBlocks;
            this.radiusX = radiusX;
            this.radiusY = radiusY;
            this.radiusZ = radiusZ;
            this.facing = facing;
            this.world = world;
            this.pos = pos;
        }

        public Placement(PlacementProperties properties, World world, BlockPos pos, int radiusX, int radiusY, int radiusZ, IBlockState blockState) {
            this(properties, null, world, pos, radiusX, radiusY, radiusZ, blockState);
        }

        public Placement(PlacementProperties properties, EnumFacing facing, World world, BlockPos pos, int radius, IBlockState blockState) {
            this(properties, facing, world, pos, radius, radius, radius, blockState);
        }

        public Placement(PlacementProperties properties, World world, BlockPos pos, int radius, IBlockState blockState) {
            this(properties, null, world, pos, radius, radius, radius, blockState);
        }

        public void build() {
            if (this.type == PlacementProperties.Type.CUBOID) {
                for (BlockPos pos : (List)this.getPositions().func_76341_a()) {
                    this.world.func_175656_a(pos, this.blockState);
                }
                for (BlockPos pos : (List)this.getPositions().func_76340_b()) {
                    this.world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
            } else if (this.type == PlacementProperties.Type.SPHERE) {
                this.sphere(null);
            }
        }

        public void sphere(IBlockState innerState) {
            double radiusX = (double)this.radiusX + 0.5;
            double radiusY = (double)this.radiusY + 0.5;
            double radiusZ = (double)this.radiusZ + 0.5;
            double nextXn = 0.0;
            int x = 0;
            block0: while ((double)x <= Math.ceil(radiusX)) {
                double xn = nextXn;
                nextXn = (double)(x + 1) * (1.0 / radiusX);
                double nextYn = 0.0;
                int y = 0;
                block1: while ((double)y <= Math.ceil(radiusY)) {
                    double yn = nextYn;
                    nextYn = (double)(y + 1) * (1.0 / radiusY);
                    double nextZn = 0.0;
                    int z = 0;
                    while ((double)z <= Math.ceil(radiusZ)) {
                        double zn = nextZn;
                        nextZn = (double)(z + 1) * (1.0 / radiusZ);
                        double[] dArray = new double[]{xn, yn, zn};
                        double distanceSq = MathUtils.squared(dArray);
                        if (distanceSq > 1.0) {
                            if (z != 0) break;
                            if (y != 0) break block1;
                            break block0;
                        }
                        IBlockState state = this.blockState;
                        double[] dArray2 = new double[]{nextXn, yn, zn};
                        if (MathUtils.squared(dArray2) <= 1.0) {
                            double[] dArray3 = new double[]{xn, nextYn, zn};
                            if (MathUtils.squared(dArray3) <= 1.0) {
                                double[] dArray4 = new double[]{xn, yn, nextZn};
                                if (MathUtils.squared(dArray4) <= 1.0) {
                                    if (innerState != null && innerState.func_185904_a() != Material.field_151579_a) {
                                        state = innerState;
                                    } else if (this.deleteBlocks == PlacementProperties.DeleteBlocks.ALL) {
                                        state = Blocks.field_150350_a.func_176223_P();
                                    } else if (this.kind == PlacementProperties.Kind.HOLLOW) {
                                        state = null;
                                    }
                                }
                            }
                        }
                        if (state != null) {
                            this.world.func_175656_a(this.pos.func_177982_a(x, y, z), state);
                            this.world.func_175656_a(this.pos.func_177982_a(-x, y, z), state);
                            this.world.func_175656_a(this.pos.func_177982_a(x, -y, z), state);
                            this.world.func_175656_a(this.pos.func_177982_a(x, y, -z), state);
                            this.world.func_175656_a(this.pos.func_177982_a(-x, -y, z), state);
                            this.world.func_175656_a(this.pos.func_177982_a(x, -y, -z), state);
                            this.world.func_175656_a(this.pos.func_177982_a(-x, y, -z), state);
                            this.world.func_175656_a(this.pos.func_177982_a(-x, -y, -z), state);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }

        private Tuple<List<BlockPos>, List<BlockPos>> getPositions() {
            int radiusX = this.radiusX;
            int radiusZ = this.radiusZ;
            int radiusY = this.kind == PlacementProperties.Kind.FLAT ? 0 : this.radiusY;
            int radiusYs = this.facing == EnumFacing.UP ? 0 : radiusY;
            int radiusYe = this.facing == EnumFacing.DOWN ? 0 : radiusY;
            ArrayList placeBlocks = Lists.newArrayList();
            ArrayList outsideBlocks = Lists.newArrayList();
            for (int y = -radiusYs; y <= radiusYe; ++y) {
                for (int x = -radiusX; x <= radiusX; ++x) {
                    block8: for (int z = -radiusZ; z <= radiusZ; ++z) {
                        BlockPos pos = this.pos.func_177982_a(x, y, z);
                        switch (this.kind) {
                            case HOLLOW: {
                                boolean c;
                                boolean a;
                                boolean bl = a = Math.abs(x) == Math.abs(radiusX);
                                boolean b = y < 0 ? Math.abs(y) == Math.abs(radiusYs) : Math.abs(y) == Math.abs(radiusYe);
                                boolean bl2 = c = Math.abs(z) == Math.abs(radiusZ);
                                if (a || b || c) {
                                    placeBlocks.add(pos);
                                    continue block8;
                                }
                                if (this.deleteBlocks != PlacementProperties.DeleteBlocks.ALL) continue block8;
                                outsideBlocks.add(pos);
                                continue block8;
                            }
                            case WALL: {
                                boolean b;
                                boolean a = Math.abs(x) == Math.abs(radiusX);
                                boolean bl = b = Math.abs(z) == Math.abs(radiusZ);
                                if (a || b) {
                                    placeBlocks.add(pos);
                                    continue block8;
                                }
                                if (this.deleteBlocks != PlacementProperties.DeleteBlocks.ALL) continue block8;
                                outsideBlocks.add(pos);
                                continue block8;
                            }
                            case FLAT: {
                                if (pos.func_177956_o() == this.pos.func_177956_o()) {
                                    placeBlocks.add(pos);
                                    continue block8;
                                }
                                if (this.deleteBlocks != PlacementProperties.DeleteBlocks.ALL) continue block8;
                                outsideBlocks.add(pos);
                                continue block8;
                            }
                            case NORMAL: {
                                placeBlocks.add(pos);
                            }
                        }
                    }
                }
            }
            return new Tuple((Object)placeBlocks, (Object)outsideBlocks);
        }

        public static class PlacementProperties {
            private Type type;
            private Kind kind;
            private DeleteBlocks deleteBlocks = DeleteBlocks.ALL;

            public PlacementProperties(Type type) {
                this.type = type;
            }

            public Type getType() {
                return this.type;
            }

            public Kind getKind() {
                return this.kind;
            }

            public DeleteBlocks getDeleteBlocks() {
                return this.deleteBlocks;
            }

            public PlacementProperties setType(Type type) {
                this.type = type;
                return this;
            }

            public PlacementProperties setKind(Kind kind) {
                this.kind = kind;
                return this;
            }

            public PlacementProperties setBlockType(DeleteBlocks blockType) {
                this.deleteBlocks = blockType;
                return this;
            }

            public static enum DeleteBlocks {
                ALL,
                NONE;

            }

            public static enum Kind {
                NORMAL,
                HOLLOW,
                WALL,
                FLAT;

            }

            public static enum Type {
                CUBOID,
                SPHERE;

            }
        }
    }
}

