/*
 * Decompiled with CFR 0.152.
 */
package terrails.terracore.base.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import terrails.terracore.base.IModEntry;
import terrails.terracore.base.registry.RegistryType;
import terrails.terracore.registry.IUnlocalizedName;

public class RegistryList<T extends IForgeRegistryEntry>
extends ArrayList<T> {
    private final RegistryType type;
    private final IModEntry modEntry;

    public RegistryList(RegistryType type, IModEntry modEntry) {
        this.type = type;
        this.modEntry = modEntry;
    }

    public RegistryType getType() {
        return this.type;
    }

    @Override
    public boolean add(T entry) {
        if (this.contains(entry)) {
            return true;
        }
        this.check(false, entry);
        return super.add(entry);
    }

    @Override
    public void add(int index, T entry) {
        if (this.contains(entry)) {
            return;
        }
        this.check(false, entry);
        super.add(index, entry);
    }

    @Override
    public boolean addAll(Collection<? extends T> entries) {
        for (IForgeRegistryEntry entry : entries) {
            if (this.contains(entry)) continue;
            this.check(false, entry);
            super.add(entry);
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> entries) {
        for (IForgeRegistryEntry entry : entries) {
            if (this.contains(entry)) continue;
            this.check(false, entry);
            super.add(index, entry);
        }
        return false;
    }

    public boolean add(T entry, boolean override) {
        if (this.contains(entry)) {
            return true;
        }
        this.check(override, entry);
        return super.add(entry);
    }

    public void add(int index, T entry, boolean override) {
        if (this.contains(entry)) {
            return;
        }
        this.check(override, entry);
        super.add(index, entry);
    }

    public boolean addAll(Collection<? extends T> entries, boolean override) {
        for (IForgeRegistryEntry entry : entries) {
            if (this.contains(entry)) continue;
            this.check(override, entry);
            super.add(entry);
        }
        return true;
    }

    public boolean addAll(int index, Collection<? extends T> entries, boolean override) {
        for (IForgeRegistryEntry entry : entries) {
            if (this.contains(entry)) continue;
            this.check(override, entry);
            super.add(index, entry);
        }
        return true;
    }

    private void check(boolean override, T entry) {
        if (this.contains(entry)) {
            return;
        }
        ResourceLocation registryName = entry.getRegistryName();
        if (registryName == null) {
            throw new RuntimeException(entry + ", doesn't have a registry name!");
        }
        if (registryName.func_110624_b().equalsIgnoreCase("minecraft") && !override) {
            entry.setRegistryName(new ResourceLocation(this.modEntry.getId(), registryName.func_110623_a()));
        }
        if (!IUnlocalizedName.class.isInstance(entry)) {
            return;
        }
        IUnlocalizedName unlocalizedName = (IUnlocalizedName)entry;
        String name = unlocalizedName.getEntryName();
        if (name.isEmpty()) {
            throw new NullPointerException("'" + Objects.requireNonNull(entry.getRegistryName()).toString() + "' does not have a unlocalized name!");
        }
        if (!override) {
            if (name.startsWith("tile.") || name.startsWith("item.")) {
                name = name.substring(5);
            } else if (name.startsWith("potion.")) {
                name = name.substring(7);
            } else if (name.startsWith("enchantment.")) {
                name = name.substring(12);
            }
            if (!name.contains(this.modEntry.getId())) {
                name = (entry instanceof Potion ? "potion." : "") + this.modEntry.getId() + "." + name;
                unlocalizedName.setEntryName(name);
            }
        }
    }

    public static RegistryList<? extends IForgeRegistryEntry> newInstance(RegistryType type, IModEntry modEntry) {
        return new RegistryList(type, modEntry);
    }
}

