/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import teamroots.emberroot.entity.ai.IOwnable;

public class EntityAIFollowOwner
extends EntityAIBase {
    IOwnable<? extends EntityCreature, ? extends EntityLivingBase> owned;
    double followSpeed;
    private int pathingTimer;
    private double minDistanceSq;
    private double maxDistanceSq;

    public EntityAIFollowOwner(IOwnable<? extends EntityCreature, ? extends EntityLivingBase> owned, double minDist, double maxDist, double followSpeed) {
        this.owned = owned;
        this.minDistanceSq = minDist * minDist;
        this.maxDistanceSq = maxDist * maxDist;
        this.followSpeed = followSpeed;
    }

    public boolean func_75250_a() {
        if (this.owned.getOwner() == null) {
            return false;
        }
        return this.getDistanceSqFromOwner() > this.maxDistanceSq;
    }

    public boolean func_75253_b() {
        EntityLivingBase owner = this.owned.getOwner();
        if (owner == null || !owner.func_70089_S()) {
            return false;
        }
        return !this.owned.asEntity().func_70661_as().func_75500_f();
    }

    public boolean isWithinTargetDistanceFromOwner() {
        if (this.owned.getOwner() == null) {
            return true;
        }
        double distance = this.getDistanceSqFromOwner();
        return distance >= this.minDistanceSq && distance <= this.maxDistanceSq;
    }

    private double getDistanceSqFromOwner() {
        double distance = this.owned.asEntity().func_70068_e((Entity)this.owned.getOwner());
        return distance;
    }

    public void func_75249_e() {
        this.pathingTimer = 0;
    }

    public void func_75251_c() {
    }

    public void func_75246_d() {
        EntityLivingBase owner = this.owned.getOwner();
        if (owner == null) {
            return;
        }
        double distance = this.getDistanceSqFromOwner();
        if (distance < this.minDistanceSq) {
            this.owned.asEntity().func_70661_as().func_75499_g();
        }
        if (--this.pathingTimer <= 0) {
            this.pathingTimer = 10;
            this.owned.asEntity().func_70661_as().func_75497_a((Entity)this.owned.getOwner(), this.followSpeed);
        }
    }
}

