/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.config;

import java.util.ArrayList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Configuration;
import teamroots.emberroot.util.EntityUtil;

public class ConfigSpawnEntity {
    public Class<? extends EntityLiving> entityClass;
    public EnumCreatureType typeOfCreature;
    public MobProperties defaults = new MobProperties();
    public MobProperties settings = new MobProperties();
    String category;

    public ConfigSpawnEntity(Class<? extends EntityLiving> clz, EnumCreatureType type) {
        this.entityClass = clz;
        this.typeOfCreature = type;
        this.category = clz.getSimpleName();
    }

    public ConfigSpawnEntity setDefaultProperties(int dhealth, float attack, int follow) {
        this.defaults.maxHealth = dhealth;
        this.defaults.attack = attack;
        this.defaults.followRange = follow;
        this.defaults.useAllBiomes = true;
        return this;
    }

    public ConfigSpawnEntity setSpeeds(float mSpeed) {
        this.defaults.movementSpeed = mSpeed;
        return this;
    }

    public ConfigSpawnEntity setDefaultSpawns(int pmin, int pmax, int pweight) {
        this.defaults.min = pmin;
        this.defaults.max = pmax;
        this.defaults.weightedProb = pweight;
        return this;
    }

    public ConfigSpawnEntity setDefaultBiomesAll() {
        this.defaults.useAllBiomes = true;
        return this;
    }

    public ConfigSpawnEntity setDefaultBiome(String[] biomelist) {
        this.defaults.useAllBiomes = false;
        this.defaults.biomes = biomelist;
        return this;
    }

    public void syncConfig(Configuration config) {
        this.settings.min = config.getInt("minSpawnCount", this.category, this.defaults.min, 0, 32, "Smallest spawn group.");
        this.settings.max = config.getInt("maxSpawnCount", this.category, this.defaults.max, 0, 32, "Biggest spawn group.");
        if (this.settings.max < this.settings.min) {
            this.settings.max = this.settings.min + 1;
        }
        this.settings.weightedProb = config.getInt("weightProbability", this.category, this.defaults.weightedProb, 0, 100, "Configures the spawning frequency. Higher numbers mean more spawns.");
        this.settings.useAllBiomes = config.getBoolean("allBiomes", this.category, this.defaults.useAllBiomes, "Try to spawn in every biome.  If false, it will use the whitelist in this config ");
        this.settings.biomes = config.getStringList("biomeWhitelist", this.category, this.defaults.biomes, "Biomes this will spawn into.  Add support for any modded biome here.  Ignored whenever allBiomes is true. https://minecraft.gamepedia.com/Data_values#Biome_IDs");
        this.settings.maxHealth = config.getInt("maxHealth", this.category, this.defaults.maxHealth, 1, 100, "Max health of the mob");
        if (this.settings.followRange >= 0) {
            this.settings.followRange = config.getInt("followRange", this.category, this.defaults.followRange, 0, 32, "Base follow range");
        }
        if (this.defaults.attack >= 0.0f) {
            this.settings.attack = config.getFloat("baseDamage", this.category, this.defaults.attack, 0.0f, 100.0f, "Base attack, before weapons and buffs");
        }
        if (this.defaults.movementSpeed > 0.0f) {
            this.settings.movementSpeed = config.getFloat("movementSpeed", this.category, this.defaults.movementSpeed, 0.0f, 2.0f, "Base speed, before buffs.  (Does not apply to living mobs, you must kill and respawn to see new speed get applied)");
        }
    }

    public Biome[] getBiomeFilter() {
        ArrayList<Biome> allBiomes = new ArrayList<Biome>();
        for (String b : this.settings.biomes) {
            Biome found = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(b));
            if (found == null) continue;
            allBiomes.add(found);
        }
        return allBiomes.toArray(new Biome[0]);
    }

    public String toString() {
        return this.settings.toString();
    }

    public static void syncInstance(EntityLivingBase living, MobProperties settings) {
        EntityUtil.setMaxHealth(living, settings.maxHealth);
        if (settings.attack >= 0.0f) {
            EntityUtil.setBaseDamage(living, settings.attack);
        }
        if (settings.followRange >= 0) {
            EntityUtil.setFollow(living, settings.followRange);
        }
        if (settings.movementSpeed > 0.0f) {
            EntityUtil.setSpeed(living, settings.movementSpeed);
        }
    }

    public static class MobProperties {
        public int weightedProb;
        public int min;
        public int max;
        public String[] biomes = new String[0];
        public int maxHealth;
        public float attack;
        public boolean useAllBiomes = true;
        public int followRange;
        public float movementSpeed = 0.0f;

        public String toString() {
            String s = " min " + this.min + " max " + this.max + " weight " + this.weightedProb + " attack  " + this.attack + " follow" + this.followRange + " allBiomes : " + this.useAllBiomes;
            s = s + System.lineSeparator();
            s = s + "BIOMES: ";
            for (String b : this.biomes) {
                s = s + b + ",";
            }
            return s;
        }
    }
}

