/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.old;

import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.GuiMarkdownElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.PartContainer;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.brandon3055.brandonscore.utils.Utils;
import java.util.LinkedList;

public abstract class Part {
    public int width;
    public int height;
    public int lastXPos = -1;
    public int lastYPos = -1;
    public PartContainer container;
    public boolean errored = false;

    public Part(PartContainer container) {
        this.container = container;
    }

    public static String readOption(String optionsString, String target, String defaultOpt) {
        String[] ops;
        if (optionsString.isEmpty()) {
            return defaultOpt;
        }
        for (String op : ops = optionsString.split("(?!\\B\"[^\"]*),(?![^\"]*\"\\B)")) {
            if (!op.contains(":")) {
                LogHelperBC.error("GuiMarkdownElement: Invalid option detected! Option: " + op + " Required Format: optionName:Option Value");
                return defaultOpt;
            }
            if (!op.toLowerCase().startsWith(target + ":")) continue;
            String found = op.substring(target.length() + 1);
            if (found.startsWith("\"") && found.length() > 1) {
                found = found.substring(1);
            }
            if (found.endsWith("\"") && found.length() > 1) {
                found = found.substring(0, found.length() - 1);
            }
            return found;
        }
        return defaultOpt;
    }

    public static int readColour(String input) throws NumberFormatException {
        if (input.startsWith("0x") || input.startsWith("#")) {
            input = input.replace("0x", "").replace("#", "");
            return Utils.parseHex(input, false);
        }
        if (input.contains(",")) {
            String[] vals = input.split(",");
            if (vals.length != 3) {
                throw new NumberFormatException();
            }
            int r = vals[0].contains(".") ? (int)(Double.parseDouble(vals[0]) * 255.0) : Integer.parseInt(vals[0]);
            int g = vals[1].contains(".") ? (int)(Double.parseDouble(vals[1]) * 255.0) : Integer.parseInt(vals[0]);
            int b = vals[2].contains(".") ? (int)(Double.parseDouble(vals[2]) * 255.0) : Integer.parseInt(vals[0]);
            return r << 16 | g << 8 | b;
        }
        throw new NumberFormatException();
    }

    public static LinkedList<String> splitOnSpace(String input) {
        int pos;
        LinkedList<String> subs = new LinkedList<String>();
        if (input.length() == 0) {
            return subs;
        }
        int prev = 0;
        for (pos = 0; pos < input.length(); ++pos) {
            char c = input.charAt(pos);
            if (c != ' ' && c != '\n') continue;
            subs.add(input.substring(prev, pos));
            prev = pos;
        }
        subs.add(input.substring(prev, pos));
        return subs;
    }

    public static String applyTextFormatting(String input) {
        int escape = 0;
        while (GuiMarkdownElement.bold.matcher(input).find() && escape++ < 1000) {
            input = input.replaceFirst("(\\*\\*)", "\u00a7l").replaceFirst("(\\*\\*)", "\u00a7l");
        }
        while (GuiMarkdownElement.italic.matcher(input).find() && escape++ < 1000) {
            input = input.replaceFirst("(\\*)", "\u00a7o").replaceFirst("(\\*)", "\u00a7o");
        }
        while (GuiMarkdownElement.underline.matcher(input).find() && escape++ < 1000) {
            input = input.replaceFirst("(__)", "\u00a7n").replaceFirst("(__)", "\u00a7n");
        }
        while (GuiMarkdownElement.strike.matcher(input).find() && escape++ < 1000) {
            input = input.replaceFirst("(~~)", "\u00a7m").replaceFirst("(~~)", "\u00a7m");
        }
        while (GuiMarkdownElement.obf.matcher(input).find() && escape++ < 1000) {
            input = input.replaceFirst("(~\\?~)", "\u00a7k").replaceFirst("(~\\?~)", "\u00a7k");
        }
        if (escape >= 1000) {
            LogHelperBC.dev("Escape!");
        }
        return input;
    }

    public static String trim(String input, char target) {
        if (input.length() == 0) {
            return input;
        }
        int start = 0;
        int end = input.length() - 1;
        while (start + 1 < input.length() && input.charAt(start) == target) {
            ++start;
        }
        if (input.charAt(start) == ' ' && start + 1 < input.length()) {
            ++start;
        }
        while (end >= start && input.charAt(end) == target) {
            --end;
        }
        return input.substring(start, end + 1);
    }

    public static boolean isAllChar(String input, char target) {
        if (input.length() == 0) {
            return false;
        }
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == target) continue;
            return false;
        }
        return true;
    }

    public static void addError(LinkedList<String> markdownLines, String message, String errorValue) {
        markdownLines.removeFirst();
        markdownLines.addFirst("\u00a74Error: " + message + "" + "\u00a7" + "4 " + errorValue);
    }

    public abstract void render(BCFontRenderer var1, int var2, int var3, int var4, int var5, int var6, boolean var7, float var8);

    public static int parseSize(int maxWidth, String value) throws NumberFormatException {
        if (value.endsWith("%")) {
            return (int)(Double.parseDouble(value.replace("%", "")) / 100.0 * (double)maxWidth);
        }
        if (value.endsWith("px") || Utils.validInteger(value)) {
            return Integer.parseInt(value.replace("px", ""));
        }
        throw new NumberFormatException();
    }
}

