/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.lib.gui;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Rectangle4i;
import java.awt.Point;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class DrawableGuiElement {
    private final Gui parent;
    private final ResourceLocation SPRITE_LOCATION;
    private final Rectangle4i SPRITE;
    private final Point GUI_LOCATION;
    private final Supplier<Pair<Integer, Integer>> animSupplier;
    private final AnimationDirection ANIMATION_DIRECTION;
    private final BooleanSupplier renderPredicate;
    private final Supplier<String> tooltipSupplier;

    public DrawableGuiElement(Gui parent, ResourceLocation spriteLocation, Rectangle4i sprite, Point location, AnimationDirection animDirection, Supplier<Pair<Integer, Integer>> animationSupplier, BooleanSupplier renderPredicate, Supplier<String> tooltipSupplier) {
        this.parent = parent;
        this.SPRITE_LOCATION = spriteLocation;
        this.SPRITE = sprite;
        this.GUI_LOCATION = location;
        this.ANIMATION_DIRECTION = animDirection;
        this.animSupplier = animationSupplier;
        this.renderPredicate = renderPredicate;
        this.tooltipSupplier = tooltipSupplier;
    }

    public Rectangle4i getBounds() {
        return new Rectangle4i(this.GUI_LOCATION.x, this.GUI_LOCATION.y, this.SPRITE.w, this.SPRITE.h);
    }

    public void renderTooltip(Point mouse) {
        if (this.tooltipSupplier != null) {
            GuiDraw.drawTip((int)mouse.x, (int)mouse.y, (String)this.tooltipSupplier.get());
        }
    }

    public void draw() {
        if (!this.renderPredicate.getAsBoolean()) {
            return;
        }
        TextureUtils.changeTexture((ResourceLocation)this.SPRITE_LOCATION);
        int x = this.GUI_LOCATION.x;
        int y = this.GUI_LOCATION.y;
        Rectangle4i curSprite = new Rectangle4i();
        switch (this.ANIMATION_DIRECTION) {
            case STATIC: {
                curSprite.set(this.SPRITE.x, this.SPRITE.y, this.SPRITE.w, this.SPRITE.h);
                break;
            }
            case TOP_DOWN: {
                Pair<Integer, Integer> animContext = this.animSupplier.get();
                int s = DrawableGuiElement.scale((Integer)animContext.getLeft(), (Integer)animContext.getRight(), this.SPRITE.h);
                curSprite.set(this.SPRITE.x, this.SPRITE.y, this.SPRITE.w, s);
                break;
            }
            case BOTTOM_UP: {
                Pair<Integer, Integer> animContext = this.animSupplier.get();
                int s = DrawableGuiElement.scale((Integer)animContext.getLeft(), (Integer)animContext.getRight(), this.SPRITE.h);
                y += this.SPRITE.h - s;
                curSprite.set(this.SPRITE.x, this.SPRITE.y + (this.SPRITE.h - s), this.SPRITE.w, s);
                break;
            }
            case LEFT_RIGHT: {
                Pair<Integer, Integer> animContext = this.animSupplier.get();
                int s = DrawableGuiElement.scale((Integer)animContext.getLeft(), (Integer)animContext.getRight(), this.SPRITE.w);
                curSprite.set(this.SPRITE.x, this.SPRITE.y, s, this.SPRITE.h);
                break;
            }
            case RIGHT_LEFT: {
                Pair<Integer, Integer> animContext = this.animSupplier.get();
                int s = DrawableGuiElement.scale((Integer)animContext.getLeft(), (Integer)animContext.getRight(), this.SPRITE.w);
                x += this.SPRITE.w - s;
                curSprite.set(this.SPRITE.x + (this.SPRITE.w - s), this.SPRITE.y, s, this.SPRITE.h);
                break;
            }
        }
        this.parent.func_73729_b(x, y, curSprite.x, curSprite.y, curSprite.w, curSprite.h);
    }

    private static float scaleF(float num, float max, float pixels) {
        return num * pixels / max;
    }

    private static int scale(int num, int max, int pixels) {
        return num * pixels / max;
    }

    public static enum AnimationDirection {
        STATIC,
        TOP_DOWN,
        BOTTOM_UP,
        LEFT_RIGHT,
        RIGHT_LEFT;

    }
}

