/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.ArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingContext;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ISecondaryIngredientMatcher;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumType;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.CraftingContextFactory;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.SecondaryIngredientMatcher;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.MutuallyExclusiveStackHandlerWrapper;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntityBase;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntitySecondaryInputBase
extends TileEntityBase {
    protected ObservableStackHandler secondaryIngredientHandler;
    protected MutuallyExclusiveStackHandlerWrapper wrapper;

    protected TileEntitySecondaryInputBase() {
    }

    public TileEntitySecondaryInputBase(EnumType type) {
        super(type);
    }

    @Override
    protected void initialize(EnumType type) {
        super.initialize(type);
        this.secondaryIngredientHandler = new ObservableStackHandler(this.getSecondaryInputSlotCount());
        this.secondaryIngredientHandler.addObserver((stackHandler, slotIndex) -> {
            this.func_70296_d();
            this.triggerContainerRecipeUpdate();
        });
        this.wrapper = new MutuallyExclusiveStackHandlerWrapper((ItemStackHandler)this.secondaryIngredientHandler);
    }

    public IItemHandlerModifiable getSecondaryIngredientHandler() {
        return this.secondaryIngredientHandler;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.wrapper;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ICraftingContext getCraftingContext(EntityPlayer player) {
        return CraftingContextFactory.createContext(this, player, (IItemHandlerModifiable)this.secondaryIngredientHandler);
    }

    @Override
    public ISecondaryIngredientMatcher getSecondaryIngredientMatcher() {
        int slotCount = this.secondaryIngredientHandler.getSlots();
        ArrayList<IArtisanItemStack> inputs = new ArrayList<IArtisanItemStack>(slotCount);
        for (int i = 0; i < slotCount; ++i) {
            ItemStack itemStack = this.secondaryIngredientHandler.getStackInSlot(i);
            inputs.add(ArtisanItemStack.from(itemStack));
        }
        return new SecondaryIngredientMatcher(inputs);
    }

    @Override
    public List<ItemStack> getBlockBreakDrops() {
        List<ItemStack> drops = super.getBlockBreakDrops();
        for (int i = 0; i < this.secondaryIngredientHandler.getSlots(); ++i) {
            drops.add(this.secondaryIngredientHandler.getStackInSlot(i));
        }
        return drops;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.secondaryIngredientHandler.deserializeNBT(tag.func_74775_l("secondaryIngredientHandler"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74782_a("secondaryIngredientHandler", (NBTBase)this.secondaryIngredientHandler.serializeNBT());
        return tag;
    }

    protected abstract int getSecondaryInputSlotCount();
}

