/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.recipe.copy;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.ArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IRecipeBuilder;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.InputReplacements;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.RecipeBuilderException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class RecipeBuilderCopyHelper {
    public static IRecipeBuilder copyRecipeInput(IRecipe recipe, InputReplacements inputReplacements, IRecipeBuilder builder) throws RecipeBuilderException {
        if (recipe instanceof IShapedRecipe) {
            return RecipeBuilderCopyHelper.copyShapedRecipeInput((IShapedRecipe)recipe, inputReplacements, builder);
        }
        return RecipeBuilderCopyHelper.copyShapelessRecipeInput(recipe, inputReplacements, builder);
    }

    public static IRecipeBuilder copyShapedRecipeInput(IShapedRecipe recipe, InputReplacements inputReplacements, IRecipeBuilder builder) throws RecipeBuilderException {
        int col;
        int width = recipe.getRecipeWidth();
        int height = recipe.getRecipeHeight();
        NonNullList ingredients = recipe.func_192400_c();
        IArtisanIngredient[][] convertedIngredients = new IArtisanIngredient[height][width];
        int index = 0;
        for (int row = 0; row < height; ++row) {
            for (col = 0; col < width; ++col) {
                convertedIngredients[row][col] = ArtisanIngredient.from((Ingredient)ingredients.get(index));
                ++index;
            }
        }
        width = Math.max(width, inputReplacements.getWidth());
        height = Math.max(height, inputReplacements.getHeight());
        IArtisanIngredient[][] replacedIngredients = new IArtisanIngredient[height][width];
        for (col = 0; col < width; ++col) {
            for (int row = 0; row < height; ++row) {
                replacedIngredients[row][col] = row >= convertedIngredients.length ? inputReplacements.replace(col, row, null) : (col >= convertedIngredients[row].length ? inputReplacements.replace(col, row, null) : inputReplacements.replace(col, row, convertedIngredients[row][col]));
            }
        }
        builder.setIngredients(replacedIngredients);
        return builder;
    }

    public static IRecipeBuilder copyShapelessRecipeInput(IRecipe recipe, InputReplacements inputReplacements, IRecipeBuilder builder) throws RecipeBuilderException {
        NonNullList ingredients = recipe.func_192400_c();
        IArtisanIngredient[] convertedIngredients = new IArtisanIngredient[ingredients.size()];
        for (int i = 0; i < convertedIngredients.length; ++i) {
            convertedIngredients[i] = inputReplacements.replace(ArtisanIngredient.from((Ingredient)ingredients.get(i)));
        }
        builder.setIngredients(convertedIngredients);
        return builder;
    }

    public static IRecipeBuilder copyRecipeOutput(IRecipe recipe, IRecipeBuilder builder) throws RecipeBuilderException {
        builder.addOutput(ArtisanItemStack.from(recipe.func_77571_b().func_77946_l()), 1);
        return builder;
    }

    public static IRecipeBuilder replaceRecipeOutput(IRecipe recipe, IArtisanItemStack toReplace, IRecipeBuilder builder) throws RecipeBuilderException {
        ItemStack itemStack = toReplace.toItemStack();
        int count = recipe.func_77571_b().func_190916_E();
        itemStack.func_190920_e(count);
        builder.addOutput(ArtisanItemStack.from(itemStack), 1);
        return builder;
    }

    private RecipeBuilderCopyHelper() {
    }
}

