/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.integration.gamestages;

import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.RecipeRegistry;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirement;
import com.codetaylor.mc.artisanworktables.modules.requirement.gamestages.requirement.GameStagesRequirement;
import com.codetaylor.mc.artisanworktables.modules.requirement.gamestages.requirement.GameStagesRequirementContext;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.gamestages.GameStagesHelper;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei.PluginJEI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.darkhax.gamestages.event.GameStageEvent;
import net.darkhax.gamestages.event.StagesSyncedEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PluginGameStages {
    public PluginGameStages() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void gameStageAddedEvent(GameStageEvent.Added event) {
        this.processStagedRecipes();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void gameStageRemovedEvent(GameStageEvent.Removed event) {
        this.processStagedRecipes();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void gameStageClientSyncEvent(StagesSyncedEvent event) {
        this.processStagedRecipes();
    }

    @SideOnly(value=Side.CLIENT)
    private void processStagedRecipes() {
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (PluginJEI.RECIPE_REGISTRY == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Collection<String> unlockedStages = GameStagesHelper.getUnlockedStages((EntityPlayer)player);
        GameStagesRequirementContext context = (GameStagesRequirementContext)ArtisanAPI.getRequirementContext(new ResourceLocation("artisanworktables", "gamestages"));
        context.setUnlockedStages(unlockedStages);
        for (String name : ArtisanAPI.getWorktableNames()) {
            RecipeRegistry registry = ArtisanAPI.getWorktableRecipeRegistry(name);
            if (registry == null) continue;
            for (EnumTier tier : EnumTier.values()) {
                List<IArtisanRecipe> recipeList = registry.getRecipeListByTier(tier, new ArrayList<IArtisanRecipe>());
                String uid = PluginJEI.createUID(name, tier);
                for (IArtisanRecipe recipe : recipeList) {
                    IRecipeWrapper recipeWrapper = PluginJEI.RECIPE_REGISTRY.getRecipeWrapper((Object)recipe, uid);
                    if (recipeWrapper == null) continue;
                    IRequirement requirement = recipe.getRequirement(GameStagesRequirement.LOCATION);
                    if (requirement == null || requirement.match(context)) {
                        PluginJEI.RECIPE_REGISTRY.unhideRecipe(recipeWrapper, uid);
                        continue;
                    }
                    PluginJEI.RECIPE_REGISTRY.hideRecipe(recipeWrapper, uid);
                }
            }
        }
    }
}

