/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingMatrixStackHandler;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.recipes.ICraftingInventory;
import net.minecraft.item.ItemStack;

public class CTArtisanCraftingInventory
implements ICraftingInventory {
    private final IPlayer player;
    private final ICraftingMatrixStackHandler craftingMatrixStackHandler;

    CTArtisanCraftingInventory(IPlayer player, ICraftingMatrixStackHandler craftingMatrixStackHandler) {
        this.player = player;
        this.craftingMatrixStackHandler = craftingMatrixStackHandler;
    }

    public IPlayer getPlayer() {
        return this.player;
    }

    public int getSize() {
        return this.craftingMatrixStackHandler.getSlots();
    }

    public int getWidth() {
        return this.craftingMatrixStackHandler.getWidth();
    }

    public int getHeight() {
        return this.craftingMatrixStackHandler.getHeight();
    }

    public int getStackCount() {
        int stackCount = 0;
        for (int index = 0; index < this.getSize(); ++index) {
            if (this.craftingMatrixStackHandler.getStackInSlot(index).func_190926_b()) continue;
            ++stackCount;
        }
        return stackCount;
    }

    public IItemStack getStack(int i) {
        return CraftTweakerMC.getIItemStack((ItemStack)this.craftingMatrixStackHandler.getStackInSlot(i));
    }

    public IItemStack getStack(int x, int y) {
        return this.getStack(y + x * this.getWidth());
    }

    public void setStack(int x, int y, IItemStack stack) {
        this.setStack(y + x * this.getWidth(), stack);
    }

    public void setStack(int i, IItemStack stack) {
        this.craftingMatrixStackHandler.setStackInSlot(i, CraftTweakerMC.getItemStack((IItemStack)stack));
    }

    public IItemStack[][] getItems() {
        IItemStack[][] output = new IItemStack[this.getHeight()][this.getWidth()];
        IItemStack[] oneDimensional = this.getItemArray();
        for (int row = 0; row < this.getHeight(); ++row) {
            for (int column = 0; column < this.getWidth(); ++column) {
                output[row][column] = oneDimensional[row * this.getWidth() + column];
            }
        }
        return output;
    }

    public IItemStack[] getItemArray() {
        IItemStack[] items = new IItemStack[this.getSize()];
        for (int index = 0; index < this.getSize(); ++index) {
            items[index] = this.getStack(index);
        }
        return items;
    }

    public ICraftingMatrixStackHandler getInternal() {
        return this.craftingMatrixStackHandler;
    }
}

