/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.gui;

import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumType;
import com.codetaylor.mc.artisanworktables.modules.toolbox.tile.TileEntityToolbox;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.Container;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementDesignersSide;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementFluidTankSmall;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementMageEffect;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementTabs;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementToolboxSide;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.ITileEntityDesigner;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntityBase;
import com.codetaylor.mc.athenaeum.gui.ContainerBase;
import com.codetaylor.mc.athenaeum.gui.GuiHelper;
import com.codetaylor.mc.athenaeum.gui.Texture;
import com.codetaylor.mc.athenaeum.gui.element.GuiElementBase;
import com.codetaylor.mc.athenaeum.gui.element.GuiElementTextureRectangle;
import com.codetaylor.mc.athenaeum.gui.element.GuiElementTitle;
import java.awt.Color;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public abstract class GuiContainerBase
extends com.codetaylor.mc.athenaeum.gui.GuiContainerBase {
    protected final int textShadowColor;
    protected final TileEntityBase tileEntity;

    public GuiContainerBase(Container container, ResourceLocation backgroundTexture, String titleKey, int textShadowColor, TileEntityBase tileEntity, int width, int height) {
        super((ContainerBase)container, width, height);
        TileEntityToolbox toolbox;
        this.tileEntity = tileEntity;
        this.textShadowColor = textShadowColor;
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementTitle((com.codetaylor.mc.athenaeum.gui.GuiContainerBase)this, titleKey, 8, 6)});
        this.addInventoryTitleElement();
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementTextureRectangle((com.codetaylor.mc.athenaeum.gui.GuiContainerBase)this, new Texture(backgroundTexture, 0, 0, 256, 256), 0, 0, this.field_146999_f, this.field_147000_g)});
        if (this.tileEntity.getType() == EnumType.MAGE) {
            this.addMageEffectElement(container);
        }
        this.addFluidTankElement();
        ITileEntityDesigner designersTable = container.getDesignersTable();
        if (designersTable != null && container.canPlayerUsePatternSlots()) {
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementDesignersSide(this, designersTable, designersTable.getTexturePatternSide(), -70, 0)});
        }
        if ((toolbox = container.getToolbox()) != null && container.canPlayerUseToolbox()) {
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementToolboxSide(this, toolbox, toolbox.getTextureSide(), -70, () -> designersTable != null && container.canPlayerUsePatternSlots() ? 33 : 0)});
        }
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementTabs(this, this.tileEntity, 176)});
    }

    protected void addInventoryTitleElement() {
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementTitle((com.codetaylor.mc.athenaeum.gui.GuiContainerBase)this, "container.inventory", 8, this.field_147000_g - 93)});
    }

    protected void addMageEffectElement(Container container) {
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementMageEffect(this, container, 115, 35)});
    }

    protected void addFluidTankElement() {
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementFluidTankSmall(this, this.tileEntity.getTank(), this.tileEntity.func_174877_v(), this.textShadowColor, 8, 17)});
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void drawString(String translateKey, int x, int y) {
        FontRenderer fontRenderer = this.field_146289_q;
        if (this.tileEntity.getType() == EnumType.MAGE) {
            fontRenderer = this.field_146297_k.field_71464_q;
        }
        if (this.tileEntity.getType() == EnumType.DESIGNER) {
            String displayText = I18n.func_135052_a((String)translateKey, (Object[])new Object[0]);
            fontRenderer.func_78276_b(displayText, x - 1, y, Color.WHITE.getRGB());
        } else {
            GuiHelper.drawStringOutlined((String)translateKey, (int)x, (int)y, (FontRenderer)fontRenderer, (int)this.textShadowColor);
        }
    }
}

