/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables;

import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntityBase;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;

public class Util {
    public static final Matrix4f EMPTY_MATRIX_TRANSFORM = Util.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f).getMatrix();
    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> DEFAULT_ITEM_TRANSFORM;

    public static TRSRTransformation getTransform(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getDefaultItemTransforms() {
        if (DEFAULT_ITEM_TRANSFORM != null) {
            return DEFAULT_ITEM_TRANSFORM;
        }
        DEFAULT_ITEM_TRANSFORM = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)Util.getTransform(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)Util.getTransform(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)Util.getTransform(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)Util.getTransform(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)Util.getTransform(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f)).put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)Util.getTransform(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f)).build();
        return DEFAULT_ITEM_TRANSFORM;
    }

    public static List<TileEntityBase> getJoinedTables(List<TileEntityBase> result, World world, BlockPos pos, @Nullable EntityPlayer player) {
        BlockPos searchPosition;
        TreeMap<String, TileEntityBase> joinedTableMap = new TreeMap<String, TileEntityBase>();
        HashSet<BlockPos> searchedPositionSet = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> toSearchQueue = new ArrayDeque<BlockPos>();
        toSearchQueue.offer(pos);
        toSearchQueue.offer(pos.func_177972_a(EnumFacing.NORTH));
        toSearchQueue.offer(pos.func_177972_a(EnumFacing.EAST));
        toSearchQueue.offer(pos.func_177972_a(EnumFacing.SOUTH));
        toSearchQueue.offer(pos.func_177972_a(EnumFacing.WEST));
        while ((searchPosition = (BlockPos)toSearchQueue.poll()) != null) {
            if (searchedPositionSet.contains(searchPosition)) continue;
            searchedPositionSet.add(searchPosition);
            TileEntity tileEntity = world.func_175625_s(searchPosition);
            if (!(tileEntity instanceof TileEntityBase)) continue;
            String key = ((TileEntityBase)tileEntity).getUuid();
            if (joinedTableMap.containsKey(key)) {
                return Collections.emptyList();
            }
            if (player == null || ((TileEntityBase)tileEntity).canPlayerUse(player)) {
                joinedTableMap.put(key, (TileEntityBase)tileEntity);
            }
            toSearchQueue.offer(tileEntity.func_174877_v().func_177972_a(EnumFacing.NORTH));
            toSearchQueue.offer(tileEntity.func_174877_v().func_177972_a(EnumFacing.EAST));
            toSearchQueue.offer(tileEntity.func_174877_v().func_177972_a(EnumFacing.SOUTH));
            toSearchQueue.offer(tileEntity.func_174877_v().func_177972_a(EnumFacing.WEST));
        }
        result.addAll(joinedTableMap.values());
        return result;
    }
}

