/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.tools;

import com.codetaylor.mc.artisanworktables.ModArtisanWorktables;
import com.codetaylor.mc.artisanworktables.modules.tools.ModuleToolsConfig;
import com.codetaylor.mc.artisanworktables.modules.tools.item.ItemWorktableTool;
import com.codetaylor.mc.artisanworktables.modules.tools.material.CustomMaterial;
import com.codetaylor.mc.artisanworktables.modules.tools.material.CustomMaterialConverter;
import com.codetaylor.mc.artisanworktables.modules.tools.material.CustomMaterialListConverter;
import com.codetaylor.mc.artisanworktables.modules.tools.material.CustomMaterialValidator;
import com.codetaylor.mc.artisanworktables.modules.tools.material.DataCustomMaterialList;
import com.codetaylor.mc.artisanworktables.modules.tools.material.DataCustomMaterialListFactory;
import com.codetaylor.mc.artisanworktables.modules.tools.recipe.ModuleToolsRecipes;
import com.codetaylor.mc.artisanworktables.modules.tools.reference.EnumWorktableToolType;
import com.codetaylor.mc.athenaeum.module.ModuleBase;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.athenaeum.registry.Registry;
import com.codetaylor.mc.athenaeum.util.FileHelper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class ModuleTools
extends ModuleBase {
    public static final String MOD_ID = "artisanworktables";
    public static final CreativeTabs CREATIVE_TAB = ModArtisanWorktables.CREATIVE_TAB;
    private final List<ItemWorktableTool> registeredToolList = new ArrayList<ItemWorktableTool>();
    private List<CustomMaterial> materialList = Collections.emptyList();

    public ModuleTools() {
        super(0, MOD_ID);
        this.setRegistry(new Registry(MOD_ID, CREATIVE_TAB));
        this.enableAutoRegistry();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreInitializationEvent(FMLPreInitializationEvent event) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File configurationDirectory = event.getModConfigurationDirectory();
        Path configurationPath = Paths.get(configurationDirectory.toString(), MOD_ID);
        if (!Files.exists(configurationPath, new LinkOption[0])) {
            try {
                Files.createDirectories(configurationPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                event.getModLog().error("", (Throwable)e);
            }
        }
        Path generatedPath = Paths.get(configurationPath.toString(), "artisanworktables.module.Tools.Materials.Generated.json");
        Path customPath = Paths.get(configurationPath.toString(), "artisanworktables.module.Tools.Materials.Custom.json");
        if (Files.exists(generatedPath, new LinkOption[0])) {
            try {
                Files.delete(generatedPath);
            }
            catch (IOException e) {
                event.getModLog().error("", (Throwable)e);
            }
        }
        BufferedWriter writer = null;
        try {
            writer = Files.newBufferedWriter(generatedPath, new OpenOption[0]);
            gson.toJson((Object)new DataCustomMaterialListFactory().create(), (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            try {
                event.getModLog().error("", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileHelper.closeSilently(writer);
                throw throwable;
            }
            FileHelper.closeSilently((Closeable)writer);
        }
        FileHelper.closeSilently((Closeable)writer);
        if (!Files.exists(customPath, new LinkOption[0])) {
            try {
                Files.copy(generatedPath, customPath, new CopyOption[0]);
            }
            catch (IOException e) {
                event.getModLog().error("", (Throwable)e);
            }
        }
        BufferedReader reader = null;
        try {
            reader = Files.newBufferedReader(customPath);
            DataCustomMaterialList dataCustomMaterialList = (DataCustomMaterialList)gson.fromJson((Reader)reader, DataCustomMaterialList.class);
            CustomMaterialListConverter customMaterialListConverter = new CustomMaterialListConverter(new CustomMaterialValidator(), new CustomMaterialConverter(new RecipeItemParser()));
            this.materialList = customMaterialListConverter.convert(dataCustomMaterialList, event.getModLog());
        }
        catch (IOException e) {
            event.getModLog().error("", (Throwable)e);
        }
        finally {
            FileHelper.closeSilently((Closeable)reader);
        }
        super.onPreInitializationEvent(event);
    }

    public void onRegister(Registry registry) {
        super.onRegister(registry);
        ArrayList<String> allowedToolTypeList = new ArrayList<String>();
        allowedToolTypeList.addAll(Arrays.asList(ModuleToolsConfig.ENABLED_TOOL_TYPES));
        if (allowedToolTypeList.isEmpty()) {
            return;
        }
        if (this.materialList.isEmpty()) {
            return;
        }
        for (EnumWorktableToolType type : EnumWorktableToolType.values()) {
            String typeName = type.getName();
            if (!allowedToolTypeList.contains(typeName)) continue;
            for (CustomMaterial material : this.materialList) {
                String materialName = material.getDataCustomMaterial().getName();
                ItemWorktableTool item = new ItemWorktableTool(type, material);
                this.registeredToolList.add(item);
                ResourceLocation registryName = new ResourceLocation(MOD_ID, typeName + "_" + materialName);
                registry.registerItem((Item)item, registryName);
                item.func_77655_b(registryName.func_110624_b().replaceAll("_", ".") + "." + typeName.replaceAll("_", "."));
            }
        }
        registry.registerItemRegistrationStrategy(forgeRegistry -> {
            ItemStack itemStack;
            if (ModuleToolsConfig.ENABLE_TOOL_TYPE_ORE_DICT_GROUPS) {
                for (ItemWorktableTool item : this.registeredToolList) {
                    itemStack = new ItemStack((Item)item, 1, Short.MAX_VALUE);
                    OreDictionary.registerOre((String)(ModuleToolsConfig.TOOL_BY_TYPE_ORE_DICT_PREFIX + item.getType().getOreDictSuffix()), (ItemStack)itemStack);
                }
            }
            if (ModuleToolsConfig.ENABLE_TOOL_MATERIAL_ORE_DICT_GROUPS) {
                for (ItemWorktableTool item : this.registeredToolList) {
                    itemStack = new ItemStack((Item)item, 1, Short.MAX_VALUE);
                    OreDictionary.registerOre((String)item.getMaterial().getDataCustomMaterial().getOreDictKey(), (ItemStack)itemStack);
                }
            }
        });
    }

    public void onClientRegister(Registry registry) {
        super.onClientRegister(registry);
        registry.registerClientModelRegistrationStrategy(() -> {
            for (ItemWorktableTool item : this.registeredToolList) {
                String resourcePath = item.getMaterial().getDataCustomMaterial().isShiny() ? item.getName() + "_highlighted" : item.getName();
                ResourceLocation location = new ResourceLocation(MOD_ID, resourcePath);
                ModelResourceLocation modelResourceLocation = new ModelResourceLocation(location, "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)modelResourceLocation);
            }
        });
    }

    @SubscribeEvent
    public void onRegisterRecipesEvent(RegistryEvent.Register<IRecipe> event) {
        if (ModuleToolsConfig.ENABLE_TOOL_RECIPES && !this.registeredToolList.isEmpty()) {
            ModuleToolsRecipes.register((IForgeRegistry<IRecipe>)event.getRegistry(), MOD_ID, this.registeredToolList);
        }
    }

    public void onClientInitializationEvent(FMLInitializationEvent event) {
        super.onClientInitializationEvent(event);
        if (this.registeredToolList.isEmpty()) {
            return;
        }
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        itemColors.func_186730_a((stack, tintIndex) -> tintIndex == 1 ? ((ItemWorktableTool)stack.func_77973_b()).getMaterial().getColor() : 0xFFFFFF, (Item[])this.registeredToolList.toArray(new ItemWorktableTool[this.registeredToolList.size()]));
    }

    public static final class Lang {
        public static final String TOOLTIP_DURABILITY = "item.artisanworktables.tooltip.durability";
    }
}

