/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.requirement.gamestages.requirement;

import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirement;
import com.codetaylor.mc.artisanworktables.modules.requirement.gamestages.requirement.GameStagesRequirementContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class GameStagesRequirement
implements IRequirement<GameStagesRequirementContext> {
    public static final String REQUIREMENT_ID = "gamestages";
    public static final ResourceLocation LOCATION = new ResourceLocation("artisanworktables", "gamestages");
    private final List<String> requireAllStages;
    private final List<String> requireOneStage;
    private final List<String> excludeStages;

    GameStagesRequirement(@Nonnull Collection<String> requireAllStages, @Nonnull Collection<String> requireOneStage, @Nonnull Collection<String> excludeStages) {
        this.requireAllStages = new ArrayList<String>(requireAllStages);
        this.requireOneStage = new ArrayList<String>(requireOneStage);
        this.excludeStages = new ArrayList<String>(excludeStages);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return LOCATION;
    }

    @Override
    public boolean match(GameStagesRequirementContext context) {
        Set<String> unlockedStages = context.getUnlockedStages();
        for (String excludedStage : this.excludeStages) {
            if (!unlockedStages.contains(excludedStage)) continue;
            return false;
        }
        if (!this.requireAllStages.isEmpty() && !unlockedStages.containsAll(this.requireAllStages)) {
            return false;
        }
        for (String oneStage : this.requireOneStage) {
            if (!unlockedStages.contains(oneStage)) continue;
            return true;
        }
        return this.requireOneStage.isEmpty();
    }
}

