/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.api.internal.reference;

import com.codetaylor.mc.athenaeum.spi.IVariant;
import java.awt.Color;
import java.util.Comparator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;

public enum EnumType implements IVariant
{
    TAILOR(0, "tailor", SoundType.field_185854_g, new Color(172, 81, 227).getRGB(), 1),
    CARPENTER(1, "carpenter", SoundType.field_185848_a, new Color(188, 152, 98).getRGB(), 2),
    MASON(2, "mason", SoundType.field_185851_d, new Color(151, 151, 151).getRGB(), 4),
    BLACKSMITH(3, "blacksmith", SoundType.field_185858_k, new Color(162, 162, 162).getRGB(), 5),
    JEWELER(4, "jeweler", SoundType.field_185852_e, new Color(105, 89, 133).getRGB(), 3),
    BASIC(5, "basic", SoundType.field_185848_a, new Color(188, 152, 98).getRGB(), 0),
    ENGINEER(6, "engineer", SoundType.field_185858_k, new Color(202, 103, 27).getRGB(), 6),
    MAGE(7, "mage", SoundType.field_185854_g, new Color(172, 81, 227).getRGB(), 7),
    SCRIBE(8, "scribe", SoundType.field_185848_a, new Color(182, 136, 79).getRGB(), 8),
    CHEMIST(9, "chemist", SoundType.field_185852_e, new Color(71, 97, 71).getRGB(), 9),
    FARMER(10, "farmer", SoundType.field_185849_b, new Color(128, 198, 82).getRGB(), 10),
    CHEF(11, "chef", SoundType.field_185851_d, new Color(255, 255, 255).getRGB(), 11),
    DESIGNER(12, "designer", SoundType.field_185851_d, new Color(255, 255, 255).getRGB(), 12),
    TANNER(13, "tanner", SoundType.field_185851_d, new Color(199, 125, 79).getRGB(), 13),
    POTTER(14, "potter", SoundType.field_185851_d, new Color(183, 90, 64).getRGB(), 14);

    private static final EnumType[] META_LOOKUP;
    public static final String[] NAMES;
    private final int meta;
    private final String name;
    private SoundType soundType;
    private int textOutlineColor;
    private int guiTabTextureOffsetY;

    private EnumType(int meta, String name, SoundType soundType, int textOutlineColor, int guiTabTextureOffsetY) {
        this.meta = meta;
        this.name = name;
        this.soundType = soundType;
        this.textOutlineColor = textOutlineColor;
        this.guiTabTextureOffsetY = guiTabTextureOffsetY;
    }

    public int getMeta() {
        return this.meta;
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    public SoundType getSoundType() {
        return this.soundType;
    }

    public int getTextOutlineColor() {
        return this.textOutlineColor;
    }

    public int getGuiTabTextureOffsetY() {
        return this.guiTabTextureOffsetY;
    }

    public static EnumType fromName(String name) {
        EnumType[] values = EnumType.values();
        name = name.toLowerCase();
        for (EnumType value : values) {
            if (!value.name.equals(name)) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown name: " + name);
    }

    public static EnumType fromMeta(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    static {
        META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        NAMES = (String[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).map(EnumType::func_176610_l).toArray(String[]::new);
    }
}

