/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.inventory;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import squeek.spiceoflife.inventory.SlotLocked;

public abstract class ContainerGeneric
extends Container {
    protected IInventory inventory;
    protected int nextSlotIndex = 0;
    protected boolean allowShiftClickToMultipleSlots = false;

    public ContainerGeneric(IInventory inventory) {
        this.inventory = inventory;
    }

    protected void addSlot(IInventory inventory, int xStart, int yStart) {
        this.addSlotOfType(Slot.class, inventory, xStart, yStart);
    }

    protected void addSlots(IInventory inventory, int xStart, int yStart) {
        this.addSlotsOfType(Slot.class, inventory, xStart, yStart, 1);
    }

    protected void addSlots(IInventory inventory, int xStart, int yStart, int rows) {
        this.addSlotsOfType(Slot.class, inventory, xStart, yStart, rows);
    }

    protected void addSlots(IInventory inventory, int xStart, int yStart, int numSlots, int rows) {
        this.addSlotsOfType(Slot.class, inventory, xStart, yStart, numSlots, rows);
    }

    protected void addSlotOfType(Class<? extends Slot> slotClass, IInventory inventory, int xStart, int yStart) {
        this.addSlotsOfType(slotClass, inventory, xStart, yStart, 1, 1);
    }

    protected void addSlotsOfType(Class<? extends Slot> slotClass, IInventory inventory, int xStart, int yStart) {
        this.addSlotsOfType(slotClass, inventory, xStart, yStart, inventory.func_70302_i_(), 1);
    }

    protected void addSlotsOfType(Class<? extends Slot> slotClass, IInventory inventory, int xStart, int yStart, int rows) {
        this.addSlotsOfType(slotClass, inventory, xStart, yStart, inventory.func_70302_i_(), rows);
    }

    protected void addSlotsOfType(Class<? extends Slot> slotClass, IInventory inventory, int xStart, int yStart, int numSlots, int rows) {
        int numSlotsPerRow = numSlots / rows;
        int i = 0;
        int col = 0;
        int row = 0;
        while (i < numSlots) {
            if (col >= numSlotsPerRow) {
                ++row;
                col = 0;
            }
            try {
                this.func_75146_a(slotClass.getConstructor(IInventory.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(inventory, this.getNextSlotIndex(), xStart + col * 18, yStart + row * 18));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
            ++col;
        }
    }

    protected int getNextSlotIndex() {
        ++this.nextSlotIndex;
        return this.nextSlotIndex - 1;
    }

    protected void addPlayerInventorySlots(InventoryPlayer playerInventory, int yStart) {
        this.addPlayerInventorySlots(playerInventory, 8, yStart);
    }

    protected void addPlayerInventorySlots(InventoryPlayer playerInventory, int xStart, int yStart) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, xStart + col * 18, yStart + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addHotbarSlot(playerInventory, col, xStart + col * 18, yStart + 58);
        }
    }

    protected void addHotbarSlot(InventoryPlayer playerInventory, int slotNum, int x, int y) {
        this.func_75146_a(new Slot((IInventory)playerInventory, slotNum, x, y));
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (clickTypeIn == ClickType.SWAP && dragType >= 0 && dragType < 9) {
            int hotbarSlotIndex = this.field_75151_b.size() - 9 + dragType;
            Slot hotbarSlot = this.func_75139_a(hotbarSlotIndex);
            Slot swapSlot = this.func_75139_a(slotId);
            if (hotbarSlot instanceof SlotLocked || swapSlot instanceof SlotLocked) {
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotNum) {
        Slot slot = (Slot)this.field_75151_b.get(slotNum);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackToTransfer = slot.func_75211_c();
            if (slotNum < this.inventory.func_70302_i_() ? !this.func_75135_a(stackToTransfer, this.inventory.func_70302_i_(), this.field_75151_b.size(), true) : !this.func_75135_a(stackToTransfer, 0, this.inventory.func_70302_i_(), false)) {
                return ItemStack.field_190927_a;
            }
            if (stackToTransfer.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (this.allowShiftClickToMultipleSlots) {
                return stackToTransfer;
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }
}

