/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.gui.controls.gui;

import com.creativemd.creativecore.gui.GuiRenderHelper;
import com.creativemd.creativecore.gui.client.style.Style;
import com.creativemd.creativecore.gui.container.GuiParent;
import net.minecraft.init.SoundEvents;

public class GuiScrollBox
extends GuiParent {
    public int maxScroll = 0;
    public int aimedScrolled = 0;
    public double scrolled = 0.0;
    public double beforeScrolled = 0.0;
    public static final long scrollTime = 200L;
    public long scrollMS = 0L;
    public float scaleFactor;
    public boolean dragged;
    public int scrollbarWidth = 6;

    public GuiScrollBox(String name, int x, int y, int width, int height) {
        this(name, x, y, width, height, 1.0f);
    }

    public GuiScrollBox(String name, int x, int y, int width, int height, float scaleFactor) {
        super(name, x, y, width, height);
        this.scaleFactor = scaleFactor;
        this.marginWidth = 0;
    }

    @Override
    public float getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    protected double getOffsetY() {
        return -this.scrolled;
    }

    public void onScrolled() {
        if (this.aimedScrolled < 0) {
            this.aimedScrolled = 0;
        }
        if (this.aimedScrolled > this.maxScroll) {
            this.aimedScrolled = this.maxScroll;
        }
    }

    @Override
    public boolean mouseScrolled(int x, int y, int scrolled) {
        if (super.mouseScrolled(x, y, scrolled)) {
            return true;
        }
        this.scrollMS = System.currentTimeMillis();
        this.aimedScrolled -= scrolled * 20;
        this.onScrolled();
        this.beforeScrolled = this.scrolled;
        return true;
    }

    @Override
    public boolean mousePressed(int x, int y, int button) {
        if (button == 0 && this.width - x + this.posX <= this.scrollbarWidth && this.needsScrollbar()) {
            GuiScrollBox.playSound(SoundEvents.field_187909_gi);
            this.dragged = true;
            return true;
        }
        return super.mousePressed(x, y, button);
    }

    @Override
    public void mouseMove(int x, int y, int button) {
        if (this.dragged) {
            double percent = (double)(y - this.posY) / (double)this.height;
            this.aimedScrolled = (int)(percent * (double)this.maxScroll);
            this.scrollMS = System.currentTimeMillis();
            this.onScrolled();
            this.beforeScrolled = this.scrolled;
        }
        super.mouseMove(x, y, button);
    }

    @Override
    public void mouseReleased(int x, int y, int button) {
        super.mouseReleased(x, y, button);
        this.dragged = false;
    }

    public boolean needsScrollbar() {
        return this.lastRenderedHeight > this.height - this.getContentOffset() * 2;
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        super.renderContent(helper, style, width - this.scrollbarWidth, height);
        style.getBorder(this).renderStyle(width - this.scrollbarWidth, 0, helper, this.scrollbarWidth, height);
        style.getMouseOverBackground(this).renderStyle(width - this.scrollbarWidth + 1, 0, helper, this.scrollbarWidth - 1, height);
        if (this.scrollMS != 0L) {
            if (this.scrollMS + 200L <= System.currentTimeMillis()) {
                this.beforeScrolled = this.scrolled = (double)this.aimedScrolled;
                this.scrollMS = 0L;
            } else {
                this.scrolled = this.beforeScrolled + ((double)this.aimedScrolled - this.beforeScrolled) * ((double)(System.currentTimeMillis() - this.scrollMS) / 200.0);
            }
        }
        int scrollThingHeight = Math.max(10, Math.min(height, this.lastRenderedHeight / height / height));
        if (this.lastRenderedHeight < height) {
            scrollThingHeight = height;
        }
        double percent = this.scrolled / (double)this.maxScroll;
        style.getFace(this).renderStyle(width - this.scrollbarWidth + 1, (int)(percent * (double)(height - scrollThingHeight)), helper, this.scrollbarWidth - 1, scrollThingHeight);
        this.maxScroll = Math.max(0, this.lastRenderedHeight - height) + 5;
    }

    @Override
    public boolean hasMouseOverEffect() {
        return false;
    }
}

