/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.stack;

import com.creativemd.creativecore.common.utils.stack.InfoBlock;
import com.creativemd.creativecore.common.utils.stack.InfoItemStack;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class InfoMaterial
extends InfoStack {
    public Material material;

    public InfoMaterial(Material material, int stackSize) {
        super(stackSize);
        this.material = material;
    }

    public InfoMaterial(Material material) {
        this(material, 1);
    }

    public InfoMaterial() {
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        ResourceLocation blockName = null;
        for (Block block : Block.field_149771_c) {
            if (block == null || block.func_176223_P().func_185904_a() != this.material) continue;
            blockName = block.getRegistryName();
            break;
        }
        if (blockName != null) {
            nbt.func_74778_a("material", blockName.toString());
        }
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        Block block = Block.func_149684_b((String)nbt.func_74779_i("material"));
        if (block != null) {
            this.material = block.func_176223_P().func_185904_a();
        }
    }

    @Override
    public boolean isInstanceIgnoreSize(InfoStack info) {
        Block block;
        if (info instanceof InfoMaterial) {
            return ((InfoMaterial)info).material == this.material;
        }
        if (info instanceof InfoBlock) {
            return ((InfoBlock)info).block.func_176223_P().func_185904_a() == this.material;
        }
        if (info instanceof InfoItemStack && (block = Block.func_149634_a((Item)((InfoItemStack)info).stack.func_77973_b())) != null) {
            return block.func_176203_a(((InfoItemStack)info).stack.func_77960_j()).func_185904_a() == this.material;
        }
        return false;
    }

    @Override
    public InfoStack copy() {
        return new InfoMaterial(this.material, this.stackSize);
    }

    @Override
    public ItemStack getItemStack(int stacksize) {
        for (Block block : Block.field_149771_c) {
            if (block == null || block.func_176223_P().func_185904_a() != this.material) continue;
            NonNullList stacks = NonNullList.func_191196_a();
            try {
                block.func_149666_a((CreativeTabs)displayOnCreativeTab.get(block), stacks);
                if (stacks.isEmpty() || ((ItemStack)stacks.get(0)).func_190926_b()) continue;
                return ((ItemStack)stacks.get(0)).func_77946_l();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected boolean isStackInstanceIgnoreSize(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block != null && !(block instanceof BlockAir)) {
            return block.func_176203_a(stack.func_77960_j()).func_185904_a() == this.material;
        }
        return false;
    }

    @Override
    public boolean equalsIgnoreSize(Object object) {
        return object instanceof InfoMaterial && ((InfoMaterial)((Object)object)).material == this.material;
    }

    @Override
    public ArrayList<ItemStack> getAllPossibleItemStacks() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        NonNullList stacks = NonNullList.func_191196_a();
        for (Block block : Block.field_149771_c) {
            try {
                block.func_149666_a((CreativeTabs)displayOnCreativeTab.get(block), stacks);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < stacks.size(); ++i) {
            if (!this.isInstanceIgnoreSize((ItemStack)stacks.get(i))) continue;
            result.add((ItemStack)stacks.get(i));
        }
        return result;
    }
}

