/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.CreativeSplittedMessageHandler;
import com.creativemd.creativecore.common.packet.PacketHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class CreativeMessageHandler
implements IMessage {
    public boolean isLast = true;
    public UUID uuid;
    public CreativeCorePacket packet = null;
    public MessageType type;
    public EntityPlayer player;
    public int amount;
    public ByteBuf content;

    public CreativeMessageHandler() {
    }

    public CreativeMessageHandler(CreativeCorePacket packet, MessageType type, EntityPlayer player) {
        this.packet = packet;
        this.type = type;
        this.player = player;
    }

    public void fromBytes(ByteBuf buf) {
        this.isLast = buf.readBoolean();
        String id = CreativeCorePacket.readString(buf);
        Class<? extends CreativeCorePacket> PacketClass = CreativeCorePacket.getClassByID(id);
        this.packet = null;
        try {
            this.packet = PacketClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Invalid packet id=" + id);
        }
        if (this.isLast) {
            if (this.packet != null) {
                this.packet.readBytes(buf);
            }
        } else {
            this.amount = buf.readInt();
            this.uuid = UUID.fromString(CreativeCorePacket.readString(buf));
            int length = buf.readInt();
            this.content = ByteBufAllocator.DEFAULT.buffer();
            byte[] data = new byte[length];
            buf.readBytes(data);
            this.content.writeBytes(data);
        }
    }

    public void toBytes(ByteBuf buf) {
        this.content = ByteBufAllocator.DEFAULT.buffer();
        this.packet.writeBytes(this.content);
        int packetSize = 31767;
        if (this.type.getSide().isServer()) {
            packetSize = CreativeCorePacket.maxPacketSize;
        }
        if (packetSize > this.content.writerIndex()) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)CreativeCorePacket.getIDByClass(this.packet));
            buf.writeBytes(this.content);
        } else {
            this.amount = (int)Math.ceil((double)this.content.writerIndex() / (double)packetSize);
            this.uuid = UUID.randomUUID();
            String id = CreativeCorePacket.getIDByClass(this.packet);
            for (int i = 0; i < this.amount; ++i) {
                int length = Math.min(packetSize, this.content.writerIndex() - i * packetSize);
                if (i == 0) {
                    buf.writeBoolean(false);
                    CreativeCorePacket.writeString(buf, id);
                    buf.writeInt(this.amount);
                    CreativeCorePacket.writeString(buf, this.uuid.toString());
                    buf.writeInt(length);
                    buf.writeBytes(this.content, 0, length);
                    continue;
                }
                CreativeSplittedMessageHandler splitted = new CreativeSplittedMessageHandler(i == this.amount - 1, id, this.uuid, this.content, i * packetSize, length);
                splitted.type = this.type;
                PacketHandler.addQueueMessage(splitted);
            }
        }
    }

    public static enum MessageType {
        ToServer{

            @Override
            public Side getSide() {
                return Side.CLIENT;
            }
        }
        ,
        ToPlayer{

            @Override
            public Side getSide() {
                return Side.SERVER;
            }
        }
        ,
        ToAllPlayer{

            @Override
            public Side getSide() {
                return Side.SERVER;
            }
        };


        public abstract Side getSide();
    }
}

