/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.gui.GuiHandler;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.configurable.IConfigurableBlock;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeAction;
import org.cyclops.cyclopscore.config.configurabletypeaction.ItemAction;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;

public class BlockAction
extends ConfigurableTypeAction<BlockConfig> {
    private static final List<BlockConfig> MODEL_ENTRIES = Lists.newArrayList();

    public static void register(Block block, ExtendedConfig<BlockConfig> config, @Nullable CreativeTabs creativeTabs) {
        BlockAction.register(block, config, creativeTabs, null);
    }

    public static void register(Block block, ExtendedConfig<BlockConfig> config, @Nullable CreativeTabs creativeTabs, @Nullable Callable<?> callback) {
        BlockAction.register(block, null, config, creativeTabs, callback);
    }

    public static void register(Block block, @Nullable Class<? extends Item> itemBlockClass, ExtendedConfig<BlockConfig> config, @Nullable CreativeTabs creativeTabs) {
        BlockAction.register(block, itemBlockClass, config, creativeTabs, null);
    }

    public static void register(Block block, @Nullable Class<? extends Item> itemBlockClass, ExtendedConfig<BlockConfig> config, @Nullable CreativeTabs creativeTabs, @Nullable Callable<?> callback) {
        BlockAction.register(block, config, (Callable)null);
        if (itemBlockClass != null) {
            try {
                Item item = itemBlockClass.getConstructor(Block.class).newInstance(block);
                BlockAction.register(ForgeRegistries.ITEMS, item, config, callback);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (creativeTabs != null) {
            block.func_149647_a(creativeTabs);
        }
    }

    @Override
    public void preRun(BlockConfig eConfig, Configuration config, boolean startup) {
        Property property = config.get(eConfig.getHolderType().getCategory(), eConfig.getNamedId(), eConfig.isEnabled());
        property.setRequiresMcRestart(true);
        property.setComment(eConfig.getComment());
        property.setLanguageKey(eConfig.getFullUnlocalizedName());
        if (startup) {
            eConfig.setEnabled(property.getBoolean(true));
        }
    }

    @Override
    public void postRun(BlockConfig eConfig, Configuration config) {
        eConfig.save();
        Block block = (Block)eConfig.getSubInstance();
        BlockAction.register(block, eConfig.getItemBlockClass(), eConfig, eConfig.getTargetTab(), () -> {
            eConfig.onForgeRegistered();
            if (eConfig.getOreDictionaryId() != null) {
                OreDictionary.registerOre((String)eConfig.getOreDictionaryId(), (ItemStack)new ItemStack((Block)eConfig.getSubInstance()));
            }
            return null;
        });
        GuiHandler.GuiType<Void> guiType = GuiHandler.GuiType.BLOCK;
        if (eConfig.getHolderType().equals(ConfigurableType.BLOCKCONTAINER)) {
            ConfigurableBlockContainer container = (ConfigurableBlockContainer)block;
            try {
                GameRegistry.registerTileEntity(container.getTileEntity(), (String)(eConfig.getMod().getModId() + ":" + eConfig.getSubUniqueName()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            guiType = GuiHandler.GuiType.TILE;
        }
        if (block instanceof IConfigurableBlock && ((IConfigurableBlock)block).hasGui()) {
            IGuiContainerProvider gui = (IGuiContainerProvider)block;
            eConfig.getMod().getGuiHandler().registerGUI(gui, guiType);
        }
        if (MinecraftHelpers.isClientSide()) {
            ItemAction.handleItemModel(eConfig);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onModelRegistryLoad(ModelRegistryEvent event) {
        for (BlockConfig config : MODEL_ENTRIES) {
            Pair<ModelResourceLocation, ModelResourceLocation> resourceLocations = config.registerDynamicModel();
            config.dynamicBlockVariantLocation = (ModelResourceLocation)resourceLocations.getLeft();
            config.dynamicItemVariantLocation = (ModelResourceLocation)resourceLocations.getRight();
        }
    }

    public static void handleDynamicBlockModel(BlockConfig extendedConfig) {
        MODEL_ENTRIES.add(extendedConfig);
    }

    @Override
    public void polish(BlockConfig config) {
        IConfigurableBlock configurableBlock;
        IBlockColor blockColorHandler;
        super.polish(config);
        Block block = config.getBlockInstance();
        if (block instanceof IConfigurableBlock && MinecraftHelpers.isClientSide() && (blockColorHandler = (configurableBlock = (IConfigurableBlock)block).getBlockColorHandler()) != null) {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(blockColorHandler, new Block[]{block});
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(BlockAction.class);
    }
}

