/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.ogex;

import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTransform;

public abstract class OgexRotation
implements OgexTransform {
    private Kind kind;
    private boolean object;

    protected OgexRotation(Kind kind) {
        this.kind = kind;
    }

    @Override
    public void setObjectOnly(boolean b) {
        this.object = b;
    }

    @Override
    public boolean isObjectOnly() {
        return this.object;
    }

    protected void setKind(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public static OgexRotation create(Kind kind, Object data) {
        switch (kind) {
            case X: 
            case Y: 
            case Z: {
                return new ComponentRotation(kind, ((Float)data).floatValue());
            }
            case Axis: {
                return new AxisRotation(kind, (float[])data);
            }
            case Quaternion: {
                return new QuaternionRotation(kind, (float[])data);
            }
        }
        return null;
    }

    public static class QuaternionRotation
    extends OgexRotation {
        private float[] quat;

        public QuaternionRotation(Kind kind, float[] data) {
            super(kind);
            this.quat = data;
        }

        @Override
        public void setKind(Kind kind) {
            if (kind != Kind.Quaternion) {
                throw new IllegalArgumentException("Incompatible Quaternion kind:" + (Object)((Object)kind));
            }
        }

        public void setQuat(float[] quat) {
            if (quat.length != 4) {
                throw new IllegalArgumentException("Quaternion array must be length 4, found:" + quat.length);
            }
            this.quat = quat;
        }

        public float[] getQuat() {
            return this.quat;
        }

        @Override
        public float[] toMatrix() {
            float x = this.quat[0];
            float y = this.quat[1];
            float z = this.quat[2];
            float w = this.quat[3];
            float lengthSq = x * x + y * y + z * z + w * w;
            if (lengthSq != 1.0f) {
                float length = (float)Math.sqrt(lengthSq);
                float norm = 1.0f / length;
                x *= norm;
                y *= norm;
                z *= norm;
                w *= norm;
            }
            return new float[]{1.0f - 2.0f * y * y - 2.0f * z * z, 2.0f * x * y * (2.0f * w * z), 2.0f * x * z + 2.0f * w * y, 0.0f, 2.0f * x * y + 2.0f * w * z, 1.0f - 2.0f * x * x - 2.0f * z * z, 2.0f * y * z - 2.0f * w * x, 0.0f, 2.0f * x * z - 2.0f * w * y, 2.0f * y * z + 2.0f * w * x, 1.0f - 2.0f * x * x - 2.0f * y * y, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[kind=" + (Object)((Object)this.getKind()) + ", quat=[" + this.quat[0] + ", " + this.quat[1] + ", " + this.quat[2] + ", " + this.quat[3] + "]]";
        }
    }

    public static class AxisRotation
    extends OgexRotation {
        private float angle;
        private float[] axis;

        public AxisRotation(Kind kind, float[] data) {
            super(kind);
            this.angle = data[0];
            this.axis = new float[]{data[1], data[2], data[3]};
        }

        @Override
        public void setKind(Kind kind) {
            if (kind != Kind.Axis) {
                throw new IllegalArgumentException("Incompatible Axis kind:" + (Object)((Object)kind));
            }
        }

        public void setAngle(float angle) {
            this.angle = angle;
        }

        public float getAngle() {
            return this.angle;
        }

        public void setAxis(float[] axis) {
            if (axis.length != 3) {
                throw new IllegalArgumentException("Axis array must be length 3, found:" + axis.length);
            }
            this.axis = axis;
        }

        public float[] getAxis() {
            return this.axis;
        }

        @Override
        public float[] toMatrix() {
            float cos = (float)Math.cos(this.angle);
            float sin = (float)Math.sin(this.angle);
            float Ax = this.axis[0];
            float Ay = this.axis[1];
            float Az = this.axis[2];
            float lengthSq = Ax * Ax + Ay * Ay + Az * Az;
            if (lengthSq != 1.0f) {
                float length = (float)Math.sqrt(lengthSq);
                float norm = 1.0f / length;
                Ax *= norm;
                Ay *= norm;
                Az *= norm;
            }
            return new float[]{cos + Ax * Ax * (1.0f - cos), Ax * Ay * (1.0f - cos) - Az * sin, Ax * Az * (1.0f - cos) + Ay * sin, 0.0f, Ax * Ay * (1.0f - cos) + Az * sin, cos + Ay * Ay * (1.0f - cos), Ay * Az * (1.0f - cos) - Az * sin, 0.0f, Ax * Az * (1.0f - cos) - Ay * sin, Ay * Az * (1.0f - cos) + Ax * sin, cos + Az * Az * (1.0f - cos), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[kind=" + (Object)((Object)this.getKind()) + ", angle=" + this.angle + ", axis=[" + this.axis[0] + ", " + this.axis[1] + ", " + this.axis[2] + "]]";
        }
    }

    public static class ComponentRotation
    extends OgexRotation {
        private float angle;

        public ComponentRotation(Kind kind, float angle) {
            super(kind);
            this.angle = angle;
        }

        @Override
        public void setKind(Kind kind) {
            switch (kind) {
                case X: 
                case Y: 
                case Z: {
                    super.setKind(kind);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incompatible ComponentRotation kind:" + (Object)((Object)kind));
                }
            }
        }

        public void setAngle(float angle) {
            this.angle = angle;
        }

        public float getAngle() {
            return this.angle;
        }

        @Override
        public float[] toMatrix() {
            float cos = (float)Math.cos(this.angle);
            float sin = (float)Math.sin(this.angle);
            switch (this.getKind()) {
                case X: {
                    return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, cos, -sin, 0.0f, 0.0f, sin, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
                }
                case Y: {
                    return new float[]{cos, 0.0f, sin, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -sin, 0.0f, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
                }
                case Z: {
                    return new float[]{cos, -sin, 0.0f, 0.0f, sin, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
                }
            }
            throw new IllegalArgumentException("Incompatible ComponentRotation kind:" + (Object)((Object)this.getKind()));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[kind=" + (Object)((Object)this.getKind()) + ", angle=" + this.angle + "]";
        }
    }

    public static enum Kind {
        X("x"),
        Y("y"),
        Z("z"),
        Axis("axis"),
        Quaternion("Quaternion");

        private String ogexName;

        private Kind(String ogexName) {
            this.ogexName = ogexName;
        }

        public String getOgexName() {
            return this.ogexName;
        }

        public static Kind lookup(String ogexName) {
            for (Kind kind : Kind.values()) {
                if (!ogexName.equals(kind.ogexName)) continue;
                return kind;
            }
            return null;
        }
    }
}

