/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.ogex;

import java.lang.reflect.Array;
import java.util.Iterator;

public class IntArray
implements Iterable<Number> {
    private Class type;
    private Object array;
    private int size;

    public IntArray(Object array) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null");
        }
        this.array = array;
        this.type = array.getClass().getComponentType();
        this.size = Array.getLength(array);
    }

    public int length() {
        return this.size;
    }

    public Class getType() {
        return this.type;
    }

    public byte[] asByteArray() {
        if (this.type == Byte.TYPE) {
            return (byte[])this.array;
        }
        throw new RuntimeException("Type overflow, " + this.type + "[] cannot be converted to byte[]");
    }

    public short[] asShortArray() {
        if (this.type == Short.TYPE) {
            return (short[])this.array;
        }
        if (this.type == Byte.TYPE) {
            short[] result = new short[this.size];
            for (int i = 0; i < result.length; ++i) {
                result[i] = ((Number)Array.get(this.array, i)).shortValue();
            }
            return result;
        }
        throw new RuntimeException("Type overflow, " + this.type + "[] cannot be converted to short[]");
    }

    public int[] asIntArray() {
        if (this.type == Integer.TYPE) {
            return (int[])this.array;
        }
        if (this.type == Byte.TYPE || this.type == Short.TYPE) {
            int[] result = new int[this.size];
            for (int i = 0; i < result.length; ++i) {
                result[i] = ((Number)Array.get(this.array, i)).intValue();
            }
            return result;
        }
        throw new RuntimeException("Type overflow, " + this.type + "[] cannot be converted to int[]");
    }

    public long[] asLongArray() {
        if (this.type == Long.TYPE) {
            return (long[])this.array;
        }
        if (this.type == Byte.TYPE || this.type == Short.TYPE || this.type == Integer.TYPE) {
            long[] result = new long[this.size];
            for (int i = 0; i < result.length; ++i) {
                result[i] = ((Number)Array.get(this.array, i)).longValue();
            }
            return result;
        }
        throw new RuntimeException("Type overflow, " + this.type + "[] cannot be converted to long[]");
    }

    @Override
    public Iterator<Number> iterator() {
        return new IntIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.type + ":" + this.size + "]";
    }

    private class IntIterator
    implements Iterator<Number> {
        private int next = 0;

        protected IntIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.next < IntArray.this.size;
        }

        @Override
        public Number next() {
            Number result = (Number)Array.get(IntArray.this.array, this.next++);
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }
}

