/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.TileNetworkList;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IAdvancedBoundingBlock;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.chunkloading.IChunkLoader;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.miner.MItemStackFilter;
import mekanism.common.content.miner.MOreDictFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.ThreadMinerSearch;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MinerUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDigitalMiner
extends TileEntityElectricBlock
implements IUpgradeTile,
IRedstoneControl,
IActiveState,
ISustainedData,
IChunkLoader,
IAdvancedBoundingBlock {
    public static int[] EJECT_INV;
    private static final int[] INV_SLOTS;
    public Map<Chunk3D, BitSet> oresToMine = new HashMap<Chunk3D, BitSet>();
    public Map<Integer, MinerFilter> replaceMap = new HashMap<Integer, MinerFilter>();
    public HashList<MinerFilter> filters = new HashList();
    public ThreadMinerSearch searcher = new ThreadMinerSearch(this);
    public final double BASE_ENERGY_USAGE;
    public double energyUsage;
    public int radius;
    public boolean inverse;
    public int minY;
    public int maxY;
    public boolean doEject;
    public boolean doPull;
    public ItemStack missingStack;
    public int BASE_DELAY;
    public int delay;
    public int delayLength;
    public int clientToMine;
    public boolean isActive;
    public boolean clientActive;
    public boolean silkTouch;
    public boolean running;
    public double prevEnergy;
    public int delayTicks;
    public boolean initCalc;
    public int numPowering;
    public boolean clientRendering;
    public IRedstoneControl.RedstoneControl controlType;
    public TileComponentUpgrade upgradeComponent;
    public TileComponentSecurity securityComponent;
    public TileComponentChunkLoader chunkLoaderComponent;
    public String[] methods;

    public TileEntityDigitalMiner() {
        super("DigitalMiner", BlockStateMachine.MachineType.DIGITAL_MINER.baseEnergy);
        this.BASE_ENERGY_USAGE = MekanismConfig.current().usage.digitalMinerUsage.val();
        this.energyUsage = MekanismConfig.current().usage.digitalMinerUsage.val();
        this.minY = 0;
        this.maxY = 60;
        this.doEject = false;
        this.doPull = false;
        this.missingStack = ItemStack.field_190927_a;
        this.delayLength = this.BASE_DELAY = 80;
        this.initCalc = false;
        this.clientRendering = false;
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
        this.upgradeComponent = new TileComponentUpgrade(this, INV_SLOTS.length);
        this.securityComponent = new TileComponentSecurity(this);
        this.chunkLoaderComponent = new TileComponentChunkLoader(this);
        this.methods = new String[]{"setRadius", "setMin", "setMax", "addFilter", "removeFilter", "addOreFilter", "removeOreFilter", "reset", "start", "stop", "getToMine"};
        this.inventory = NonNullList.func_191197_a((int)(INV_SLOTS.length + 1), (Object)ItemStack.field_190927_a);
        this.radius = 10;
        this.upgradeComponent.setSupported(Upgrade.ANCHOR);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.getActive()) {
            for (EntityPlayer player : new HashSet(this.playersUsing)) {
                if (!(player.field_71070_bA instanceof ContainerNull) && !(player.field_71070_bA instanceof ContainerFilter)) continue;
                player.func_71053_j();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.initCalc) {
                if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
                    boolean prevRunning = this.running;
                    this.reset();
                    this.start();
                    this.running = prevRunning;
                }
                this.initCalc = true;
            }
            ChargeUtils.discharge(27, this);
            if (MekanismUtils.canFunction(this) && this.running && this.getEnergy() >= this.getPerTick() && this.searcher.state == ThreadMinerSearch.State.FINISHED && this.oresToMine.size() > 0) {
                this.setActive(true);
                if (this.delay > 0) {
                    --this.delay;
                }
                this.setEnergy(this.getEnergy() - this.getPerTick());
                if (this.delay == 0) {
                    boolean did = false;
                    Iterator<Chunk3D> it = this.oresToMine.keySet().iterator();
                    block1: while (it.hasNext()) {
                        Chunk3D chunk = it.next();
                        BitSet set = this.oresToMine.get(chunk);
                        int next = 0;
                        while (!did) {
                            int index = set.nextSetBit(next);
                            Coord4D coord = this.getCoordFromIndex(index);
                            if (index == -1) {
                                it.remove();
                                continue block1;
                            }
                            if (!coord.exists(this.field_145850_b)) {
                                set.clear(index);
                                if (set.cardinality() == 0) {
                                    it.remove();
                                    continue block1;
                                }
                                next = index + 1;
                                continue;
                            }
                            IBlockState state = coord.getBlockState((IBlockAccess)this.field_145850_b);
                            Block block = state.func_177230_c();
                            int meta = block.func_176201_c(state);
                            if (block == null || coord.isAirBlock((IBlockAccess)this.field_145850_b)) {
                                set.clear(index);
                                if (set.cardinality() == 0) {
                                    it.remove();
                                    continue block1;
                                }
                                next = index + 1;
                                continue;
                            }
                            boolean hasFilter = false;
                            ItemStack is = new ItemStack(block, 1, meta);
                            for (MinerFilter filter : this.filters) {
                                if (!filter.canFilter(is)) continue;
                                hasFilter = true;
                                break;
                            }
                            if (this.inverse == hasFilter || !this.canMine(coord)) {
                                set.clear(index);
                                if (set.cardinality() == 0) {
                                    it.remove();
                                    continue block1;
                                }
                                next = index + 1;
                                continue;
                            }
                            List<ItemStack> drops = MinerUtils.getDrops(this.field_145850_b, coord, this.silkTouch);
                            if (!this.canInsert(drops) || !this.setReplace(coord, index)) continue block1;
                            did = true;
                            this.add(drops);
                            set.clear(index);
                            if (set.cardinality() == 0) {
                                it.remove();
                            }
                            this.field_145850_b.func_180498_a(null, 2001, coord.getPos(), Block.func_176210_f((IBlockState)state));
                            this.missingStack = ItemStack.field_190927_a;
                            continue block1;
                        }
                    }
                    this.delay = this.getDelay();
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            TransitRequest ejectMap = this.getEjectItemMap();
            if (this.doEject && this.delayTicks == 0 && !ejectMap.isEmpty() && this.getEjectInv() != null && this.getEjectTile() != null) {
                TransitRequest.TransitResponse response;
                if (CapabilityUtils.hasCapability((ICapabilityProvider)this.getEjectInv(), Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, this.facing.func_176734_d())) {
                    response = TransporterUtils.insert(this.getEjectTile(), CapabilityUtils.getCapability((ICapabilityProvider)this.getEjectInv(), Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, this.facing.func_176734_d()), ejectMap, null, true, 0);
                    if (!response.isEmpty()) {
                        response.getInvStack(this, this.facing.func_176734_d()).use();
                    }
                } else {
                    response = InventoryUtils.putStackInInventory(this.getEjectInv(), ejectMap, this.facing.func_176734_d(), false);
                    if (!response.isEmpty()) {
                        response.getInvStack(this, this.facing.func_176734_d()).use();
                    }
                }
                this.delayTicks = 10;
            } else if (this.delayTicks > 0) {
                --this.delayTicks;
            }
            if (this.playersUsing.size() > 0) {
                for (EntityPlayer player : this.playersUsing) {
                    Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getSmallPacket(new TileNetworkList())), (EntityPlayerMP)player);
                }
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public double getPerTick() {
        double ret = this.energyUsage;
        if (this.silkTouch) {
            ret *= 6.0;
        }
        int baseRad = Math.max(this.radius - 10, 0);
        ret *= (double)(1.0f + (float)baseRad / 22.0f);
        int baseHeight = Math.max(this.maxY - this.minY - 60, 0);
        return ret *= (double)(1.0f + (float)baseHeight / 195.0f);
    }

    public int getDelay() {
        return this.delayLength;
    }

    public boolean setReplace(Coord4D obj, int index) {
        ItemStack stack = this.getReplace(index);
        if (!stack.func_190926_b()) {
            this.field_145850_b.func_180501_a(obj.getPos(), Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77952_i()), 3);
            IBlockState s = obj.getBlockState((IBlockAccess)this.field_145850_b);
            if (s.func_177230_c() instanceof BlockBush && !((BlockBush)s.func_177230_c()).func_180671_f(this.field_145850_b, obj.getPos(), s)) {
                s.func_177230_c().func_176226_b(this.field_145850_b, obj.getPos(), s, 1);
                this.field_145850_b.func_175698_g(obj.getPos());
            }
            return true;
        }
        MinerFilter filter = this.replaceMap.get(index);
        if (filter == null || filter.replaceStack.func_190926_b() || !filter.requireStack) {
            this.field_145850_b.func_175698_g(obj.getPos());
            return true;
        }
        this.missingStack = filter.replaceStack;
        return false;
    }

    private boolean canMine(Coord4D coord) {
        IBlockState state = coord.getBlockState((IBlockAccess)this.field_145850_b);
        EntityPlayer dummy = (EntityPlayer)Mekanism.proxy.getDummyPlayer((WorldServer)this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()).get();
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.field_145850_b, coord.getPos(), state, dummy);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public ItemStack getReplace(int index) {
        InvStack stack;
        MinerFilter filter = this.replaceMap.get(index);
        if (filter == null || filter.replaceStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < 27; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b() || !((ItemStack)this.inventory.get(i)).func_77969_a(filter.replaceStack)) continue;
            ((ItemStack)this.inventory.get(i)).func_190918_g(1);
            return MekanismUtils.size(filter.replaceStack, 1);
        }
        if (this.doPull && this.getPullInv() != null && (stack = InventoryUtils.takeDefinedItem(this.getPullInv(), EnumFacing.UP, filter.replaceStack.func_77946_l(), 1, 1)) != null) {
            stack.use();
            return MekanismUtils.size(filter.replaceStack, 1);
        }
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> copy(NonNullList<ItemStack> stacks) {
        NonNullList toReturn = NonNullList.func_191197_a((int)stacks.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < stacks.size(); ++i) {
            toReturn.set(i, (Object)(!((ItemStack)stacks.get(i)).func_190926_b() ? ((ItemStack)stacks.get(i)).func_77946_l() : ItemStack.field_190927_a));
        }
        return toReturn;
    }

    public TransitRequest getEjectItemMap() {
        TransitRequest request = new TransitRequest();
        for (int i = 26; i >= 0; --i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack.func_190926_b() || this.isReplaceStack(stack) || request.hasType(stack)) continue;
            request.setItem(stack, i);
        }
        return request;
    }

    public boolean canInsert(List<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return true;
        }
        NonNullList<ItemStack> testInv = this.copy((NonNullList<ItemStack>)this.inventory);
        int added = 0;
        block0: for (ItemStack stack : stacks) {
            if ((stack = stack.func_77946_l()).func_190926_b() || stack.func_77973_b() == null) continue;
            for (int i = 0; i < 27; ++i) {
                if (!((ItemStack)testInv.get(i)).func_190926_b() && ((ItemStack)testInv.get(i)).func_77973_b() == null) {
                    testInv.set(i, (Object)ItemStack.field_190927_a);
                }
                if (((ItemStack)testInv.get(i)).func_190926_b()) {
                    testInv.set(i, (Object)stack);
                    ++added;
                    continue block0;
                }
                if (!((ItemStack)testInv.get(i)).func_77969_a(stack) || ((ItemStack)testInv.get(i)).func_190916_E() + stack.func_190916_E() > stack.func_77976_d()) continue;
                ((ItemStack)testInv.get(i)).func_190917_f(stack.func_190916_E());
                ++added;
                continue block0;
            }
        }
        return added == stacks.size();
    }

    public TileEntity getPullInv() {
        return Coord4D.get(this).translate(0, 2, 0).getTileEntity((IBlockAccess)this.field_145850_b);
    }

    public TileEntity getEjectInv() {
        EnumFacing side = this.facing.func_176734_d();
        return this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a().func_177967_a(side, 2));
    }

    public void add(List<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return;
        }
        block0: for (ItemStack stack : stacks) {
            for (int i = 0; i < 27; ++i) {
                if (((ItemStack)this.inventory.get(i)).func_190926_b()) {
                    this.inventory.set(i, (Object)stack);
                    continue block0;
                }
                if (!((ItemStack)this.inventory.get(i)).func_77969_a(stack) || ((ItemStack)this.inventory.get(i)).func_190916_E() + stack.func_190916_E() > stack.func_77976_d()) continue;
                ((ItemStack)this.inventory.get(i)).func_190917_f(stack.func_190916_E());
                continue block0;
            }
        }
    }

    public void start() {
        if (this.searcher.state == ThreadMinerSearch.State.IDLE) {
            this.searcher.start();
        }
        this.running = true;
        MekanismUtils.saveChunk(this);
    }

    public void stop() {
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            this.searcher.interrupt();
            this.reset();
            return;
        }
        if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
            this.running = false;
        }
        MekanismUtils.saveChunk(this);
    }

    public void reset() {
        this.searcher = new ThreadMinerSearch(this);
        this.running = false;
        this.oresToMine.clear();
        this.replaceMap.clear();
        this.missingStack = ItemStack.field_190927_a;
        this.setActive(false);
        MekanismUtils.saveChunk(this);
    }

    public boolean isReplaceStack(ItemStack stack) {
        for (MinerFilter filter : this.filters) {
            if (filter.replaceStack.func_190926_b() || !filter.replaceStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public int getSize() {
        int size = 0;
        for (Chunk3D chunk : this.oresToMine.keySet()) {
            size += this.oresToMine.get(chunk).cardinality();
        }
        return size;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        super.func_174889_b(player);
        if (!this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new TileNetworkList())), (EntityPlayerMP)player);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.radius = Math.min(nbtTags.func_74762_e("radius"), MekanismConfig.current().general.digitalMinerMaxRadius.val());
        this.minY = nbtTags.func_74762_e("minY");
        this.maxY = nbtTags.func_74762_e("maxY");
        this.doEject = nbtTags.func_74767_n("doEject");
        this.doPull = nbtTags.func_74767_n("doPull");
        this.isActive = nbtTags.func_74767_n("isActive");
        this.running = nbtTags.func_74767_n("running");
        this.delay = nbtTags.func_74762_e("delay");
        this.silkTouch = nbtTags.func_74767_n("silkTouch");
        this.numPowering = nbtTags.func_74762_e("numPowering");
        this.searcher.state = ThreadMinerSearch.State.values()[nbtTags.func_74762_e("state")];
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.inverse = nbtTags.func_74767_n("inverse");
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(MinerFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            this.reset();
        }
        nbtTags.func_74768_a("radius", this.radius);
        nbtTags.func_74768_a("minY", this.minY);
        nbtTags.func_74768_a("maxY", this.maxY);
        nbtTags.func_74757_a("doEject", this.doEject);
        nbtTags.func_74757_a("doPull", this.doPull);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74757_a("running", this.running);
        nbtTags.func_74768_a("delay", this.delay);
        nbtTags.func_74757_a("silkTouch", this.silkTouch);
        nbtTags.func_74768_a("numPowering", this.numPowering);
        nbtTags.func_74768_a("state", this.searcher.state.ordinal());
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74757_a("inverse", this.inverse);
        NBTTagList filterTags = new NBTTagList();
        for (MinerFilter filter : this.filters) {
            filterTags.func_74742_a((NBTBase)filter.write(new NBTTagCompound()));
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            switch (type) {
                case 0: {
                    this.doEject = !this.doEject;
                    break;
                }
                case 1: {
                    this.doPull = !this.doPull;
                    break;
                }
                case 3: {
                    this.start();
                    break;
                }
                case 4: {
                    this.stop();
                    break;
                }
                case 5: {
                    this.reset();
                    break;
                }
                case 6: {
                    this.radius = Math.min(dataStream.readInt(), MekanismConfig.current().general.digitalMinerMaxRadius.val());
                    break;
                }
                case 7: {
                    this.minY = dataStream.readInt();
                    break;
                }
                case 8: {
                    this.maxY = dataStream.readInt();
                    break;
                }
                case 9: {
                    this.silkTouch = !this.silkTouch;
                    break;
                }
                case 10: {
                    this.inverse = !this.inverse;
                    break;
                }
                case 11: {
                    int filterIndex = dataStream.readInt();
                    this.filters.swap(filterIndex, filterIndex - 1);
                    for (EntityPlayer player : this.playersUsing) {
                        this.func_174889_b(player);
                    }
                    break;
                }
                case 12: {
                    int filterIndex = dataStream.readInt();
                    this.filters.swap(filterIndex, filterIndex + 1);
                    for (EntityPlayer player : this.playersUsing) {
                        this.func_174889_b(player);
                    }
                    break;
                }
            }
            MekanismUtils.saveChunk(this);
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getGenericPacket(new TileNetworkList())), (EntityPlayerMP)player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.radius = dataStream.readInt();
                this.minY = dataStream.readInt();
                this.maxY = dataStream.readInt();
                this.doEject = dataStream.readBoolean();
                this.doPull = dataStream.readBoolean();
                this.clientActive = dataStream.readBoolean();
                this.running = dataStream.readBoolean();
                this.silkTouch = dataStream.readBoolean();
                this.numPowering = dataStream.readInt();
                this.searcher.state = ThreadMinerSearch.State.values()[dataStream.readInt()];
                this.clientToMine = dataStream.readInt();
                this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
                this.inverse = dataStream.readBoolean();
                this.missingStack = dataStream.readBoolean() ? new ItemStack(Item.func_150899_d((int)dataStream.readInt()), 1, dataStream.readInt()) : ItemStack.field_190927_a;
                this.filters.clear();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    this.filters.add(MinerFilter.readFromPacket(dataStream));
                }
            } else if (type == 1) {
                this.radius = dataStream.readInt();
                this.minY = dataStream.readInt();
                this.maxY = dataStream.readInt();
                this.doEject = dataStream.readBoolean();
                this.doPull = dataStream.readBoolean();
                this.clientActive = dataStream.readBoolean();
                this.running = dataStream.readBoolean();
                this.silkTouch = dataStream.readBoolean();
                this.numPowering = dataStream.readInt();
                this.searcher.state = ThreadMinerSearch.State.values()[dataStream.readInt()];
                this.clientToMine = dataStream.readInt();
                this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
                this.inverse = dataStream.readBoolean();
                this.missingStack = dataStream.readBoolean() ? new ItemStack(Item.func_150899_d((int)dataStream.readInt()), 1, dataStream.readInt()) : ItemStack.field_190927_a;
            } else if (type == 2) {
                this.filters.clear();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    this.filters.add(MinerFilter.readFromPacket(dataStream));
                }
            } else if (type == 3) {
                this.clientActive = dataStream.readBoolean();
                this.running = dataStream.readBoolean();
                this.clientToMine = dataStream.readInt();
                this.missingStack = dataStream.readBoolean() ? new ItemStack(Item.func_150899_d((int)dataStream.readInt()), 1, dataStream.readInt()) : ItemStack.field_190927_a;
            }
            if (this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(0);
        data.add(this.radius);
        data.add(this.minY);
        data.add(this.maxY);
        data.add(this.doEject);
        data.add(this.doPull);
        data.add(this.isActive);
        data.add(this.running);
        data.add(this.silkTouch);
        data.add(this.numPowering);
        data.add(this.searcher.state.ordinal());
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            data.add(this.searcher.found);
        } else {
            data.add(this.getSize());
        }
        data.add(this.controlType.ordinal());
        data.add(this.inverse);
        if (!this.missingStack.func_190926_b()) {
            data.add(true);
            data.add(MekanismUtils.getID(this.missingStack));
            data.add(this.missingStack.func_77952_i());
        } else {
            data.add(false);
        }
        data.add(this.filters.size());
        for (MinerFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public TileNetworkList getSmallPacket(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(3);
        data.add(this.isActive);
        data.add(this.running);
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            data.add(this.searcher.found);
        } else {
            data.add(this.getSize());
        }
        if (!this.missingStack.func_190926_b()) {
            data.add(true);
            data.add(MekanismUtils.getID(this.missingStack));
            data.add(this.missingStack.func_77952_i());
        } else {
            data.add(false);
        }
        return data;
    }

    public TileNetworkList getGenericPacket(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(1);
        data.add(this.radius);
        data.add(this.minY);
        data.add(this.maxY);
        data.add(this.doEject);
        data.add(this.doPull);
        data.add(this.isActive);
        data.add(this.running);
        data.add(this.silkTouch);
        data.add(this.numPowering);
        data.add(this.searcher.state.ordinal());
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            data.add(this.searcher.found);
        } else {
            data.add(this.getSize());
        }
        data.add(this.controlType.ordinal());
        data.add(this.inverse);
        if (!this.missingStack.func_190926_b()) {
            data.add(true);
            data.add(MekanismUtils.getID(this.missingStack));
            data.add(this.missingStack.func_77952_i());
        } else {
            data.add(false);
        }
        return data;
    }

    public TileNetworkList getFilterPacket(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(2);
        data.add(this.filters.size());
        for (MinerFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public int getTotalSize() {
        return this.getDiameter() * this.getDiameter() * (this.maxY - this.minY + 1);
    }

    public int getDiameter() {
        return this.radius * 2 + 1;
    }

    public Coord4D getStartingCoord() {
        return new Coord4D(this.func_174877_v().func_177958_n() - this.radius, this.minY, this.func_174877_v().func_177952_p() - this.radius, this.field_145850_b.field_73011_w.getDimension());
    }

    public Coord4D getCoordFromIndex(int index) {
        int diameter = this.getDiameter();
        Coord4D start = this.getStartingCoord();
        int x = start.x + index % diameter;
        int y = start.y + index / diameter / diameter;
        int z = start.z + index / diameter % diameter;
        return new Coord4D(x, y, z, this.field_145850_b.field_73011_w.getDimension());
    }

    @Override
    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get(this)));
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void onPlace() {
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos pos1 = this.func_174877_v().func_177982_a(x, y, z);
                    MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, pos1, Coord4D.get(this));
                    this.field_145850_b.func_175685_c(pos1, this.func_145838_q(), true);
                }
            }
        }
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public void onBreak() {
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x, y, z));
                }
            }
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == this.facing.func_176734_d() ? INV_SLOTS : InventoryUtils.EMPTY;
    }

    public TileEntity getEjectTile() {
        EnumFacing side = this.facing.func_176734_d();
        return this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a().func_177972_a(side));
    }

    @Override
    public int[] getBoundSlots(BlockPos location, EnumFacing side) {
        EnumFacing dir = this.facing.func_176734_d();
        BlockPos pull = this.func_174877_v().func_177984_a();
        BlockPos eject = pull.func_177972_a(dir);
        if (location.equals((Object)eject) && side == dir || location.equals((Object)pull) && side == EnumFacing.UP) {
            if (EJECT_INV == null) {
                EJECT_INV = new int[27];
                for (int i = 0; i < EJECT_INV.length; ++i) {
                    TileEntityDigitalMiner.EJECT_INV[i] = i;
                }
            }
            return EJECT_INV;
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean canBoundInsert(BlockPos location, int i, ItemStack itemstack) {
        EnumFacing side = this.facing.func_176734_d();
        BlockPos pull = this.func_174877_v().func_177984_a();
        BlockPos eject = pull.func_177972_a(side);
        if (location.equals((Object)eject)) {
            return false;
        }
        return location.equals((Object)pull) && !itemstack.func_190926_b() && this.isReplaceStack(itemstack);
    }

    @Override
    public boolean canBoundExtract(BlockPos location, int i, ItemStack itemstack, EnumFacing dir) {
        EnumFacing side = this.facing.func_176734_d();
        BlockPos pull = this.func_174877_v().func_177984_a();
        BlockPos eject = pull.func_177972_a(side);
        if (location.equals((Object)eject)) {
            return itemstack.func_190926_b() || !this.isReplaceStack(itemstack);
        }
        if (location.equals((Object)pull)) {
            return false;
        }
        return false;
    }

    @Override
    public void onPower() {
        ++this.numPowering;
    }

    @Override
    public void onNoPower() {
        --this.numPowering;
    }

    @Override
    public String[] getMethods() {
        return this.methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        if (method == 0) {
            if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                return new Object[]{"Invalid parameters."};
            }
            this.radius = Math.min(((Double)arguments[0]).intValue(), MekanismConfig.current().general.digitalMinerMaxRadius.val());
        } else if (method == 1) {
            if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                return new Object[]{"Invalid parameters."};
            }
            this.minY = ((Double)arguments[0]).intValue();
        } else if (method == 2) {
            if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                return new Object[]{"Invalid parameters."};
            }
            this.maxY = ((Double)arguments[0]).intValue();
        } else {
            if (method == 3) {
                if (arguments.length < 1 || !(arguments[0] instanceof Double)) {
                    return new Object[]{"Invalid parameters."};
                }
                int id = ((Double)arguments[0]).intValue();
                int meta = 0;
                if (arguments.length > 1 && arguments[1] instanceof Double) {
                    meta = ((Double)arguments[1]).intValue();
                }
                this.filters.add(new MItemStackFilter(new ItemStack(Item.func_150899_d((int)id), 1, meta)));
                return new Object[]{"Added filter."};
            }
            if (method == 4) {
                if (arguments.length < 1 || !(arguments[0] instanceof Double)) {
                    return new Object[]{"Invalid parameters."};
                }
                int id = ((Double)arguments[0]).intValue();
                Iterator<MinerFilter> iter = this.filters.iterator();
                while (iter.hasNext()) {
                    MinerFilter filter = iter.next();
                    if (!(filter instanceof MItemStackFilter) || MekanismUtils.getID(((MItemStackFilter)filter).itemType) != id) continue;
                    iter.remove();
                    return new Object[]{"Removed filter."};
                }
                return new Object[]{"Couldn't find filter."};
            }
            if (method == 5) {
                if (arguments.length < 1 || !(arguments[0] instanceof String)) {
                    return new Object[]{"Invalid parameters."};
                }
                String ore = (String)arguments[0];
                MOreDictFilter filter = new MOreDictFilter();
                filter.oreDictName = ore;
                this.filters.add(filter);
                return new Object[]{"Added filter."};
            }
            if (method == 6) {
                if (arguments.length < 1 || !(arguments[0] instanceof String)) {
                    return new Object[]{"Invalid parameters."};
                }
                String ore = (String)arguments[0];
                Iterator<MinerFilter> iter = this.filters.iterator();
                while (iter.hasNext()) {
                    MinerFilter filter = iter.next();
                    if (!(filter instanceof MOreDictFilter) || !((MOreDictFilter)filter).oreDictName.equals(ore)) continue;
                    iter.remove();
                    return new Object[]{"Removed filter."};
                }
                return new Object[]{"Couldn't find filter."};
            }
            if (method == 7) {
                this.reset();
                return new Object[]{"Reset miner."};
            }
            if (method == 8) {
                this.start();
                return new Object[]{"Started miner."};
            }
            if (method == 9) {
                this.stop();
                return new Object[]{"Stopped miner."};
            }
            if (method == 10) {
                return new Object[]{this.searcher != null ? this.searcher.found : 0};
            }
        }
        for (EntityPlayer player : this.playersUsing) {
            Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getGenericPacket(new TileNetworkList())), (EntityPlayerMP)player);
        }
        return null;
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("radius", this.radius);
        nbtTags.func_74768_a("minY", this.minY);
        nbtTags.func_74768_a("maxY", this.maxY);
        nbtTags.func_74757_a("doEject", this.doEject);
        nbtTags.func_74757_a("doPull", this.doPull);
        nbtTags.func_74757_a("silkTouch", this.silkTouch);
        nbtTags.func_74757_a("inverse", this.inverse);
        NBTTagList filterTags = new NBTTagList();
        for (MinerFilter filter : this.filters) {
            filterTags.func_74742_a((NBTBase)filter.write(new NBTTagCompound()));
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
        this.radius = Math.min(nbtTags.func_74762_e("radius"), MekanismConfig.current().general.digitalMinerMaxRadius.val());
        this.minY = nbtTags.func_74762_e("minY");
        this.maxY = nbtTags.func_74762_e("maxY");
        this.doEject = nbtTags.func_74767_n("doEject");
        this.doPull = nbtTags.func_74767_n("doPull");
        this.silkTouch = nbtTags.func_74767_n("silkTouch");
        this.inverse = nbtTags.func_74767_n("inverse");
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(MinerFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public String getDataType() {
        return this.func_145838_q().func_149739_a() + "." + this.fullName + ".name";
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        ItemDataUtils.setBoolean(itemStack, "hasMinerConfig", true);
        ItemDataUtils.setInt(itemStack, "radius", this.radius);
        ItemDataUtils.setInt(itemStack, "minY", this.minY);
        ItemDataUtils.setInt(itemStack, "maxY", this.maxY);
        ItemDataUtils.setBoolean(itemStack, "doEject", this.doEject);
        ItemDataUtils.setBoolean(itemStack, "doPull", this.doPull);
        ItemDataUtils.setBoolean(itemStack, "silkTouch", this.silkTouch);
        ItemDataUtils.setBoolean(itemStack, "inverse", this.inverse);
        NBTTagList filterTags = new NBTTagList();
        for (MinerFilter filter : this.filters) {
            filterTags.func_74742_a((NBTBase)filter.write(new NBTTagCompound()));
        }
        if (filterTags.func_74745_c() != 0) {
            ItemDataUtils.setList(itemStack, "filters", filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "hasMinerConfig")) {
            this.radius = Math.min(ItemDataUtils.getInt(itemStack, "radius"), MekanismConfig.current().general.digitalMinerMaxRadius.val());
            this.minY = ItemDataUtils.getInt(itemStack, "minY");
            this.maxY = ItemDataUtils.getInt(itemStack, "maxY");
            this.doEject = ItemDataUtils.getBoolean(itemStack, "doEject");
            this.doPull = ItemDataUtils.getBoolean(itemStack, "doPull");
            this.silkTouch = ItemDataUtils.getBoolean(itemStack, "silkTouch");
            this.inverse = ItemDataUtils.getBoolean(itemStack, "inverse");
            if (ItemDataUtils.hasData(itemStack, "filters")) {
                NBTTagList tagList = ItemDataUtils.getList(itemStack, "filters");
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    this.filters.add(MinerFilter.readFromNBT(tagList.func_150305_b(i)));
                }
            }
        }
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.delayLength = MekanismUtils.getTicks(this, this.BASE_DELAY);
            }
            case ENERGY: {
                this.energyUsage = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_USAGE);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                this.setEnergy(Math.min(this.getMaxEnergy(), this.getEnergy()));
            }
        }
    }

    @Override
    public boolean canBoundReceiveEnergy(BlockPos coord, EnumFacing side) {
        EnumFacing left = MekanismUtils.getLeft(this.facing);
        EnumFacing right = MekanismUtils.getRight(this.facing);
        if (coord.equals((Object)this.func_174877_v().func_177972_a(left))) {
            return side == left;
        }
        if (coord.equals((Object)this.func_174877_v().func_177972_a(right))) {
            return side == right;
        }
        return false;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing) || side == EnumFacing.DOWN;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public TileComponentChunkLoader getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        return new Range4D(Coord4D.get(this)).expandFromCenter(this.radius).getIntersectingChunks().stream().map(Chunk3D::getPos).collect(Collectors.toSet());
    }

    static {
        INV_SLOTS = IntStream.range(0, 28).toArray();
    }
}

