/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class DoubleMachineInput
extends MachineInput<DoubleMachineInput> {
    public ItemStack itemStack = ItemStack.field_190927_a;
    public ItemStack extraStack = ItemStack.field_190927_a;

    public DoubleMachineInput(ItemStack item, ItemStack extra) {
        this.itemStack = item;
        this.extraStack = extra;
    }

    public DoubleMachineInput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.itemStack = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("input"));
        this.extraStack = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("extra"));
    }

    @Override
    public DoubleMachineInput copy() {
        return new DoubleMachineInput(this.itemStack.func_77946_l(), this.extraStack.func_77946_l());
    }

    @Override
    public boolean isValid() {
        return !this.itemStack.func_190926_b() && !this.extraStack.func_190926_b();
    }

    protected boolean useItemInternal(ItemStack stack, NonNullList<ItemStack> inventory, int index, boolean deplete) {
        if (DoubleMachineInput.inputContains((ItemStack)inventory.get(index), stack)) {
            if (deplete) {
                inventory.set(index, (Object)StackUtils.subtract((ItemStack)inventory.get(index), stack));
            }
            return true;
        }
        return false;
    }

    public boolean useItem(NonNullList<ItemStack> inventory, int index, boolean deplete) {
        return this.useItemInternal(this.itemStack, inventory, index, deplete);
    }

    public boolean useExtra(NonNullList<ItemStack> inventory, int index, boolean deplete) {
        return this.useItemInternal(this.extraStack, inventory, index, deplete);
    }

    public boolean matches(DoubleMachineInput input) {
        return StackUtils.equalsWildcard(this.itemStack, input.itemStack) && input.itemStack.func_190916_E() >= this.itemStack.func_190916_E() && StackUtils.equalsWildcard(this.extraStack, input.extraStack) && input.extraStack.func_190916_E() >= this.extraStack.func_190916_E();
    }

    @Override
    public int hashIngredients() {
        return StackUtils.hashItemStack(this.itemStack) ^ Integer.reverse(StackUtils.hashItemStack(this.extraStack));
    }

    @Override
    public boolean testEquality(DoubleMachineInput other) {
        if (!this.isValid()) {
            return !other.isValid();
        }
        return MachineInput.inputItemMatches(this.itemStack, other.itemStack) && MachineInput.inputItemMatches(this.extraStack, other.extraStack);
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof DoubleMachineInput;
    }

    public DoubleMachineInput wildCopy() {
        return new DoubleMachineInput(new ItemStack(this.itemStack.func_77973_b(), this.itemStack.func_190916_E(), Short.MAX_VALUE), new ItemStack(this.extraStack.func_77973_b(), this.extraStack.func_190916_E(), Short.MAX_VALUE));
    }
}

