/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemFlamethrower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketFlamethrowerData
implements IMessageHandler<FlamethrowerDataMessage, IMessage> {
    public IMessage onMessage(FlamethrowerDataMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(() -> {
            ItemStack stack;
            if (message.packetType == FlamethrowerPacket.UPDATE) {
                if (message.value) {
                    Mekanism.flamethrowerActive.add(message.userId);
                } else {
                    Mekanism.flamethrowerActive.remove(message.userId);
                }
                if (!player.field_70170_p.field_72995_K) {
                    Mekanism.packetHandler.sendToDimension(new FlamethrowerDataMessage(FlamethrowerPacket.UPDATE, message.currentHand, message.userId, message.value), player.field_70170_p.field_73011_w.getDimension());
                }
            } else if (message.packetType == FlamethrowerPacket.MODE && !(stack = player.func_184586_b(message.currentHand)).func_190926_b() && stack.func_77973_b() instanceof ItemFlamethrower) {
                ((ItemFlamethrower)stack.func_77973_b()).incrementMode(stack);
            }
        }, player);
        return null;
    }

    public static enum FlamethrowerPacket {
        UPDATE,
        MODE;

    }

    public static class FlamethrowerDataMessage
    implements IMessage {
        public FlamethrowerPacket packetType;
        public EnumHand currentHand;
        public UUID userId;
        public boolean value;

        public FlamethrowerDataMessage() {
        }

        public FlamethrowerDataMessage(FlamethrowerPacket type, EnumHand hand, UUID name, boolean state) {
            this.packetType = type;
            if (type == FlamethrowerPacket.UPDATE) {
                this.userId = name;
                this.value = state;
            } else if (type == FlamethrowerPacket.MODE) {
                this.currentHand = hand;
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == FlamethrowerPacket.UPDATE) {
                PacketHandler.writeUUID(dataStream, this.userId);
                dataStream.writeBoolean(this.value);
            } else {
                dataStream.writeInt(this.currentHand.ordinal());
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = FlamethrowerPacket.values()[dataStream.readInt()];
            if (this.packetType == FlamethrowerPacket.UPDATE) {
                this.userId = PacketHandler.readUUID(dataStream);
                this.value = dataStream.readBoolean();
            } else if (this.packetType == FlamethrowerPacket.MODE) {
                this.currentHand = EnumHand.values()[dataStream.readInt()];
            }
        }
    }
}

