/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.common.config.BaseConfig;
import mekanism.common.config.Option;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

@ParametersAreNonnullByDefault
public class FloatOption
extends Option<FloatOption> {
    private float value;
    private final float defaultValue;
    private boolean hasRange = false;
    private float min;
    private float max;

    FloatOption(BaseConfig owner, String category, String key, float defaultValue, @Nullable String comment) {
        super(owner, category, key, comment);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    FloatOption(BaseConfig owner, String category, String key, float defaultValue) {
        this(owner, category, key, defaultValue, null);
    }

    FloatOption(BaseConfig owner, String category, String key) {
        this(owner, category, key, 0.0f, null);
    }

    FloatOption(BaseConfig owner, String category, String key, float defaultValue, @Nullable String comment, float min, float max) {
        this(owner, category, key, defaultValue, comment);
        this.hasRange = true;
        this.min = min;
        this.max = max;
    }

    public float val() {
        return this.value;
    }

    public void set(float value) {
        this.value = value;
    }

    @Override
    protected void load(Configuration config) {
        Property prop = this.hasRange ? config.get(this.category, this.key, (double)this.defaultValue, this.comment, (double)this.min, (double)this.max) : config.get(this.category, this.key, (double)this.defaultValue, this.comment);
        prop.setRequiresMcRestart(this.requiresGameRestart);
        prop.setRequiresWorldRestart(this.requiresWorldRestart);
        this.value = (float)prop.getDouble();
    }

    @Override
    protected void write(ByteBuf buf) {
        buf.writeFloat(this.value);
    }

    @Override
    protected void read(ByteBuf buf) {
        this.value = buf.readFloat();
    }
}

