/*
 * Decompiled with CFR 0.152.
 */
package com.dmonsters.main;

import com.dmonsters.entity.EntityHauntedCow;
import com.dmonsters.entity.EntityTopielec;
import com.dmonsters.items.Harpoon;
import com.dmonsters.main.ModConfig;
import com.dmonsters.network.PacketClientFXUpdate;
import com.dmonsters.network.PacketHandler;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemSword;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEntitySpawn(LivingSpawnEvent.SpecialSpawn e) {
        Random rnd;
        int rndInt;
        if (ModConfig.topielecDisabled) {
            return;
        }
        Entity squid = e.getEntity();
        if (squid instanceof EntitySquid && (rndInt = (rnd = new Random()).nextInt(100)) < ModConfig.topielecSawnChance) {
            this.spawnEntity(squid, (Entity)new EntityTopielec(squid.func_130014_f_()));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerAttack(AttackEntityEvent e) {
        Entity entity = e.getTarget();
        if (!e.getEntity().func_130014_f_().field_72995_K) {
            if (!ModConfig.hauntedCowDisabled && (entity instanceof EntityCow || entity instanceof EntityHauntedCow)) {
                Random random = new Random();
                float rndChance = random.nextFloat();
                if (rndChance < 0.5f) {
                    return;
                }
                World world = entity.func_130014_f_();
                EntityPlayer player = e.getEntityPlayer();
                Item itemClass = player.func_184614_ca().func_77973_b();
                if (itemClass instanceof ItemSword || itemClass instanceof ItemBow) {
                    return;
                }
                entity.func_184174_b(false);
                entity.func_70106_y();
                this.spawnEntity(entity, (Entity)new EntityHauntedCow(world));
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketClientFXUpdate(entity.func_180425_c(), PacketClientFXUpdate.Type.SOULEYE));
                if (ModConfig.hauntedCowDisableTimeChange) {
                    return;
                }
                Style red = new Style().func_150238_a(TextFormatting.DARK_RED);
                TextComponentTranslation msg = new TextComponentTranslation("msg.dmonsters.hauntedcow", new Object[0]);
                msg.func_150255_a(red);
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketClientFXUpdate(player.func_180425_c(), PacketClientFXUpdate.Type.TIME_CHANGE));
                world.func_72877_b(18000L);
                player.func_145747_a((ITextComponent)msg);
            }
            if (!ModConfig.topielecDisabled && entity instanceof EntityTopielec) {
                EntityPlayer player = e.getEntityPlayer();
                Item itemClass = player.func_184614_ca().func_77973_b();
                if (itemClass instanceof Harpoon) {
                    e.setCanceled(false);
                } else {
                    e.setCanceled(true);
                }
            }
        }
    }

    private void spawnEntity(Entity targetEntity, Entity entity) {
        World worldIn = targetEntity.func_130014_f_();
        EntityLiving entityliving = (EntityLiving)entity;
        entity.func_70012_b(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        entityliving.field_70759_as = entityliving.field_70177_z;
        entityliving.field_70761_aq = entityliving.field_70177_z;
        entityliving.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
        entityliving.func_70642_aH();
        worldIn.func_72838_d(entity);
    }
}

