/*
 * Decompiled with CFR 0.152.
 */
package com.dmonsters.items;

import com.dmonsters.entity.EntityBaby;
import com.dmonsters.entity.EntityClimber;
import com.dmonsters.entity.EntityEntrail;
import com.dmonsters.entity.EntityFreezer;
import com.dmonsters.entity.EntityHauntedCow;
import com.dmonsters.entity.EntityMutantSteve;
import com.dmonsters.entity.EntityPresent;
import com.dmonsters.entity.EntityStranger;
import com.dmonsters.entity.EntityTopielec;
import com.dmonsters.entity.EntityWideman;
import com.dmonsters.entity.EntityWoman;
import com.dmonsters.entity.EntityZombieChicken;
import com.dmonsters.main.MainMod;
import net.minecraft.block.BlockFence;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class MobSpawnerItem
extends Item {
    private String mobName;

    public MobSpawnerItem(String name) {
        this.setRegistryName("mobSpawnerItem_" + name);
        this.func_77655_b("dmonsters.mobSpawnerItem_" + name);
        this.func_77637_a(MainMod.MOD_CREATIVETAB);
        this.mobName = name;
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Entity entity;
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        pos = pos.func_177972_a(facing);
        double d0 = 0.0;
        if (facing == EnumFacing.UP && iblockstate.func_177230_c() instanceof BlockFence) {
            d0 = 0.5;
        }
        if ((entity = this.spawnEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5)) != null) {
            if (entity instanceof EntityLivingBase && stack.func_82837_s()) {
                entity.func_96094_a(stack.func_82833_r());
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private Entity spawnEntity(World worldIn, double x, double y, double z) {
        Entity entity = this.getEntity(worldIn);
        EntityLiving entityliving = (EntityLiving)entity;
        entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        entityliving.field_70759_as = entityliving.field_70177_z;
        entityliving.field_70761_aq = entityliving.field_70177_z;
        entityliving.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
        worldIn.func_72838_d(entity);
        entityliving.func_70642_aH();
        return entity;
    }

    private Entity getEntity(World worldIn) {
        EntityMob entity = new EntityZombieChicken(worldIn);
        switch (this.mobName) {
            case "baby": {
                entity = new EntityBaby(worldIn);
                break;
            }
            case "climber": {
                entity = new EntityClimber(worldIn);
                break;
            }
            case "entrail": {
                entity = new EntityEntrail(worldIn);
                break;
            }
            case "freezer": {
                entity = new EntityFreezer(worldIn);
                break;
            }
            case "mutantSteve": {
                entity = new EntityMutantSteve(worldIn);
                break;
            }
            case "wideman": {
                entity = new EntityWideman(worldIn);
                break;
            }
            case "woman": {
                entity = new EntityWoman(worldIn);
                break;
            }
            case "zombieChicken": {
                entity = new EntityZombieChicken(worldIn);
                break;
            }
            case "present": {
                entity = new EntityPresent(worldIn);
                break;
            }
            case "stranger": {
                entity = new EntityStranger(worldIn);
                break;
            }
            case "hauntedCow": {
                entity = new EntityHauntedCow(worldIn);
                break;
            }
            case "topielec": {
                entity = new EntityTopielec(worldIn);
            }
        }
        return entity;
    }
}

