/*
 * Decompiled with CFR 0.152.
 */
package com.dmonsters.entity;

import com.dmonsters.ai.EntityAIPresent;
import com.dmonsters.main.ModBlocks;
import com.dmonsters.main.ModConfig;
import com.dmonsters.main.ModSounds;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityPresent
extends EntityMob {
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(EntityPresent.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityPresent.class, (DataSerializer)DataSerializers.field_187198_h);
    private PriorityQueue<BlockPos> freezedBlocks = new PriorityQueue(10);
    public static final ResourceLocation LOOT = new ResourceLocation("dmonsters", "present");
    private int cageTicks = 0;
    private boolean debugCage;

    public EntityPresent(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.5f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3 * (double)ModConfig.speedMultiplier * (double)ModConfig.entrailSpeedMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0 * (double)ModConfig.strengthMultiplier * (double)ModConfig.entrailStrengthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(26.0 * (double)ModConfig.healthMultiplier * (double)ModConfig.entrailHealthMultiplier);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPresent(this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.applyEntityAI();
    }

    private void applyEntityAI() {
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            this.func_184185_a(ModSounds.PRESENT_ATTACK, 1.0f, 1.0f);
            if (entityIn instanceof EntityPlayer) {
                this.makeCage((EntityPlayer)entityIn);
            }
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        if (this.debugCage) {
            ++this.cageTicks;
            if (this.cageTicks == 400) {
                this.cageTicks = 0;
                this.debugCage = false;
            }
        }
        super.func_70636_d();
    }

    private void makeCage(EntityPlayer player) {
        if (this.debugCage) {
            return;
        }
        this.debugCage = true;
        int height = 3;
        int hSize = 3;
        int vSize = 7;
        int xPos = (int)this.field_70165_t;
        int yPos = (int)this.field_70163_u;
        int zPos = (int)this.field_70161_v;
        int hCenter = (int)((float)hSize * 0.5f) - 1;
        for (int i = 0; i < vSize; ++i) {
            for (int x = -hSize; x < hSize + 1; ++x) {
                for (int z = -hSize; z < hSize + 1; ++z) {
                    Block block;
                    BlockPos pos;
                    if (x == -hSize || x == hSize || z == -hSize || z == hSize) {
                        pos = new BlockPos(x + xPos, yPos + height + i, z + zPos);
                        block = this.field_70170_p.func_180495_p(pos).func_177230_c();
                        if (block != Blocks.field_150350_a) continue;
                        if (x == hCenter || z == hCenter) {
                            this.field_70170_p.func_175656_a(pos, ModBlocks.presentBlock.func_176203_a(1));
                            continue;
                        }
                        this.field_70170_p.func_175656_a(pos, ModBlocks.presentBlock.func_176203_a(0));
                        continue;
                    }
                    if (i != 0 && i != vSize - 1 || (block = this.field_70170_p.func_180495_p(pos = new BlockPos(x + xPos, yPos + i + height, z + zPos)).func_177230_c()) != Blocks.field_150350_a) continue;
                    int xCent = hCenter;
                    int zCent = hCenter;
                    if (x == xCent && z == zCent) {
                        BlockPos lightPos = new BlockPos(xCent + xPos, yPos + height + 1, zCent + zPos);
                        this.field_70170_p.func_175656_a(lightPos, Blocks.field_150478_aa.func_176223_P());
                        if (!this.field_70170_p.field_72995_K) {
                            EntityCreeper creeper = new EntityCreeper(this.field_70170_p);
                            creeper.func_70107_b((double)lightPos.func_177958_n(), (double)lightPos.func_177956_o(), (double)lightPos.func_177952_p());
                            this.field_70170_p.func_72838_d((Entity)creeper);
                        }
                    }
                    if (x == 0 || z == 0) {
                        this.field_70170_p.func_175656_a(pos, ModBlocks.presentBlock.func_176203_a(1));
                        continue;
                    }
                    this.field_70170_p.func_175656_a(pos, ModBlocks.presentBlock.func_176203_a(0));
                }
            }
        }
        player.func_70634_a((double)((float)xPos + (float)hSize * 0.5f - 1.0f), (double)(yPos + height + 1), (double)((float)zPos + (float)hSize * 0.5f - 1.0f));
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.PRESENT_DEATH;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.PRESENT_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource amageSource) {
        return ModSounds.PRESENT_HURT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public boolean func_70601_bi() {
        BlockPos pos = this.func_180425_c();
        return super.func_70601_bi() && this.field_70170_p.func_175678_i(pos);
    }
}

