/*
 * Decompiled with CFR 0.152.
 */
package com.dmonsters.blocks;

import com.dmonsters.main.IMetaBlockName;
import com.dmonsters.main.MainMod;
import com.dmonsters.main.ModBlocks;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Dump
extends Block
implements IMetaBlockName {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.4, 0.75);
    public static final PropertyInteger STACKS = PropertyInteger.func_177719_a((String)"stacks", (int)0, (int)15);

    public Dump() {
        super(Material.field_151568_F);
        this.func_149663_c("dmonsters.dump");
        this.setRegistryName("dump");
        this.setCreativeTab(MainMod.MOD_CREATIVETAB);
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STACKS, (Comparable)Integer.valueOf(0)));
    }

    public Dump setCreativeTab(CreativeTabs tab) {
        super.func_149647_a(tab);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 1; ++i) {
            double motionY = Math.abs(rand.nextGaussian() * 0.02);
            float randX = rand.nextFloat();
            float randY = rand.nextFloat();
            float randZ = rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + randX), (double)((float)pos.func_177956_o() + randY), (double)((float)pos.func_177952_p() + randZ), 0.0, motionY, 0.0, new int[0]);
        }
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (!worldIn.field_72995_K) {
            BlockPos blockPos = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            if (this.checkSaplingBlock(worldIn, blockPos, pos) && ++meta == 4) {
                return Blocks.field_150350_a.func_176223_P();
            }
            blockPos = new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            if (this.checkSaplingBlock(worldIn, blockPos, pos) && ++meta == 4) {
                return Blocks.field_150350_a.func_176223_P();
            }
            blockPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            if (this.checkSaplingBlock(worldIn, blockPos, pos) && ++meta == 4) {
                return Blocks.field_150350_a.func_176223_P();
            }
            blockPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            if (this.checkSaplingBlock(worldIn, blockPos, pos) && ++meta == 4) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return ModBlocks.dump.func_176203_a(meta);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
        BlockPos blockPos = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
        if (this.checkSaplingBlock(worldIn, blockPos, pos)) {
            return;
        }
        blockPos = new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
        if (this.checkSaplingBlock(worldIn, blockPos, pos)) {
            return;
        }
        blockPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
        if (this.checkSaplingBlock(worldIn, blockPos, pos)) {
            return;
        }
        blockPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
        if (this.checkSaplingBlock(worldIn, blockPos, pos)) {
            return;
        }
    }

    private boolean checkSaplingBlock(World worldIn, BlockPos pos, BlockPos curretPos) {
        IBlockState blockNear = worldIn.func_180495_p(pos);
        if (blockNear.func_177230_c() instanceof BlockSapling) {
            this.updateDumpState(worldIn, curretPos);
            BlockPlanks.EnumType test = (BlockPlanks.EnumType)blockNear.func_185899_b((IBlockAccess)worldIn, pos).func_177228_b().values().asList().get(1);
            this.generateTree(worldIn, pos, blockNear, new Random(), test);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (int i = 0; i < 4; ++i) {
            subItems.add(new ItemStack(itemIn, 1, i));
        }
    }

    private void updateDumpState(World worldIn, BlockPos curretPos) {
        IBlockState block = worldIn.func_180495_p(curretPos);
        if (!(block.func_177230_c() instanceof Dump)) {
            return;
        }
        int stateValue = (Integer)block.func_177229_b((IProperty)STACKS);
        if (++stateValue < 4) {
            worldIn.func_175656_a(curretPos, ModBlocks.dump.func_176203_a(stateValue));
        } else {
            worldIn.func_175656_a(curretPos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand, BlockPlanks.EnumType saplingType) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        WorldGenBigTree worldgenerator = rand.nextInt(10) == 0 ? new WorldGenBigTree(true) : new WorldGenTrees(true);
        int i = 0;
        int j = 0;
        boolean flag = false;
        switch (saplingType) {
            case SPRUCE: {
                block7: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!this.isTwoByTwoOfType(worldIn, pos, i, j, BlockPlanks.EnumType.SPRUCE, saplingType)) continue;
                        worldgenerator = new WorldGenMegaPineTree(false, rand.nextBoolean());
                        flag = true;
                        break block7;
                    }
                }
                if (flag) break;
                i = 0;
                j = 0;
                worldgenerator = new WorldGenTaiga2(true);
                break;
            }
            case BIRCH: {
                worldgenerator = new WorldGenBirchTree(true, false);
                break;
            }
            case JUNGLE: {
                IBlockState iblockstate = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
                IBlockState iblockstate1 = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
                worldgenerator = new WorldGenMegaJungle(true, 10, 20, iblockstate, iblockstate1);
                break;
            }
            case ACACIA: {
                worldgenerator = new WorldGenSavannaTree(true);
                break;
            }
            case DARK_OAK: {
                block9: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!this.isTwoByTwoOfType(worldIn, pos, i, j, BlockPlanks.EnumType.DARK_OAK, saplingType)) continue;
                        worldgenerator = new WorldGenCanopyTree(true);
                        flag = true;
                        break block9;
                    }
                }
                if (flag) break;
                return;
            }
        }
        IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
        if (flag) {
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), iblockstate2, 4);
        } else {
            worldIn.func_180501_a(pos, iblockstate2, 4);
        }
        if (!worldgenerator.func_180709_b(worldIn, rand, pos.func_177982_a(i, 0, j))) {
            if (flag) {
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), state, 4);
            } else {
                worldIn.func_180501_a(pos, state, 4);
            }
        }
    }

    private boolean isTwoByTwoOfType(World worldIn, BlockPos pos, int p_181624_3_, int p_181624_4_, BlockPlanks.EnumType type, BlockPlanks.EnumType saplingType) {
        return this.isTypeAt(worldIn, pos.func_177982_a(p_181624_3_, 0, p_181624_4_), type, saplingType) && this.isTypeAt(worldIn, pos.func_177982_a(p_181624_3_ + 1, 0, p_181624_4_), type, saplingType) && this.isTypeAt(worldIn, pos.func_177982_a(p_181624_3_, 0, p_181624_4_ + 1), type, saplingType) && this.isTypeAt(worldIn, pos.func_177982_a(p_181624_3_ + 1, 0, p_181624_4_ + 1), type, saplingType);
    }

    public boolean isTypeAt(World worldIn, BlockPos pos, BlockPlanks.EnumType type, BlockPlanks.EnumType saplingType) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        return iblockstate.func_177230_c() == this && saplingType == type;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STACKS});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STACKS);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STACKS, (Comparable)Integer.valueOf(meta));
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return "dump_" + Integer.toString(stack.func_77960_j());
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }
}

