/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinitionCustomLight;
import com.bloodnbonesgaming.dimensionalcontrol.util.BiomeHelper;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.init.Biomes;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/genlayers/GenLayerBiomeDC", classExplaination="A configurable version of the vanilla GenLayerBiome. Replaces the heat map with a pseudo-random weighted biome map.")
public class GenLayerBiomeDC
extends GenLayer {
    private List<BiomeManager.BiomeEntry> ocean = new ArrayList<BiomeManager.BiomeEntry>();
    private List<BiomeManager.BiomeEntry> desert = new ArrayList<BiomeManager.BiomeEntry>();
    private List<BiomeManager.BiomeEntry> warm = new ArrayList<BiomeManager.BiomeEntry>();
    private List<BiomeManager.BiomeEntry> cool = new ArrayList<BiomeManager.BiomeEntry>();
    private List<BiomeManager.BiomeEntry> icy = new ArrayList<BiomeManager.BiomeEntry>();
    private Integer specialOcean;
    private Integer specialVariantOcean;
    private int specialVariantOceanChance = 3;
    private Integer specialDesert;
    private Integer specialVariantDesert;
    private int specialVariantDesertChance = 3;
    private Integer specialWarm;
    private Integer specialVariantWarm;
    private int specialVariantWarmChance = 3;
    private Integer specialCool;
    private Integer specialVariantCool;
    private int specialVariantCoolChance = 3;
    private Integer specialIcy;
    private Integer specialVariantIcy;
    private int specialVariantIcyChance = 3;

    @ScriptMethodDocumentation(args="long, GenLayer", usage="base layer seed, parent layer", notes="Constructs the layer with its seed and parent layer.")
    public GenLayerBiomeDC(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
    }

    public GenLayerBiomeDC(long seed, GenLayer parent, BiomeProviderDefinitionCustomLight definition) {
        this(seed, parent);
        this.ocean = definition.getOceanBiomes();
        this.desert = definition.getDesertBiomes();
        this.warm = definition.getWarmBiomes();
        this.cool = definition.getCoolBiomes();
        this.icy = definition.getIcyBiomes();
        int specialVariantChance = definition.getSpecialVariantChance() != null ? definition.getSpecialVariantChance() : 3;
        this.specialOcean = definition.getSpecialOcean();
        this.specialVariantOcean = definition.getSpecialVariantOcean();
        this.specialVariantOceanChance = definition.getSpecialVariantOceanChance() != null ? definition.getSpecialVariantOceanChance() : specialVariantChance;
        this.specialDesert = definition.getSpecialDesert();
        this.specialVariantDesert = definition.getSpecialVariantDesert();
        this.specialVariantDesertChance = definition.getSpecialVariantDesertChance() != null ? definition.getSpecialVariantDesertChance() : specialVariantChance;
        this.specialWarm = definition.getSpecialWarm();
        this.specialVariantWarm = definition.getSpecialVariantWarm();
        this.specialVariantWarmChance = definition.getSpecialVariantWarmChance() != null ? definition.getSpecialVariantWarmChance() : specialVariantChance;
        this.specialCool = definition.getSpecialCool();
        this.specialVariantCool = definition.getSpecialVariantCool();
        this.specialVariantCoolChance = definition.getSpecialVariantCoolChance() != null ? definition.getSpecialVariantCoolChance() : specialVariantChance;
        this.specialIcy = definition.getSpecialIcy();
        this.specialVariantIcy = definition.getSpecialVariantIcy();
        this.specialVariantIcyChance = definition.getSpecialVariantIcyChance() != null ? definition.getSpecialVariantIcyChance() : specialVariantChance;
    }

    @ScriptArgs(args={ArgType.STRING, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome type, biome ID", notes="Adds the provided biome id to the provided type with a weight of 1. Type options are \"Ocean\", \"Desert\", \"Warm\", \"Cool\", \"Icy\"")
    public void addBiome(String type, int id) {
        this.addBiome(type, id, 1);
    }

    @ScriptArgs(args={ArgType.STRING, ArgType.NON_NULL_BIOME_ID, ArgType.INT})
    @ScriptMethodDocumentation(usage="biome type, biome ID, weight", notes="Adds the provided biome id to the provided type with the provided weight. Type options are \"Ocean\", \"Desert\", \"Warm\", \"Cool\", \"Icy\".")
    public void addBiome(String type, int id, int weight) {
        if (type.equalsIgnoreCase("Ocean")) {
            BiomeManager.BiomeEntry entry = BiomeHelper.generateBiomeEntry(id, weight);
            if (entry != null) {
                this.ocean.add(entry);
            }
        } else if (type.equalsIgnoreCase("Desert")) {
            BiomeManager.BiomeEntry entry = BiomeHelper.generateBiomeEntry(id, weight);
            if (entry != null) {
                this.desert.add(entry);
            }
        } else if (type.equalsIgnoreCase("Warm")) {
            BiomeManager.BiomeEntry entry = BiomeHelper.generateBiomeEntry(id, weight);
            if (entry != null) {
                this.warm.add(entry);
            }
        } else if (type.equalsIgnoreCase("Cool")) {
            BiomeManager.BiomeEntry entry = BiomeHelper.generateBiomeEntry(id, weight);
            if (entry != null) {
                this.cool.add(entry);
            }
        } else if (type.equalsIgnoreCase("Icy")) {
            BiomeManager.BiomeEntry entry = BiomeHelper.generateBiomeEntry(id, weight);
            if (entry != null) {
                this.icy.add(entry);
            }
        } else {
            DimensionalControl.instance.getLog().error((Object)(type + " is not a biome type!"));
        }
    }

    @ScriptMethodDocumentation(args="int", usage="chance", notes="Sets the global chance for the special variant biome to be used. This will set the chance for all types. Set this before you set specific ones or it will overwrite. The chance is 1 in the provided number.")
    public void setSpecialVariantChance(int chance) {
        this.specialVariantOceanChance = chance;
        this.specialVariantDesertChance = chance;
        this.specialVariantWarmChance = chance;
        this.specialVariantCoolChance = chance;
        this.specialVariantIcyChance = chance;
    }

    @ScriptMethodDocumentation(args="String, int", usage="biome type, chance", notes="Sets the chance for the special variant biome to be used for the provided type. The chance is 1 in the provided number. Type options are \"Ocean\", \"Desert\", \"Warm\", \"Cool\", \"Icy\".")
    public void setSpecialVariantChance(String type, int chance) {
        if (type.equalsIgnoreCase("Ocean")) {
            this.specialVariantOceanChance = chance;
        } else if (type.equalsIgnoreCase("Desert")) {
            this.specialVariantDesertChance = chance;
        } else if (type.equalsIgnoreCase("Warm")) {
            this.specialVariantWarmChance = chance;
        } else if (type.equalsIgnoreCase("Cool")) {
            this.specialVariantCoolChance = chance;
        } else if (type.equalsIgnoreCase("Icy")) {
            this.specialVariantIcyChance = chance;
        } else {
            DimensionalControl.instance.getLog().error((Object)(type + " is not a biome type!"));
        }
    }

    @ScriptArgs(args={ArgType.STRING, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome type, biome ID", notes="Sets the special biome for the provided type. Type options are \"Ocean\", \"Desert\", \"Warm\", \"Cool\", \"Icy\".")
    public void setSpecialBiome(String type, int biome) {
        if (type.equalsIgnoreCase("Ocean")) {
            this.specialOcean = biome;
        } else if (type.equalsIgnoreCase("Desert")) {
            this.specialDesert = biome;
        } else if (type.equalsIgnoreCase("Warm")) {
            this.specialWarm = biome;
        } else if (type.equalsIgnoreCase("Cool")) {
            this.specialCool = biome;
        } else if (type.equalsIgnoreCase("Icy")) {
            this.specialIcy = biome;
        } else {
            DimensionalControl.instance.getLog().error((Object)(type + " is not a biome type!"));
        }
    }

    @ScriptArgs(args={ArgType.STRING, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome type, biome ID", notes="Sets the special variant biome for the provided type. Type options are \"Ocean\", \"Desert\", \"Warm\", \"Cool\", \"Icy\".")
    public void setSpecialVariantBiome(String type, int biome) {
        if (type.equalsIgnoreCase("Ocean")) {
            this.specialVariantOcean = biome;
        } else if (type.equalsIgnoreCase("Desert")) {
            this.specialVariantDesert = biome;
        } else if (type.equalsIgnoreCase("Warm")) {
            this.specialVariantWarm = biome;
        } else if (type.equalsIgnoreCase("Cool")) {
            this.specialVariantCool = biome;
        } else if (type.equalsIgnoreCase("Icy")) {
            this.specialVariantIcy = biome;
        } else {
            DimensionalControl.instance.getLog().error((Object)(type + " is not a biome type!"));
        }
    }

    @ScriptArgs(args={ArgType.STRING})
    @ScriptMethodDocumentation(usage="biome type", notes="Fills the BiomeEntry list for the provided type with the entries it would contain in vanilla. Type options are \"Ocean\", \"Desert\", \"Warm\", \"Cool\", \"Icy\".")
    public void fillWithVanillaBiomes(String type) {
        if (!type.equalsIgnoreCase("Ocean")) {
            if (type.equalsIgnoreCase("Desert")) {
                ImmutableList biomes = BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT);
                this.desert.addAll((Collection<BiomeManager.BiomeEntry>)biomes);
                this.desert.add(new BiomeManager.BiomeEntry(Biomes.field_76769_d, 30));
                this.desert.add(new BiomeManager.BiomeEntry(Biomes.field_150588_X, 20));
                this.desert.add(new BiomeManager.BiomeEntry(Biomes.field_76772_c, 10));
            } else if (type.equalsIgnoreCase("Warm")) {
                ImmutableList biomes = BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM);
                this.warm.addAll((Collection<BiomeManager.BiomeEntry>)biomes);
            } else if (type.equalsIgnoreCase("Cool")) {
                ImmutableList biomes = BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL);
                this.cool.addAll((Collection<BiomeManager.BiomeEntry>)biomes);
            } else if (type.equalsIgnoreCase("Icy")) {
                ImmutableList biomes = BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY);
                this.icy.addAll((Collection<BiomeManager.BiomeEntry>)biomes);
            } else {
                DimensionalControl.instance.getLog().error((Object)(type + " is not a biome type!"));
            }
        }
    }

    @ScriptMethodDocumentation(usage="", notes="Fills all BiomeEntry lists with the entries they would contain in vanilla.")
    public void fillWithVanillaBiomes() {
        this.fillWithVanillaBiomes("Desert");
        this.fillWithVanillaBiomes("Warm");
        this.fillWithVanillaBiomes("Cool");
        this.fillWithVanillaBiomes("Icy");
        this.fillWithVanillaBiomes("Ocean");
    }

    @ScriptArgs(args={ArgType.STRING, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome type, biome ID", notes="Removes any entries with the provided biome entry from the provided type. Type options are \"Ocean\", \"Desert\", \"Warm\", \"Cool\", \"Icy\"")
    public void removeEntriesForBiome(String type, int biome) {
        if (type.equalsIgnoreCase("Ocean")) {
            Biome biomeObj = Biome.func_185357_a((int)biome);
            Iterator<BiomeManager.BiomeEntry> iterator = this.ocean.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().biome != biomeObj) continue;
                iterator.remove();
            }
        } else if (type.equalsIgnoreCase("Desert")) {
            Biome biomeObj = Biome.func_185357_a((int)biome);
            Iterator<BiomeManager.BiomeEntry> iterator = this.desert.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().biome != biomeObj) continue;
                iterator.remove();
            }
        } else if (type.equalsIgnoreCase("Warm")) {
            Biome biomeObj = Biome.func_185357_a((int)biome);
            Iterator<BiomeManager.BiomeEntry> iterator = this.warm.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().biome != biomeObj) continue;
                iterator.remove();
            }
        } else if (type.equalsIgnoreCase("Cool")) {
            Biome biomeObj = Biome.func_185357_a((int)biome);
            Iterator<BiomeManager.BiomeEntry> iterator = this.cool.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().biome != biomeObj) continue;
                iterator.remove();
            }
        } else if (type.equalsIgnoreCase("Icy")) {
            Biome biomeObj = Biome.func_185357_a((int)biome);
            Iterator<BiomeManager.BiomeEntry> iterator = this.icy.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().biome != biomeObj) continue;
                iterator.remove();
            }
        } else {
            DimensionalControl.instance.getLog().error((Object)(type + " is not a biome type!"));
        }
    }

    @ScriptArgs(args={ArgType.STRING, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome type, biome ID", notes="Removes any entries with the provided biome entry from the provided type. Type options are \"Ocean\", \"Desert\", \"Warm\", \"Cool\", \"Icy\"")
    public void removeEntriesForBiome(int biome) {
        this.removeEntriesForBiome("Desert", biome);
        this.removeEntriesForBiome("Warm", biome);
        this.removeEntriesForBiome("Cool", biome);
        this.removeEntriesForBiome("Icy", biome);
        this.removeEntriesForBiome("Ocean", biome);
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int[] parentInts;
        int arrayLength = width * depth;
        int[] returnInts = IntCache.func_76445_a((int)arrayLength);
        if (this.field_75909_a != null) {
            parentInts = this.field_75909_a.func_75904_a(chunkX, chunkZ, width, depth);
        } else {
            parentInts = IntCache.func_76445_a((int)arrayLength);
            for (int i = 0; i < parentInts.length; ++i) {
                parentInts[i] = 0;
            }
        }
        for (int z = 0; z < depth; ++z) {
            block9: for (int x = 0; x < width; ++x) {
                this.func_75903_a(x + chunkX, z + chunkZ);
                int index = x + z * width;
                int currentBiome = parentInts[index];
                boolean useSpecialBiome = (currentBiome & 0xF00) >> 8 > 0;
                int warmth = currentBiome & 0xFFFFF0FF;
                switch (warmth) {
                    case 0: {
                        if (useSpecialBiome) {
                            if (this.specialVariantOcean != null && this.func_75902_a(this.specialVariantOceanChance) == 0) {
                                returnInts[index] = this.specialVariantOcean;
                                continue block9;
                            }
                            if (this.specialOcean != null) {
                                returnInts[index] = this.specialOcean;
                                continue block9;
                            }
                        }
                        if (this.ocean.size() > 0) {
                            returnInts[index] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry(this.ocean).biome);
                            continue block9;
                        }
                        returnInts[index] = 0;
                        continue block9;
                    }
                    case 1: {
                        if (useSpecialBiome) {
                            if (this.specialVariantDesert != null && this.func_75902_a(this.specialVariantDesertChance) == 0) {
                                returnInts[index] = this.specialVariantDesert;
                                continue block9;
                            }
                            if (this.specialDesert != null) {
                                returnInts[index] = this.specialDesert;
                                continue block9;
                            }
                        }
                        if (this.desert.size() > 0) {
                            returnInts[index] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry(this.desert).biome);
                            continue block9;
                        }
                        returnInts[index] = 0;
                        continue block9;
                    }
                    case 2: {
                        if (useSpecialBiome) {
                            if (this.specialVariantWarm != null && this.func_75902_a(this.specialVariantWarmChance) == 0) {
                                returnInts[index] = this.specialVariantWarm;
                                continue block9;
                            }
                            if (this.specialWarm != null) {
                                returnInts[index] = this.specialWarm;
                                continue block9;
                            }
                        }
                        if (this.warm.size() > 0) {
                            returnInts[index] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry(this.warm).biome);
                            continue block9;
                        }
                        returnInts[index] = 0;
                        continue block9;
                    }
                    case 3: {
                        if (useSpecialBiome) {
                            if (this.specialVariantCool != null && this.func_75902_a(this.specialVariantCoolChance) == 0) {
                                returnInts[index] = this.specialVariantCool;
                                continue block9;
                            }
                            if (this.specialCool != null) {
                                returnInts[index] = this.specialCool;
                                continue block9;
                            }
                        }
                        if (this.cool.size() > 0) {
                            returnInts[index] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry(this.cool).biome);
                            continue block9;
                        }
                        returnInts[index] = 0;
                        continue block9;
                    }
                    case 4: {
                        if (useSpecialBiome) {
                            if (this.specialVariantIcy != null && this.func_75902_a(this.specialVariantIcyChance) == 0) {
                                returnInts[index] = this.specialVariantIcy;
                                continue block9;
                            }
                            if (this.specialIcy != null) {
                                returnInts[index] = this.specialIcy;
                                continue block9;
                            }
                        }
                        if (this.icy.size() > 0) {
                            returnInts[index] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry(this.icy).biome);
                            continue block9;
                        }
                        returnInts[index] = 0;
                        continue block9;
                    }
                    default: {
                        returnInts[index] = parentInts[index];
                    }
                }
            }
        }
        return returnInts;
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(List<BiomeManager.BiomeEntry> biomeList) {
        boolean modded = false;
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = modded ? this.func_75902_a(totalWeight) : this.func_75902_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }
}

