/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer;

import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinitionCustomLight;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.IntCache;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/genlayers/GenLayerAddMushroomIslandDC", classExplaination="A copy of the vanilla GenLayerAddMushroomIsland with an optional disable. I can't think of a single reason to use this rather than just not adding the layer.")
public class GenLayerAddMushroomIslandDC
extends GenLayer {
    private boolean shouldDisableMushroomIslandLayer = false;

    @ScriptMethodDocumentation(args="long, GenLayer", usage="base layer seed, parent layer", notes="Constructs the layer with the seed and parent.")
    public GenLayerAddMushroomIslandDC(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
    }

    public GenLayerAddMushroomIslandDC(long seed, GenLayerAddIsland parent, BiomeProviderDefinitionCustomLight definition) {
        this(seed, (GenLayer)parent);
        this.shouldDisableMushroomIslandLayer(definition.shouldDisableMushroomIslandLayer());
    }

    @ScriptMethodDocumentation(args="boolean", usage="", notes="Sets whether the layer should be disabled", defaultValues="false")
    public void shouldDisableMushroomIslandLayer(boolean bool) {
        this.shouldDisableMushroomIslandLayer = bool;
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int i1 = chunkX - 1;
        int j1 = chunkZ - 1;
        int k1 = width + 2;
        int l1 = depth + 2;
        int[] aint = this.field_75909_a.func_75904_a(i1, j1, k1, l1);
        int[] aint1 = IntCache.func_76445_a((int)(width * depth));
        if (this.shouldDisableMushroomIslandLayer) {
            for (int z = 0; z < depth; ++z) {
                for (int x = 0; x < width; ++x) {
                    aint1[x + z * width] = aint[x + 1 + (z + 1) * k1];
                }
            }
        } else {
            for (int z = 0; z < depth; ++z) {
                for (int x = 0; x < width; ++x) {
                    int k2 = aint[x + 0 + (z + 0) * k1];
                    int l2 = aint[x + 2 + (z + 0) * k1];
                    int i3 = aint[x + 0 + (z + 2) * k1];
                    int j3 = aint[x + 2 + (z + 2) * k1];
                    int k3 = aint[x + 1 + (z + 1) * k1];
                    this.func_75903_a(x + chunkX, z + chunkZ);
                    aint1[x + z * width] = k3 == 0 && k2 == 0 && l2 == 0 && i3 == 0 && j3 == 0 && this.func_75902_a(100) == 0 ? Biome.func_185362_a((Biome)Biomes.field_76789_p) : k3;
                }
            }
        }
        return aint1;
    }
}

