/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator;

import com.bloodnbonesgaming.dimensionalcontrol.util.MathHelper;
import com.bloodnbonesgaming.dimensionalcontrol.util.noise.OpenSimplexNoiseGeneratorOctaves;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.ForgeEventFactory;

public class ChunkGeneratorSky2
implements IChunkGenerator {
    final Random rand = new Random();
    final World world;
    Biome[] biomesForGeneration;
    protected final OpenSimplexNoiseGeneratorOctaves terrainNoise;
    final Random mountainRand = new Random();
    double[] smallNoiseArray = new double[825];
    double[] largeNoiseArray = new double[65536];
    protected NoiseGeneratorPerlin surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
    protected double[] depthBuffer = new double[256];
    final List<BlockPos> largeIslands = new ArrayList<BlockPos>();
    final List<BlockPos> mediumIslands = new ArrayList<BlockPos>();
    final List<BlockPos> smallIslands = new ArrayList<BlockPos>();
    final List<BlockPos> tinyIslands = new ArrayList<BlockPos>();
    final double largeRadius = 100.0;
    final double mediumRadius = 50.0;
    final double smallRadius = 25.0;
    final double tinyRadius = 10.0;
    final int largeIslandCount = 1;
    final int mediumIslandCount = 32;
    final int smallIslandCount = 64;
    final int tinyIslandCount = 128;
    final int regionSize = 464;
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    protected static final IBlockState RED_SANDSTONE = Blocks.field_180395_cM.func_176223_P();
    protected static final IBlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150432_aD.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();

    public ChunkGeneratorSky2(World world) {
        this.world = world;
        this.terrainNoise = new OpenSimplexNoiseGeneratorOctaves(world.func_72905_C());
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.mountainRand.setSeed((long)((int)Math.floor((double)x * 16.0 / 464.0)) * 341873128712L + (long)((int)Math.floor((double)z * 16.0 / 464.0)) * 132897987541L);
        this.generateMountainFeatures(x, z, chunkprimer);
        this.generateMediumIslands(x, z, chunkprimer);
        this.generateSmallIslands(x, z, chunkprimer);
        this.generateTinyIslands(x, z, chunkprimer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.largeIslands.clear();
        this.mediumIslands.clear();
        this.smallIslands.clear();
        this.tinyIslands.clear();
        if (ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)chunkprimer, (World)this.world)) {
            this.replaceBiomeBlocks(x, z, chunkprimer, this.biomesForGeneration);
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void generateNoise(double[] array, int arraySizeX, int arraySizeY, int arraySizeZ, int x, int y, int z, int xCoordinateScale, int yCoordinateScale, int zCoordinateScale) {
        for (int xI = 0; xI < arraySizeX; ++xI) {
            for (int zI = 0; zI < arraySizeZ; ++zI) {
                for (int yI = 0; yI < arraySizeY; ++yI) {
                    double noise;
                    int index = (xI * arraySizeX + zI) * arraySizeY + yI;
                    array[index] = noise = this.terrainNoise.eval((double)(x + xI * xCoordinateScale) / 128.0, (double)(y + yI * yCoordinateScale) / 32.0, (double)(z + zI * zCoordinateScale) / 128.0, 3, 0.5);
                }
            }
        }
    }

    public void generateMountainFeatures(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.generateNoise(this.smallNoiseArray, 5, 33, 5, chunkX * 16, 0, chunkZ * 16, 4, 8, 4);
        MathHelper.interpolate(this.smallNoiseArray, this.largeNoiseArray, 5, 33, 5, 4, 8, 4);
        double maxFeatureRadius = this.largeRadius;
        double midHeight = maxFeatureRadius + (double)this.mountainRand.nextInt((int)(220.0 - maxFeatureRadius * 2.0));
        int regionCenterX = (int)Math.floor((double)chunkX * 16.0 / 464.0) * 464 + 232;
        int regionCenterZ = (int)Math.floor((double)chunkZ * 16.0 / 464.0) * 464 + 232;
        int randomSpace = (int)(464.0 - maxFeatureRadius * 2.0);
        int featureCenterX = this.mountainRand.nextInt(randomSpace) - randomSpace / 2 + regionCenterX;
        int featureCenterZ = this.mountainRand.nextInt(randomSpace) - randomSpace / 2 + regionCenterZ;
        this.largeIslands.add(new BlockPos(featureCenterX, 0, featureCenterZ));
        int chunkBlockX = chunkX * 16;
        int chunkBlockZ = chunkZ * 16;
        for (double x = 0.0; x < 16.0; x += 1.0) {
            double realX = x + (double)chunkBlockX;
            double xDistance = Math.pow(Math.abs((double)featureCenterX - realX), 2.0);
            for (double z = 0.0; z < 16.0; z += 1.0) {
                double realZ = z + (double)chunkBlockZ;
                double zDistance = Math.pow(Math.abs((double)featureCenterZ - realZ), 2.0);
                double maxNoiseDistance = (maxFeatureRadius - Math.sqrt(xDistance + zDistance)) * 1.5;
                double noise2 = this.terrainNoise.eval(realX / 32.0, realZ / 32.0, 3, 0.5);
                for (double y = 0.0; y < midHeight; y += 1.0) {
                    double skewNoise;
                    double skewedNoise;
                    double height;
                    if (Math.sqrt(xDistance + zDistance) <= maxFeatureRadius && (height = midHeight - (skewedNoise = this.terrainNoise.eval((realX + 16.0 * (skewNoise = this.largeNoiseArray[(int)((x * 16.0 + z) * 256.0 + y)] * 2.0 - 1.0)) / 32.0, (realZ + 16.0 * skewNoise) / 32.0, 3, 0.5)) * (maxNoiseDistance - 32.0 * noise2)) < y) {
                        primer.func_177855_a((int)x, (int)y, (int)z, Blocks.field_150348_b.func_176223_P());
                    }
                    if (!(Math.sqrt(xDistance + zDistance) <= maxFeatureRadius) || !((height = (skewedNoise = this.terrainNoise.eval((realX + 16.0 * (skewNoise = this.largeNoiseArray[(int)((x * 16.0 + z) * 256.0 + y)] * 2.0 - 1.0)) / 32.0, (realZ + 16.0 * skewNoise) / 32.0, 3, 0.5)) * ((maxNoiseDistance - 32.0 * noise2) / 4.0)) > y)) continue;
                    primer.func_177855_a((int)x, (int)((double)((int)y) + midHeight), (int)z, Blocks.field_150348_b.func_176223_P());
                }
            }
        }
    }

    public void generateMediumIslands(int chunkX, int chunkZ, ChunkPrimer primer) {
        block0: for (int i = 0; i < this.mediumIslandCount; ++i) {
            double maxFeatureRadius = this.mediumRadius;
            double midHeight = maxFeatureRadius + (double)this.mountainRand.nextInt((int)(220.0 - maxFeatureRadius * 2.0));
            int regionCenterX = (int)Math.floor((double)chunkX * 16.0 / 464.0) * 464 + 232;
            int regionCenterZ = (int)Math.floor((double)chunkZ * 16.0 / 464.0) * 464 + 232;
            int randomSpace = (int)(464.0 - maxFeatureRadius * 2.0);
            int featureCenterX = this.mountainRand.nextInt(randomSpace) - randomSpace / 2 + regionCenterX;
            int featureCenterZ = this.mountainRand.nextInt(randomSpace) - randomSpace / 2 + regionCenterZ;
            BlockPos pos = new BlockPos(featureCenterX, 0, featureCenterZ);
            for (BlockPos large : this.largeIslands) {
                if (!(pos.func_185332_f(large.func_177958_n(), large.func_177956_o(), large.func_177952_p()) < this.largeRadius + this.mediumRadius + 25.0)) continue;
                continue block0;
            }
            for (BlockPos medium : this.mediumIslands) {
                if (!(pos.func_185332_f(medium.func_177958_n(), medium.func_177956_o(), medium.func_177952_p()) < this.mediumRadius + this.mediumRadius + 25.0)) continue;
                continue block0;
            }
            this.mediumIslands.add(pos);
            int chunkBlockX = chunkX * 16;
            int chunkBlockZ = chunkZ * 16;
            for (double x = 0.0; x < 16.0; x += 1.0) {
                double realX = x + (double)chunkBlockX;
                double xDistance = Math.pow(Math.abs((double)featureCenterX - realX), 2.0);
                for (double z = 0.0; z < 16.0; z += 1.0) {
                    double realZ = z + (double)chunkBlockZ;
                    double zDistance = Math.pow(Math.abs((double)featureCenterZ - realZ), 2.0);
                    double maxNoiseDistance = (maxFeatureRadius - Math.sqrt(xDistance + zDistance)) * 1.5;
                    double noise2 = this.terrainNoise.eval(realX / 32.0, realZ / 32.0, 3, 0.5);
                    for (double y = 0.0; y < midHeight; y += 1.0) {
                        double skewNoise;
                        double skewedNoise;
                        double height;
                        if (Math.sqrt(xDistance + zDistance) <= maxFeatureRadius && (height = midHeight - (skewedNoise = this.terrainNoise.eval((realX + 16.0 * (skewNoise = this.largeNoiseArray[(int)((x * 16.0 + z) * 256.0 + y)] * 2.0 - 1.0)) / 32.0, (realZ + 16.0 * skewNoise) / 32.0, 3, 0.5)) * (maxNoiseDistance - 32.0 * noise2)) < y) {
                            primer.func_177855_a((int)x, (int)y, (int)z, Blocks.field_150348_b.func_176223_P());
                        }
                        if (!(Math.sqrt(xDistance + zDistance) <= maxFeatureRadius) || !((height = (skewedNoise = this.terrainNoise.eval((realX + 16.0 * (skewNoise = this.largeNoiseArray[(int)((x * 16.0 + z) * 256.0 + y)] * 2.0 - 1.0)) / 32.0, (realZ + 16.0 * skewNoise) / 32.0, 3, 0.5)) * ((maxNoiseDistance - 32.0 * noise2) / 4.0)) > y)) continue;
                        primer.func_177855_a((int)x, (int)(y + midHeight), (int)z, Blocks.field_150348_b.func_176223_P());
                    }
                }
            }
        }
    }

    public void generateSmallIslands(int chunkX, int chunkZ, ChunkPrimer primer) {
        block0: for (int i = 0; i < this.smallIslandCount; ++i) {
            double maxFeatureRadius = this.smallRadius;
            double midHeight = maxFeatureRadius + (double)this.mountainRand.nextInt((int)(220.0 - maxFeatureRadius * 2.0));
            int regionCenterX = (int)Math.floor((double)chunkX * 16.0 / 464.0) * 464 + 232;
            int regionCenterZ = (int)Math.floor((double)chunkZ * 16.0 / 464.0) * 464 + 232;
            int randomSpace = (int)(464.0 - maxFeatureRadius * 2.0);
            int featureCenterX = this.mountainRand.nextInt(randomSpace) - randomSpace / 2 + regionCenterX;
            int featureCenterZ = this.mountainRand.nextInt(randomSpace) - randomSpace / 2 + regionCenterZ;
            BlockPos pos = new BlockPos(featureCenterX, 0, featureCenterZ);
            for (BlockPos large : this.largeIslands) {
                if (!(pos.func_185332_f(large.func_177958_n(), large.func_177956_o(), large.func_177952_p()) < this.largeRadius + this.smallRadius + 25.0)) continue;
                continue block0;
            }
            for (BlockPos medium : this.mediumIslands) {
                if (!(pos.func_185332_f(medium.func_177958_n(), medium.func_177956_o(), medium.func_177952_p()) < this.mediumRadius + this.smallRadius + 25.0)) continue;
                continue block0;
            }
            for (BlockPos small : this.smallIslands) {
                if (!(pos.func_185332_f(small.func_177958_n(), small.func_177956_o(), small.func_177952_p()) < this.smallRadius + this.smallRadius + 25.0)) continue;
                continue block0;
            }
            this.smallIslands.add(pos);
            int chunkBlockX = chunkX * 16;
            int chunkBlockZ = chunkZ * 16;
            for (double x = 0.0; x < 16.0; x += 1.0) {
                double realX = x + (double)chunkBlockX;
                double xDistance = Math.pow(Math.abs((double)featureCenterX - realX), 2.0);
                for (double z = 0.0; z < 16.0; z += 1.0) {
                    double realZ = z + (double)chunkBlockZ;
                    double zDistance = Math.pow(Math.abs((double)featureCenterZ - realZ), 2.0);
                    double maxNoiseDistance = (maxFeatureRadius - Math.sqrt(xDistance + zDistance)) * 1.5;
                    double noise2 = this.terrainNoise.eval(realX / 32.0, realZ / 32.0, 3, 0.5);
                    for (double y = 0.0; y < midHeight; y += 1.0) {
                        double skewNoise;
                        double skewedNoise;
                        double height;
                        if (Math.sqrt(xDistance + zDistance) <= maxFeatureRadius && (height = midHeight - (skewedNoise = this.terrainNoise.eval((realX + 16.0 * (skewNoise = this.largeNoiseArray[(int)((x * 16.0 + z) * 256.0 + y)] * 2.0 - 1.0)) / 16.0, (realZ + 16.0 * skewNoise) / 16.0, 3, 0.5)) * (maxNoiseDistance - 32.0 * noise2)) < y) {
                            primer.func_177855_a((int)x, (int)y, (int)z, Blocks.field_150348_b.func_176223_P());
                        }
                        if (!(Math.sqrt(xDistance + zDistance) <= maxFeatureRadius) || !((height = (skewedNoise = this.terrainNoise.eval((realX + 16.0 * (skewNoise = this.largeNoiseArray[(int)((x * 16.0 + z) * 256.0 + y)] * 2.0 - 1.0)) / 16.0, (realZ + 16.0 * skewNoise) / 16.0, 3, 0.5)) * ((maxNoiseDistance - 32.0 * noise2) / 2.0)) > y)) continue;
                        primer.func_177855_a((int)x, (int)((double)((int)y) + midHeight), (int)z, Blocks.field_150348_b.func_176223_P());
                    }
                }
            }
        }
    }

    public void generateTinyIslands(int chunkX, int chunkZ, ChunkPrimer primer) {
        block0: for (int i = 0; i < this.tinyIslandCount; ++i) {
            double maxFeatureRadius = this.tinyRadius;
            double midHeight = maxFeatureRadius + (double)this.mountainRand.nextInt((int)(220.0 - maxFeatureRadius * 2.0));
            int regionCenterX = (int)Math.floor((double)chunkX * 16.0 / 464.0) * 464 + 232;
            int regionCenterZ = (int)Math.floor((double)chunkZ * 16.0 / 464.0) * 464 + 232;
            int randomSpace = (int)(464.0 - maxFeatureRadius * 2.0);
            int featureCenterX = this.mountainRand.nextInt(randomSpace) - randomSpace / 2 + regionCenterX;
            int featureCenterZ = this.mountainRand.nextInt(randomSpace) - randomSpace / 2 + regionCenterZ;
            BlockPos pos = new BlockPos(featureCenterX, 0, featureCenterZ);
            for (BlockPos large : this.largeIslands) {
                if (!(pos.func_185332_f(large.func_177958_n(), large.func_177956_o(), large.func_177952_p()) < this.largeRadius + this.tinyRadius + 25.0)) continue;
                continue block0;
            }
            for (BlockPos medium : this.mediumIslands) {
                if (!(pos.func_185332_f(medium.func_177958_n(), medium.func_177956_o(), medium.func_177952_p()) < this.mediumRadius + this.tinyRadius + 25.0)) continue;
                continue block0;
            }
            for (BlockPos small : this.smallIslands) {
                if (!(pos.func_185332_f(small.func_177958_n(), small.func_177956_o(), small.func_177952_p()) < this.smallRadius + this.tinyRadius + 25.0)) continue;
                continue block0;
            }
            for (BlockPos tiny : this.tinyIslands) {
                if (!(pos.func_185332_f(tiny.func_177958_n(), tiny.func_177956_o(), tiny.func_177952_p()) < this.tinyRadius + this.tinyRadius + 25.0)) continue;
                continue block0;
            }
            this.tinyIslands.add(pos);
            int chunkBlockX = chunkX * 16;
            int chunkBlockZ = chunkZ * 16;
            for (double x = 0.0; x < 16.0; x += 1.0) {
                double realX = x + (double)chunkBlockX;
                double xDistance = Math.pow(Math.abs((double)featureCenterX - realX), 2.0);
                for (double z = 0.0; z < 16.0; z += 1.0) {
                    double realZ = z + (double)chunkBlockZ;
                    double zDistance = Math.pow(Math.abs((double)featureCenterZ - realZ), 2.0);
                    double maxNoiseDistance = (maxFeatureRadius - Math.sqrt(xDistance + zDistance)) * 1.5;
                    double noise2 = this.terrainNoise.eval(realX / 32.0, realZ / 32.0, 3, 0.5);
                    for (double y = 0.0; y < midHeight; y += 1.0) {
                        double skewNoise;
                        double skewedNoise;
                        double height;
                        if (Math.sqrt(xDistance + zDistance) <= maxFeatureRadius && (height = midHeight - (skewedNoise = this.terrainNoise.eval((realX + 16.0 * (skewNoise = this.largeNoiseArray[(int)((x * 16.0 + z) * 256.0 + y)] * 2.0 - 1.0)) / 8.0, (realZ + 16.0 * skewNoise) / 8.0, 3, 0.5)) * (maxNoiseDistance - 16.0 * noise2)) < y) {
                            primer.func_177855_a((int)x, (int)y, (int)z, Blocks.field_150348_b.func_176223_P());
                        }
                        if (!(Math.sqrt(xDistance + zDistance) <= maxFeatureRadius) || !((height = (skewedNoise = this.terrainNoise.eval((realX + 16.0 * (skewNoise = this.largeNoiseArray[(int)((x * 16.0 + z) * 256.0 + y)] * 2.0 - 1.0)) / 8.0, (realZ + 16.0 * skewNoise) / 8.0, 3, 0.5)) * ((maxNoiseDistance - 16.0 * noise2) / 2.0)) > y)) continue;
                        primer.func_177855_a((int)x, (int)((double)((int)y) + midHeight), (int)z, Blocks.field_150348_b.func_176223_P());
                    }
                }
            }
        }
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                this.genBiomeTerrainBlocks(biome, this.world, this.rand, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    public void genBiomeTerrainBlocks(Biome biome, World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        IBlockState iblockstate = biome.field_76752_A;
        IBlockState iblockstate1 = biome.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2 != Blocks.field_150348_b.func_176223_P()) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = AIR;
                    iblockstate1 = Blocks.field_150348_b.func_176223_P();
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = biome.field_76752_A;
                    iblockstate1 = biome.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = biome.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? ICE : WATER;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = AIR;
                    iblockstate1 = Blocks.field_150348_b.func_176223_P();
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? RED_SANDSTONE : SANDSTONE;
        }
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        boolean flag = false;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        biome.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        blockpos = blockpos.func_177982_a(8, 0, 8);
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return null;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

