/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config.chunkprovider;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.config.chunkprovider.ChunkGeneratorDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.data.BiomeData;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;

public class ChunkGeneratorDefinitionOverride
extends ChunkGeneratorDefinition {
    final Map<Biome, BiomeData> biomeOverrides = new HashMap<Biome, BiomeData>();

    public BiomeData getDataForBiome(Biome biome) {
        return this.biomeOverrides.get(biome);
    }

    public BiomeData getOrMakeDataForBiome(Biome biome) {
        if (!this.biomeOverrides.containsKey(biome)) {
            this.biomeOverrides.put(biome, new BiomeData());
        }
        return this.getDataForBiome(biome);
    }

    @ScriptMethodDocumentation(usage="", notes="")
    public void setBaseHeight(int biomeID, float height) {
        Biome biome = Biome.func_150568_d((int)biomeID);
        if (biome != null) {
            this.getOrMakeDataForBiome(biome).setBaseHeight(height);
        } else {
            DimensionalControl.instance.getLog().error((Object)(biome + " is not a biome ID."));
        }
    }

    @ScriptMethodDocumentation(usage="", notes="")
    public void setHeightVariation(int biomeID, float variation) {
        Biome biome = Biome.func_150568_d((int)biomeID);
        if (biome != null) {
            this.getOrMakeDataForBiome(biome).setHeightVariation(variation);
        } else {
            DimensionalControl.instance.getLog().error((Object)(biome + " is not a biome ID."));
        }
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.FLOAT, ArgType.FLOAT})
    @ScriptMethodDocumentation(usage="", notes="")
    public void setHeight(int biomeID, float height, float variation) {
        Biome biome = Biome.func_150568_d((int)biomeID);
        if (biome != null) {
            this.getOrMakeDataForBiome(biome).setBaseHeight(height);
            this.getOrMakeDataForBiome(biome).setHeightVariation(variation);
        } else {
            DimensionalControl.instance.getLog().error((Object)(biome + " is not a biome ID."));
        }
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.STRING})
    @ScriptMethodDocumentation(usage="", notes="")
    public void setTopBlock(int biomeID, String topBlock) throws Exception {
        Block block;
        Biome biome = Biome.func_150568_d((int)biomeID);
        if (biome != null) {
            block = Block.func_149684_b((String)topBlock);
            if (block == null) {
                throw new Exception("Cannot find block: " + topBlock);
            }
        } else {
            throw new Exception("Cannot find biome: " + biomeID);
        }
        this.getOrMakeDataForBiome(biome).setTopBlock(block.func_176223_P());
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.STRING})
    @ScriptMethodDocumentation(usage="", notes="")
    public void setFillerBlock(int biomeID, String fillerBlock) throws Exception {
        Block block;
        Biome biome = Biome.func_150568_d((int)biomeID);
        if (biome != null) {
            block = Block.func_149684_b((String)fillerBlock);
            if (block == null) {
                throw new Exception("Cannot find block: " + fillerBlock);
            }
        } else {
            throw new Exception("Cannot find biome: " + biomeID);
        }
        this.getOrMakeDataForBiome(biome).setFillerBlock(block.func_176223_P());
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.DOUBLE})
    @ScriptMethodDocumentation(usage="", notes="")
    public void setNoiseVariationScale(int biomeID, double scale) {
        Biome biome = Biome.func_150568_d((int)biomeID);
        if (biome != null) {
            this.getOrMakeDataForBiome(biome).setNoiseVariationScale(scale);
        } else {
            DimensionalControl.instance.getLog().error((Object)(biome + " is not a biome ID."));
        }
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="", notes="")
    public void blacklistSmoothing(int biomeID) {
        Biome biome = Biome.func_150568_d((int)biomeID);
        if (biome != null) {
            this.getOrMakeDataForBiome(biome).blacklistSmoothing();
        } else {
            DimensionalControl.instance.getLog().error((Object)(biome + " is not a biome ID."));
        }
    }
}

