/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.util.BiomeHelper;
import com.bloodnbonesgaming.dimensionalcontrol.util.BiomeProviderType;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.BiomeEdgeData;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.EnumOceanSize;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.HillData;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.BiomeManager;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/biomeproviders/CustomLight", classExplaination="The role of a BiomeProvider is to handle the generation of the dimensions biome map. This particular type uses a layer based system to generate a complex biome map in the same way as the vanilla Overworld.")
public class BiomeProviderDefinitionCustomLight
extends BiomeProviderDefinition {
    private boolean disableMushroomIslandLayer = false;
    private Integer biomeSize = null;
    private final List<BiomeManager.BiomeEntry> oceanBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private final List<BiomeManager.BiomeEntry> desertBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private final List<BiomeManager.BiomeEntry> warmBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private final List<BiomeManager.BiomeEntry> coolBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private final List<BiomeManager.BiomeEntry> icyBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private final List<BiomeEdgeData> biomeEdges = new ArrayList<BiomeEdgeData>();
    private final List<BiomeEdgeData> biomeShores = new ArrayList<BiomeEdgeData>();
    private boolean disableDeepOceanLayer = false;
    private HillData hillData;
    private List<int[]> comparableBiomes = new ArrayList<int[]>();
    private EnumOceanSize oceanSize = EnumOceanSize.DEFAULT;
    private Map<Integer, Integer> riverBiomes = new HashMap<Integer, Integer>();
    private Integer specialVariantChance;
    private Integer specialVariantOceanChance;
    private Integer specialVariantDesertChance;
    private Integer specialVariantWarmChance;
    private Integer specialVariantCoolChance;
    private Integer specialVariantIcyChance;
    private Integer specialOcean;
    private Integer specialDesert;
    private Integer specialWarm;
    private Integer specialCool;
    private Integer specialIcy;
    private Integer specialVariantOcean;
    private Integer specialVariantDesert;
    private Integer specialVariantWarm;
    private Integer specialVariantCool;
    private Integer specialVariantIcy;

    public BiomeProviderDefinitionCustomLight(BiomeProviderType type) {
        super(type);
    }

    public HillData getHillData() {
        return this.hillData;
    }

    @ScriptMethodDocumentation(usage="base biome ID, mutation biome ID", notes="Sets the mutation biome for the provided biomeID.")
    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.NON_NULL_BIOME_ID})
    public void setMutation(int biome, int mutation) {
        if (this.hillData == null) {
            this.hillData = new HillData();
        }
        this.hillData.setMutation(biome, mutation);
    }

    @ScriptMethodDocumentation(usage="base biome ID, hill biome IDs", notes="Sets the hill biomes for the provided biomeID.")
    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.NON_NULL_BIOME_ID_ARRAY})
    public void setHill(int biome, int[] hills) {
        if (this.hillData == null) {
            this.hillData = new HillData();
        }
        this.hillData.setHill(biome, hills);
    }

    @ScriptMethodDocumentation(usage="base biome ID, river biome ID", notes="Sets the river biome for the provided biomeID.")
    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.NON_NULL_BIOME_ID})
    public void setRiverBiome(int biome, int river) {
        this.riverBiomes.put(biome, river);
    }

    public Map<Integer, Integer> getRiverBiomes() {
        return this.riverBiomes;
    }

    @ScriptMethodDocumentation(args="String", usage="ocean size ID", notes="Sets the ocean size for the dimension. Options are \"Small\", \"Default\", \"Large\".", defaultValues="Default")
    public void setOceanSize(String oceanSize) {
        EnumOceanSize size = EnumOceanSize.valueOf(oceanSize.toUpperCase());
        if (size != null) {
            this.oceanSize = size;
        } else {
            DimensionalControl.instance.getLog().error((Object)("This is not an OceanSize!: " + oceanSize));
        }
    }

    public EnumOceanSize getOceanSize() {
        return this.oceanSize;
    }

    public boolean shouldDisableDeepOceanLayer() {
        return this.disableDeepOceanLayer;
    }

    @ScriptMethodDocumentation(notes="Disables the deep ocean layer.", args="None", usage="")
    public void disableDeepOceanLayer() {
        this.disableDeepOceanLayer = true;
    }

    public List<BiomeEdgeData> getBiomeEdges() {
        return this.biomeEdges;
    }

    @ScriptMethodDocumentation(usage="target biome IDs, edge biome ID", notes="Adds a biome edge for the provided biomes with no whitelist or blacklist.")
    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID_ARRAY, ArgType.NON_NULL_BIOME_ID})
    public void addBiomeEdge(int[] biomes, int edge) {
        this.addBiomeEdge(biomes, null, null, edge);
    }

    @ScriptMethodDocumentation(usage="target biome IDs, whitelist, blacklist, edge biome ID", notes="Adds a biome edge for the provided biomes with a whitelist and blacklist.")
    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID_ARRAY, ArgType.BIOME_ID_ARRAY, ArgType.BIOME_ID_ARRAY, ArgType.NON_NULL_BIOME_ID})
    public void addBiomeEdge(int[] biomes, int[] whitelist, int[] blacklist, int edge) {
        BiomeEdgeData edgeData = new BiomeEdgeData();
        edgeData.setBiomes(biomes);
        edgeData.setWhitelist(whitelist);
        edgeData.setBlacklist(blacklist);
        edgeData.setEdge(edge);
        this.biomeEdges.add(edgeData);
    }

    public List<BiomeEdgeData> getBiomeShores() {
        return this.biomeShores;
    }

    @ScriptMethodDocumentation(usage="target biome IDs, shore biome ID", notes="Adds a biome shore for the provided biomes with no whitelist or blacklist.")
    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID_ARRAY, ArgType.NON_NULL_BIOME_ID})
    public void addBiomeShore(int[] biomes, int edge) {
        this.addBiomeShore(biomes, null, null, edge);
    }

    @ScriptMethodDocumentation(usage="target biome IDs, whitelist, blacklist, shore biome ID", notes="Adds a biome shore for the provided biomes with a whitelist and blacklist.")
    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID_ARRAY, ArgType.BIOME_ID_ARRAY, ArgType.BIOME_ID_ARRAY, ArgType.NON_NULL_BIOME_ID})
    public void addBiomeShore(int[] biomes, int[] whitelist, int[] blacklist, int edge) {
        BiomeEdgeData edgeData = new BiomeEdgeData();
        edgeData.setBiomes(biomes);
        edgeData.setWhitelist(whitelist);
        edgeData.setBlacklist(blacklist);
        edgeData.setEdge(edge);
        this.biomeShores.add(edgeData);
    }

    @ScriptMethodDocumentation(notes="Disables the mushroom island layer.", args="None", usage="")
    public void disableMushroomIslandLayer() {
        this.disableMushroomIslandLayer = true;
    }

    public boolean shouldDisableMushroomIslandLayer() {
        return this.disableMushroomIslandLayer;
    }

    @ScriptMethodDocumentation(notes="Sets the biome size.", args="int", usage="biome size")
    public void setBiomeSize(int size) {
        this.biomeSize = size;
    }

    public Integer getBiomeSize() {
        return this.biomeSize;
    }

    @ScriptMethodDocumentation(usage="biome type, biome id", notes="Adds the provided biome id to the provided type with a weight of 1. Type options are \"Ocean\", \"Desert\", \"Warm\", \"Cool\", \"Icy\".")
    @ScriptArgs(args={ArgType.STRING, ArgType.NON_NULL_BIOME_ID})
    public void addBiome(String type, int id) {
        this.addBiome(type, id, 1);
    }

    @ScriptMethodDocumentation(usage="biome type, biome id, weight", notes="Adds the provided biome id to the provided type with the provided weight. Type options are \"Ocean\", \"Desert\", \"Warm\", \"Cool\", \"Icy\".")
    @ScriptArgs(args={ArgType.STRING, ArgType.NON_NULL_BIOME_ID, ArgType.INT})
    public void addBiome(String type, int id, int weight) {
        if (type.equalsIgnoreCase("Ocean")) {
            BiomeManager.BiomeEntry entry = BiomeHelper.generateBiomeEntry(id, weight);
            if (entry != null) {
                this.oceanBiomes.add(entry);
            }
        } else if (type.equalsIgnoreCase("Desert")) {
            BiomeManager.BiomeEntry entry = BiomeHelper.generateBiomeEntry(id, weight);
            if (entry != null) {
                this.desertBiomes.add(entry);
            }
        } else if (type.equalsIgnoreCase("Warm")) {
            BiomeManager.BiomeEntry entry = BiomeHelper.generateBiomeEntry(id, weight);
            if (entry != null) {
                this.warmBiomes.add(entry);
            }
        } else if (type.equalsIgnoreCase("Cool")) {
            BiomeManager.BiomeEntry entry = BiomeHelper.generateBiomeEntry(id, weight);
            if (entry != null) {
                this.coolBiomes.add(entry);
            }
        } else if (type.equalsIgnoreCase("Icy")) {
            BiomeManager.BiomeEntry entry = BiomeHelper.generateBiomeEntry(id, weight);
            if (entry != null) {
                this.icyBiomes.add(entry);
            }
        } else {
            DimensionalControl.instance.getLog().error((Object)(type + " is not a biome type!"));
        }
    }

    public List<BiomeManager.BiomeEntry> getOceanBiomes() {
        return this.oceanBiomes;
    }

    public List<BiomeManager.BiomeEntry> getDesertBiomes() {
        return this.desertBiomes;
    }

    public List<BiomeManager.BiomeEntry> getWarmBiomes() {
        return this.warmBiomes;
    }

    public List<BiomeManager.BiomeEntry> getCoolBiomes() {
        return this.coolBiomes;
    }

    public List<BiomeManager.BiomeEntry> getIcyBiomes() {
        return this.icyBiomes;
    }

    @ScriptMethodDocumentation(usage="chance", notes="Sets the global chance for the special variant biome to be used. The chance is 1 in the provided number.", args="int")
    public void setSpecialVariantChance(int chance) {
        this.specialVariantChance = chance;
    }

    @ScriptMethodDocumentation(usage="biome type, chance", notes="Sets the chance for the special variant biome to be used for the provided type. The chance is 1 in the provided number. Type options are \"Ocean\", \"Desert\", \"Warm\", \"Cool\", \"Icy\".", args="String, int")
    public void setSpecialVariantChance(String type, int chance) {
        if (type.equalsIgnoreCase("Ocean")) {
            this.specialVariantOceanChance = chance;
        } else if (type.equalsIgnoreCase("Desert")) {
            this.specialVariantDesertChance = chance;
        } else if (type.equalsIgnoreCase("Warm")) {
            this.specialVariantWarmChance = chance;
        } else if (type.equalsIgnoreCase("Cool")) {
            this.specialVariantCoolChance = chance;
        } else if (type.equalsIgnoreCase("Icy")) {
            this.specialVariantIcyChance = chance;
        } else {
            DimensionalControl.instance.getLog().error((Object)(type + " is not a biome type!"));
        }
    }

    @ScriptMethodDocumentation(usage="biome type, special biome ID", notes="Sets the special biome for the provided type. Type options are \"Ocean\", \"Desert\", \"Warm\", \"Cool\", \"Icy\".")
    @ScriptArgs(args={ArgType.STRING, ArgType.NON_NULL_BIOME_ID})
    public void setSpecialBiome(String type, int biome) {
        if (type.equalsIgnoreCase("Ocean")) {
            this.specialOcean = biome;
        } else if (type.equalsIgnoreCase("Desert")) {
            this.specialDesert = biome;
        } else if (type.equalsIgnoreCase("Warm")) {
            this.specialWarm = biome;
        } else if (type.equalsIgnoreCase("Cool")) {
            this.specialCool = biome;
        } else if (type.equalsIgnoreCase("Icy")) {
            this.specialIcy = biome;
        } else {
            DimensionalControl.instance.getLog().error((Object)(type + " is not a biome type!"));
        }
    }

    @ScriptMethodDocumentation(usage="biome type, special variant biome ID", notes="Sets the special variant biome for the provided type. Type options are \"Ocean\", \"Desert\", \"Warm\", \"Cool\", \"Icy\".")
    @ScriptArgs(args={ArgType.STRING, ArgType.NON_NULL_BIOME_ID})
    public void setSpecialVariantBiome(String type, int biome) {
        if (type.equalsIgnoreCase("Ocean")) {
            this.specialVariantOcean = biome;
        } else if (type.equalsIgnoreCase("Desert")) {
            this.specialVariantDesert = biome;
        } else if (type.equalsIgnoreCase("Warm")) {
            this.specialVariantWarm = biome;
        } else if (type.equalsIgnoreCase("Cool")) {
            this.specialVariantCool = biome;
        } else if (type.equalsIgnoreCase("Icy")) {
            this.specialVariantIcy = biome;
        } else {
            DimensionalControl.instance.getLog().error((Object)(type + " is not a biome type!"));
        }
    }

    public Integer getSpecialVariantChance() {
        return this.specialVariantChance;
    }

    public Integer getSpecialOcean() {
        return this.specialOcean;
    }

    public Integer getSpecialVariantOcean() {
        return this.specialVariantOcean;
    }

    public Integer getSpecialVariantOceanChance() {
        return this.specialVariantOceanChance;
    }

    public Integer getSpecialDesert() {
        return this.specialDesert;
    }

    public Integer getSpecialVariantDesert() {
        return this.specialVariantDesert;
    }

    public Integer getSpecialVariantDesertChance() {
        return this.specialVariantDesertChance;
    }

    public Integer getSpecialWarm() {
        return this.specialWarm;
    }

    public Integer getSpecialVariantWarm() {
        return this.specialVariantWarm;
    }

    public Integer getSpecialVariantWarmChance() {
        return this.specialVariantWarmChance;
    }

    public Integer getSpecialCool() {
        return this.specialCool;
    }

    public Integer getSpecialVariantCool() {
        return this.specialVariantCool;
    }

    public Integer getSpecialVariantCoolChance() {
        return this.specialVariantCoolChance;
    }

    public Integer getSpecialIcy() {
        return this.specialIcy;
    }

    public Integer getSpecialVariantIcy() {
        return this.specialVariantIcy;
    }

    public Integer getSpecialVariantIcyChance() {
        return this.specialVariantIcyChance;
    }
}

