/*
 * Decompiled with CFR 0.152.
 */
package terrails.statskeeper;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import terrails.statskeeper.config.SKConfig;
import terrails.statskeeper.data.health.CapabilityHealth;
import terrails.statskeeper.event.BasicEventHandler;
import terrails.statskeeper.event.HealthEventHandler;
import terrails.statskeeper.event.HungerEventHandler;
import terrails.statskeeper.event.TANEvent;
import terrails.statskeeper.packet.StatsMessageTAN;
import terrails.statskeeper.potion.ModPotions;
import terrails.terracore.base.MainModClass;
import terrails.terracore.base.proxies.ProxyBase;
import terrails.terracore.base.registry.RegistryList;
import terrails.terracore.base.registry.RegistryType;

@Mod(modid="stats_keeper", name="Stats Keeper", version="3.1.12", guiFactory="terrails.statskeeper.config.ConfigFactoryGUI", dependencies="required-after:terracore@[1.12-2.1.10-SNAPSHOT.+,);", acceptedMinecraftVersions="[1.12.2]")
public class StatsKeeper
extends MainModClass<StatsKeeper> {
    public static final String MOD_ID = "stats_keeper";
    public static final String MOD_NAME = "Stats Keeper";
    public static final String VERSION = "3.1.12";
    public static final String GUI_FACTORY = "terrails.statskeeper.config.ConfigFactoryGUI";
    public static final Logger LOGGER = LogManager.getLogger((String)"Stats Keeper");
    public static ProxyBase proxy;
    public static SimpleNetworkWrapper networkWrapper;

    public StatsKeeper() {
        super(MOD_ID, MOD_NAME, VERSION);
        proxy = this.getProxy();
    }

    public void registerForgeEntries(RegistryList list) {
        if (list.getType() == RegistryType.POTION) {
            ModPotions.init();
            list.addAll(ModPotions.potions);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        SKConfig.initialize(event.getModConfigurationDirectory());
        StatsKeeper.initializeCapabilities();
        StatsKeeper.initializeEvents();
        if (Loader.isModLoaded((String)"toughasnails")) {
            networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel(MOD_ID);
            networkWrapper.registerMessage(StatsMessageTAN.MessageHandler.class, StatsMessageTAN.class, 0, Side.CLIENT);
        }
    }

    private static void initializeCapabilities() {
        CapabilityHealth.register();
    }

    private static void initializeEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new BasicEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HungerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HealthEventHandler());
        if (Loader.isModLoaded((String)"toughasnails")) {
            MinecraftForge.EVENT_BUS.register((Object)new TANEvent());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        SKConfig.syncPostConfig();
    }

    public StatsKeeper getInstance() {
        return this;
    }
}

