/*
 * Decompiled with CFR 0.152.
 */
package de.morrien.f5fix;

import de.morrien.f5fix.F5FixLoadingPlugin;
import java.util.Iterator;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@IFMLLoadingPlugin.MCVersion(value="1.12.2")
public class F5FixTransformer
implements IClassTransformer {
    private static String entityRendererClassName = F5FixLoadingPlugin.isDeobfuscatedEnvironment() ? "net.minecraft.client.renderer.EntityRenderer" : "buo";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals(entityRendererClassName)) {
            ClassNode cn = new ClassNode();
            ClassReader cr = new ClassReader(basicClass);
            cr.accept((ClassVisitor)cn, 0);
            Iterator methods = cn.methods.iterator();
            String orientCameraMethodName = F5FixLoadingPlugin.isDeobfuscatedEnvironment() ? "orientCamera" : "func_78467_g";
            String worldClientClassName = "net/minecraft/client/multiplayer/WorldClient";
            String rayTraceBlocksMethodName = F5FixLoadingPlugin.isDeobfuscatedEnvironment() ? "rayTraceBlocks" : "func_72933_a";
            String rayTraceBlocksMethodNameBBB = F5FixLoadingPlugin.isDeobfuscatedEnvironment() ? "rayTraceBlocks" : "func_147447_a";
            String vec3dClassName = "net/minecraft/util/math/Vec3d";
            String rayTraceResultClassName = "net/minecraft/util/math/RayTraceResult";
            String rayTraceBlocksMethodDescOld = "(L" + vec3dClassName + ";L" + vec3dClassName + ";)L" + rayTraceResultClassName + ";";
            String rayTraceBlocksMethodDescNew = "(L" + vec3dClassName + ";L" + vec3dClassName + ";ZZZ)L" + rayTraceResultClassName + ";";
            while (methods.hasNext()) {
                MethodNode node = (MethodNode)methods.next();
                if (!node.name.equals(orientCameraMethodName)) continue;
                for (int i = 0; i < node.instructions.size(); ++i) {
                    AbstractInsnNode abstractInsnNode = node.instructions.get(i);
                    if (abstractInsnNode.getOpcode() != 182 || !(abstractInsnNode instanceof MethodInsnNode)) continue;
                    MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                    if (!methodInsnNode.owner.equals(worldClientClassName) || !methodInsnNode.name.equals(rayTraceBlocksMethodName) || !methodInsnNode.desc.equals(rayTraceBlocksMethodDescOld)) continue;
                    InsnList instructionList = new InsnList();
                    instructionList.add((AbstractInsnNode)new InsnNode(3));
                    instructionList.add((AbstractInsnNode)new InsnNode(4));
                    instructionList.add((AbstractInsnNode)new InsnNode(4));
                    methodInsnNode.desc = rayTraceBlocksMethodDescNew;
                    methodInsnNode.name = rayTraceBlocksMethodNameBBB;
                    node.instructions.insertBefore((AbstractInsnNode)methodInsnNode, instructionList);
                }
            }
            ClassWriter writer = new ClassWriter(3);
            cn.accept((ClassVisitor)writer);
            basicClass = writer.toByteArray();
        }
        return basicClass;
    }
}

