/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.init;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModTileEntity;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.init.IModObjectBase;
import crazypants.enderio.base.init.ModObjectRegistry;
import crazypants.enderio.base.init.RegisterModObject;
import crazypants.enderio.powertools.init.PowerToolTileEntity;
import crazypants.enderio.powertools.machine.capbank.BlockCapBank;
import crazypants.enderio.powertools.machine.gauge.BlockGauge;
import crazypants.enderio.powertools.machine.monitor.BlockPowerMonitor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderiopowertools")
public enum PowerToolObject implements IModObjectBase
{
    block_cap_bank(BlockCapBank.class, (IModTileEntity)PowerToolTileEntity.TileCapBank),
    block_gauge(BlockGauge.class, (IModTileEntity)PowerToolTileEntity.TileGauge),
    block_power_monitor(BlockPowerMonitor.class, "createPowerMonitor", (IModTileEntity)PowerToolTileEntity.TilePowerMonitor),
    block_advanced_power_monitor(BlockPowerMonitor.class, "createAdvancedPowerMonitor", (IModTileEntity)PowerToolTileEntity.TilePowerMonitor);

    @Nonnull
    final String unlocalisedName = ModObjectRegistry.sanitizeName((String)((String)NullHelper.notnullJ((Object)this.name(), (String)"Enum.name()")));
    @Nullable
    protected Block block;
    @Nullable
    protected Item item;
    @Nonnull
    protected final Class<?> clazz;
    @Nullable
    protected final String blockMethodName;
    @Nullable
    protected final String itemMethodName;
    @Nullable
    protected final IModTileEntity modTileEntity;

    @SubscribeEvent
    public static void registerBlocksEarly(@Nonnull RegisterModObject event) {
        event.register(PowerToolObject.class);
    }

    private PowerToolObject(Class<?> clazz) {
        this(clazz, "create", (IModTileEntity)null);
    }

    private PowerToolObject(Class<?> clazz, IModTileEntity modTileEntity) {
        this(clazz, "create", modTileEntity);
    }

    private PowerToolObject(Class<?> clazz, String methodName) {
        this(clazz, methodName, (IModTileEntity)null);
    }

    private PowerToolObject(@Nonnull Class<?> clazz, String blockMethodName, String itemMethodName) {
        this(clazz, blockMethodName, itemMethodName, null);
    }

    private PowerToolObject(@Nullable Class<?> clazz, String methodName, IModTileEntity modTileEntity) {
        this.clazz = clazz;
        if (Block.class.isAssignableFrom(clazz)) {
            this.blockMethodName = methodName;
            this.itemMethodName = null;
        } else if (Item.class.isAssignableFrom(clazz)) {
            this.blockMethodName = null;
            this.itemMethodName = methodName;
        } else {
            throw new RuntimeException("Clazz " + clazz + " unexpectedly is neither a Block nor an Item.");
        }
        this.modTileEntity = modTileEntity;
    }

    private PowerToolObject(@Nullable Class<?> clazz, @Nullable String blockMethodName, String itemMethodName, IModTileEntity modTileEntity) {
        this.clazz = clazz;
        this.blockMethodName = blockMethodName == null || blockMethodName.isEmpty() ? null : blockMethodName;
        this.itemMethodName = itemMethodName == null || itemMethodName.isEmpty() ? null : itemMethodName;
        this.modTileEntity = modTileEntity;
    }

    @Nonnull
    public Class<?> getClazz() {
        return this.clazz;
    }

    public void setItem(@Nullable Item obj) {
        this.item = obj;
    }

    public void setBlock(@Nullable Block obj) {
        this.block = obj;
    }

    @Nonnull
    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    @Nonnull
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("enderio", this.getUnlocalisedName());
    }

    @Nullable
    public Block getBlock() {
        return this.block;
    }

    @Nullable
    public Item getItem() {
        return this.item;
    }

    @Nullable
    public IModTileEntity getTileEntity() {
        return this.modTileEntity;
    }

    @Nonnull
    public final <B extends Block> B apply(@Nonnull B blockIn) {
        blockIn.func_149647_a(EnderIOTab.tabEnderIOConduits);
        return (B)super.apply(blockIn);
    }

    @Nullable
    public String getBlockMethodName() {
        return this.blockMethodName;
    }

    @Nullable
    public String getItemMethodName() {
        return this.itemMethodName;
    }
}

