/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.handler;

import com.setycz.chickens.entity.EntityChickensChicken;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChickenNetherPopulateHandler {
    private final float chanceMultiplier;

    public ChickenNetherPopulateHandler(float chanceMultiplier) {
        this.chanceMultiplier = chanceMultiplier;
    }

    @SubscribeEvent
    public void populateChunk(PopulateChunkEvent.Populate event) {
        BlockPos chunkCentrePos = new BlockPos(event.getChunkX() * 16 + 8, 0, event.getChunkZ() * 16 + 8);
        Biome biome = event.getWorld().getBiomeForCoordsBody(chunkCentrePos);
        if (biome != Biomes.field_76778_j) {
            return;
        }
        if (event.getWorld().field_73012_v.nextFloat() < biome.func_76741_f() * this.chanceMultiplier) {
            BlockPos basePosition = ChickenNetherPopulateHandler.getRandomChunkPosition(event.getWorld(), event.getChunkX(), event.getChunkZ());
            BlockPos spawnPos = this.findFloor(event.getWorld(), basePosition);
            IEntityLivingData livingData = this.spawn(event.getWorld(), null, spawnPos);
            livingData = this.spawn(event.getWorld(), livingData, spawnPos.func_177978_c());
            livingData = this.spawn(event.getWorld(), livingData, spawnPos.func_177968_d());
            livingData = this.spawn(event.getWorld(), livingData, spawnPos.func_177976_e());
            this.spawn(event.getWorld(), livingData, spawnPos.func_177974_f());
        }
    }

    private BlockPos findFloor(World world, BlockPos basePosition) {
        BlockPos spawnPos = basePosition;
        while (spawnPos.func_177956_o() < 100 && !WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntitySpawnPlacementRegistry.func_180109_a(EntityChickensChicken.class), (World)world, (BlockPos)spawnPos)) {
            spawnPos = spawnPos.func_177984_a();
        }
        return spawnPos;
    }

    @Nullable
    private IEntityLivingData spawn(World world, @Nullable IEntityLivingData livingData, BlockPos spawnPos) {
        if (WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntitySpawnPlacementRegistry.func_180109_a(EntityChickensChicken.class), (World)world, (BlockPos)spawnPos)) {
            EntityChickensChicken entity = new EntityChickensChicken(world);
            entity.func_70012_b((double)spawnPos.func_177958_n() + 0.5, spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            livingData = entity.func_180482_a(world.func_175649_E(new BlockPos((Entity)entity)), livingData);
            if (entity.func_70058_J()) {
                world.func_72838_d((Entity)entity);
            }
        }
        return livingData;
    }

    private static BlockPos getRandomChunkPosition(World worldIn, int x, int z) {
        Chunk chunk = worldIn.func_72964_e(x, z);
        int i = x * 16 + worldIn.field_73012_v.nextInt(16);
        int j = z * 16 + worldIn.field_73012_v.nextInt(16);
        int k = MathHelper.func_154354_b((int)(chunk.func_177433_f(new BlockPos(i, 0, j)) + 1), (int)16);
        int l = worldIn.field_73012_v.nextInt(k > 0 ? k : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(i, l, j);
    }
}

