/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.squeezer;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.block.BlockSqueezer;
import org.cyclops.integrateddynamics.block.BlockSqueezerConfig;
import org.cyclops.integrateddynamicscompat.IntegratedDynamicsCompat;
import org.cyclops.integrateddynamicscompat.modcompat.jei.squeezer.SqueezerRecipeJEI;

public class SqueezerRecipeCategory
implements IRecipeCategory {
    public static final String NAME = "integrateddynamicscompat:squeezer";
    private static final int INPUT_SLOT = 0;
    private static final int FLUIDOUTPUT_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private final IDrawable background;
    private final IDrawableStatic arrowDrawable;

    public SqueezerRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("integrateddynamicscompat:" + (String)IntegratedDynamicsCompat._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + BlockSqueezerConfig._instance.getNamedId() + "_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 116, 53);
        this.arrowDrawable = guiHelper.createDrawable(resourceLocation, 41, 32, 12, 2);
    }

    @Nonnull
    public String getUid() {
        return NAME;
    }

    @Nonnull
    public String getTitle() {
        return L10NHelpers.localize((String)(BlockSqueezer.getInstance().func_149739_a() + ".name"), (Object[])new Object[0]);
    }

    public String getModName() {
        return "Integrated Dynamics";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void drawExtras(Minecraft minecraft) {
        int height = (int)(minecraft.field_71441_e.func_82737_E() / 4L % 7L);
        this.arrowDrawable.draw(minecraft, 41, 18 + height * 2);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (recipeWrapper instanceof SqueezerRecipeJEI) {
            int i;
            SqueezerRecipeJEI recipe = (SqueezerRecipeJEI)recipeWrapper;
            recipeLayout.getItemStacks().init(0, true, 1, 17);
            int offset = 0;
            for (i = 0; i < recipe.getOutputItems().size(); ++i) {
                recipeLayout.getItemStacks().init(2 + i, false, 75 + (i % 2 > 0 ? 22 : 0), 7 + offset + (i > 1 ? 22 : 0));
            }
            recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex > 2 && slotIndex < 2 + recipe.getOutputItems().size()) {
                    float chance = recipe.getOutputChances().get(slotIndex - 2).floatValue();
                    tooltip.add(TextFormatting.GRAY + "Chance: " + chance * 100.0f + "%");
                }
            });
            if (!recipe.getInputItem().isEmpty()) {
                recipeLayout.getItemStacks().set(0, recipe.getInputItem());
            }
            i = 0;
            for (List<ItemStack> outputItem : recipe.getOutputItems()) {
                recipeLayout.getItemStacks().set(2 + i++, outputItem);
            }
            recipeLayout.getFluidStacks().init(1, false, 98, 30, 16, 16, 1000, false, null);
            if (recipe.getOutputFluid() != null) {
                recipeLayout.getFluidStacks().set(1, recipe.getOutputFluid());
            }
        }
    }
}

