/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryBase;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.helper.EnergyHelpers;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectable;
import org.cyclops.integrateddynamics.network.EnergyBatteryNetworkElement;

public class TileEnergyBattery
extends TileCableConnectable
implements IEnergyStorageCapacity {
    @NBTPersist
    private int energy;
    @NBTPersist(useDefaultValue=false)
    private int capacity = BlockEnergyBatteryConfig.capacity;

    public TileEnergyBattery() {
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
                return new EnergyBatteryNetworkElement(DimPos.of((World)world, (BlockPos)blockPos));
            }
        });
        this.addCapabilityInternal(CapabilityEnergy.ENERGY, this);
    }

    public boolean isCreative() {
        Block block = this.func_145838_q();
        return block instanceof BlockEnergyBatteryBase && ((BlockEnergyBatteryBase)block).isCreative();
    }

    public int getEnergyStored() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        return this.energy;
    }

    public int getMaxEnergyStored() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        return this.capacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    protected void setEnergy(int energy) {
        int lastEnergy;
        if (!this.isCreative() && (lastEnergy = this.energy) != energy) {
            this.energy = energy;
            this.func_70296_d();
            this.sendUpdate();
        }
    }

    protected int getUpdateBackoffTicks() {
        return 20;
    }

    public void onUpdateReceived() {
        super.onUpdateReceived();
    }

    public static int getEnergyPerTick(int capacity) {
        return Math.max(capacity / BlockEnergyBatteryConfig.energyRateCapacityFraction, BlockEnergyBatteryConfig.minEnergyRate);
    }

    protected int getEnergyPerTick() {
        return TileEnergyBattery.getEnergyPerTick(this.getMaxEnergyStored());
    }

    public int receiveEnergy(int energy, boolean simulate) {
        if (!this.isCreative()) {
            int stored = this.getEnergyStored();
            int energyReceived = Math.min(this.getMaxEnergyStored() - stored, energy);
            if (!simulate) {
                this.setEnergy(stored + energyReceived);
            }
            return energyReceived;
        }
        return 0;
    }

    public int extractEnergy(int energy, boolean simulate) {
        if (this.isCreative()) {
            return energy;
        }
        energy = Math.max(0, Math.min(energy, this.getEnergyPerTick()));
        int stored = this.getEnergyStored();
        int newEnergy = Math.max(stored - energy, 0);
        if (!simulate) {
            this.setEnergy(newEnergy);
        }
        return stored - newEnergy;
    }

    protected int addEnergy(int energy) {
        int filled = this.addEnergyFe(energy, false);
        this.extractEnergy(filled, false);
        return filled;
    }

    protected int addEnergyFe(int energy, boolean simulate) {
        return EnergyHelpers.fillNeigbours(this.func_145831_w(), this.func_174877_v(), energy, simulate);
    }

    @Override
    protected void updateTileEntity() {
        super.updateTileEntity();
        if (!this.func_145831_w().field_72995_K && this.getEnergyStored() > 0 && this.func_145831_w().func_175640_z(this.func_174877_v())) {
            this.addEnergy(Math.min(this.getEnergyPerTick(), this.getEnergyStored()));
        }
    }

    @Override
    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }
}

