/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.GuiArrowedListField;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;
import org.cyclops.integrateddynamics.client.gui.GuiLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;
import org.cyclops.integrateddynamics.core.logicprogrammer.IRenderPatternValueTypeTooltip;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerSetElementInventory;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeIngredientsValueChangedPacket;

public class ValueTypeIngredientsLPElement
extends ValueTypeLPElementBase {
    private IngredientComponent currentType = IngredientComponent.ITEMSTACK;
    private Map<IngredientComponent, Integer> lengths = Maps.newHashMap();
    private Map<IngredientComponent, Map<Integer, IValueTypeLogicProgrammerElement>> subElements = Maps.newHashMap();
    private Map<IngredientComponent, Map<Integer, RenderPattern>> subElementGuis = Maps.newHashMap();
    private int activeElement = -1;
    @SideOnly(value=Side.CLIENT)
    private MasterSubGuiRenderPattern masterGui;
    private ValueObjectTypeIngredients.ValueIngredients serverValue = null;

    public ValueTypeIngredientsLPElement() {
        super(ValueTypes.OBJECT_INGREDIENTS);
    }

    public void setServerValue(ValueObjectTypeIngredients.ValueIngredients serverValue) {
        this.serverValue = serverValue;
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE_CANVAS;
    }

    @Override
    public boolean canWriteElementPre() {
        return true;
    }

    protected IMixedIngredients constructValues() {
        IdentityHashMap lists = Maps.newIdentityHashMap();
        for (IngredientComponent<?, ?> component : IngredientComponentHandlers.REGISTRY.getComponents()) {
            ArrayList values = Lists.newArrayListWithExpectedSize((int)this.lengths.get(component));
            this.subElements.get(component).entrySet().forEach(entry -> {
                IIngredientComponentHandler componentHandler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
                try {
                    values.add(componentHandler.toInstance(((IValueTypeLogicProgrammerElement)entry.getValue()).getValue()));
                }
                catch (Exception e) {
                    values.add(component.getMatcher().getEmptyInstance());
                }
            });
            if (values.isEmpty()) continue;
            lists.put(component, values);
        }
        return new MixedIngredients((Map)lists);
    }

    @Override
    public IValue getValue() {
        return MinecraftHelpers.isClientSide() ? ValueObjectTypeIngredients.ValueIngredients.of(this.constructValues()) : this.serverValue;
    }

    public int getLength() {
        return this.lengths.get(this.currentType);
    }

    public void setLength(int length) {
        this.lengths.put(this.currentType, length);
        this.setActiveElement(this.getLength() - 1);
    }

    public void setCurrentType(IngredientComponent currentType) {
        this.currentType = currentType;
        this.setActiveElement(this.subElements.get(currentType).size() - 1);
    }

    public void setActiveElement(int index) {
        this.activeElement = index;
        if (index >= 0 && !this.subElements.get(this.currentType).containsKey(index)) {
            this.subElements.get(this.currentType).put(index, IngredientComponentHandlers.REGISTRY.getComponentHandler(this.currentType).getValueType().createLogicProgrammerElement());
        }
        this.masterGui.setActiveElement(this.activeElement);
        this.masterGui.container.onDirty();
    }

    public void removeElement(int index) {
        Map<Integer, IValueTypeLogicProgrammerElement> oldSubElements = this.subElements.get(this.currentType);
        Map<Integer, RenderPattern> oldSubElementGuis = this.subElementGuis.get(this.currentType);
        this.subElements.put(this.currentType, Maps.newHashMap());
        this.subElementGuis.put(this.currentType, Maps.newHashMap());
        for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> entry : oldSubElements.entrySet()) {
            int i = entry.getKey();
            if (i < index) {
                this.subElements.get(this.currentType).put(i, entry.getValue());
                this.subElementGuis.get(this.currentType).put(i, oldSubElementGuis.get(i));
                continue;
            }
            if (i <= index) continue;
            this.subElements.get(this.currentType).put(i - 1, entry.getValue());
            this.subElementGuis.get(this.currentType).put(i - 1, oldSubElementGuis.get(i));
        }
        this.setLength(this.getLength() - 1);
    }

    @Override
    public void activate() {
        for (IngredientComponent<?, ?> recipeComponent : IngredientComponentHandlers.REGISTRY.getComponents()) {
            this.subElements.put(recipeComponent, Maps.newHashMap());
            this.subElementGuis.put(recipeComponent, Maps.newHashMap());
            this.lengths.put(recipeComponent, 0);
        }
    }

    @Override
    public void deactivate() {
    }

    @Override
    public L10NHelpers.UnlocalizedString validate() {
        if (!MinecraftHelpers.isClientSide()) {
            return this.serverValue == null ? new L10NHelpers.UnlocalizedString() : null;
        }
        if (MinecraftHelpers.isClientSide()) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeIngredientsValueChangedPacket(ValueObjectTypeIngredients.ValueIngredients.of(this.constructValues())));
        }
        for (Map<Integer, IValueTypeLogicProgrammerElement> componentValues : this.subElements.values()) {
            for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> entry : componentValues.entrySet()) {
                L10NHelpers.UnlocalizedString error = entry.getValue().validate();
                if (error == null) continue;
                return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_list_element", new Object[]{entry.getKey(), error});
            }
        }
        return null;
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return slotId == 0 && super.isItemValidForSlot(slotId, itemStack) || this.activeElement >= 0 && this.subElements.get(this.currentType).containsKey(this.activeElement) && this.subElements.get(this.currentType).get(this.activeElement).isItemValidForSlot(slotId, itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISubGuiBox createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        this.masterGui = new MasterSubGuiRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
        return this.masterGui;
    }

    @SideOnly(value=Side.CLIENT)
    protected static class ListElementSubGui
    extends RenderPattern<ValueTypeIngredientsLPElement, GuiLogicProgrammerBase, ContainerLogicProgrammerBase> {
        private GuiButtonArrow arrowLeft;
        private GuiButtonArrow arrowRight;
        private GuiButton arrowRemove;

        public ListElementSubGui(ValueTypeIngredientsLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            RenderPattern subGui = (RenderPattern)((Map)element.subElementGuis.get(element.currentType)).get(element.activeElement);
            IValueTypeLogicProgrammerElement subElement = (IValueTypeLogicProgrammerElement)((Map)element.subElements.get(element.currentType)).get(element.activeElement);
            if (subGui == null) {
                subGui = (RenderPattern)subElement.createSubGui(baseX, baseY, maxWidth, maxHeight / 3 * 2, gui, container);
                ((Map)element.subElementGuis.get(element.currentType)).put(element.activeElement, subGui);
            }
            int x = this.getX() + baseX - 24;
            int y = this.getY() + baseY - 23;
            gui.getContainer().setElementInventory(subElement, x, y);
            subElement.setValueInGui(subGui);
            this.subGuiHolder.addSubGui(subGui);
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerSetElementInventory((IValueType)IngredientComponentHandlers.REGISTRY.getComponentHandler(element.currentType).getValueType(), x, y));
        }

        @Override
        public int getHeight() {
            return super.getHeight() / 4 * 3;
        }

        @Override
        public void initGui(int guiLeft, int guiTop) {
            super.initGui(guiLeft, guiTop);
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowLeft = new GuiButtonArrow(1, x, y, GuiButtonArrow.Direction.WEST);
            this.buttonList.add(this.arrowLeft);
            this.arrowRight = new GuiButtonArrow(1, x + this.getWidth() - this.arrowLeft.field_146120_f - 1, y, GuiButtonArrow.Direction.EAST);
            this.buttonList.add(this.arrowRight);
            this.arrowRemove = new GuiButtonText(2, x + this.getWidth() / 2 - this.arrowLeft.field_146120_f / 2, y + this.getHeight() - 13, 12, 12, "-", true);
            this.buttonList.add(this.arrowRemove);
            this.arrowLeft.field_146124_l = ((ValueTypeIngredientsLPElement)this.element).activeElement > 0;
            this.arrowRight.field_146124_l = ((ValueTypeIngredientsLPElement)this.element).activeElement < ((ValueTypeIngredientsLPElement)this.element).getLength() - 1;
            this.arrowRemove.field_146124_l = ((ValueTypeIngredientsLPElement)this.element).getLength() > 0;
        }

        @Override
        protected void actionPerformed(GuiButton guibutton) {
            super.actionPerformed(guibutton);
            if (guibutton == this.arrowLeft) {
                ((ValueTypeIngredientsLPElement)this.element).setActiveElement(((ValueTypeIngredientsLPElement)this.element).activeElement - 1);
            } else if (guibutton == this.arrowRight) {
                ((ValueTypeIngredientsLPElement)this.element).setActiveElement(((ValueTypeIngredientsLPElement)this.element).activeElement + 1);
            } else if (guibutton == this.arrowRemove) {
                ((ValueTypeIngredientsLPElement)this.element).removeElement(((ValueTypeIngredientsLPElement)this.element).activeElement);
            }
        }

        @Override
        public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            int x = guiLeft + this.getX() + this.getWidth() / 2;
            int y = guiTop + this.getY() + 4;
            RenderHelpers.drawScaledCenteredString((FontRenderer)fontRenderer, (String)String.valueOf(((ValueTypeIngredientsLPElement)this.element).activeElement), (int)(x - 4), (int)(y + 2), (int)10, (int)Helpers.RGBToInt((int)20, (int)20, (int)20));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static class SelectionSubGui
    extends RenderPattern<ValueTypeIngredientsLPElement, GuiLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IInputListener {
        private GuiArrowedListField<IngredientComponent> valueTypeSelector = null;
        private GuiButton arrowAdd;

        public SelectionSubGui(ValueTypeIngredientsLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        }

        @Override
        public int getHeight() {
            return super.getHeight() / 4;
        }

        protected static List<IngredientComponent> getValueTypes() {
            return Lists.newArrayList(IngredientComponentHandlers.REGISTRY.getComponents());
        }

        @Override
        public void initGui(int guiLeft, int guiTop) {
            super.initGui(guiLeft, guiTop);
            this.valueTypeSelector = new GuiArrowedListField<IngredientComponent>(0, Minecraft.func_71410_x().field_71466_p, this.getX() + guiLeft + this.getWidth() / 2 - 50, this.getY() + guiTop + 2, 100, 15, true, true, SelectionSubGui.getValueTypes()){

                protected String activeElementToString(IngredientComponent element) {
                    return L10NHelpers.localize((String)element.getUnlocalizedName(), (Object[])new Object[0]);
                }
            };
            this.valueTypeSelector.setListener((IInputListener)this);
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowAdd = new GuiButtonText(1, x + this.getWidth() - 13, y + this.getHeight() - 13, 12, 12, "+", true);
            this.buttonList.add(this.arrowAdd);
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.mouseClicked(mouseX, mouseY, mouseButton);
            this.valueTypeSelector.func_146192_a(mouseX, mouseY, mouseButton);
        }

        @Override
        protected void actionPerformed(GuiButton guibutton) {
            super.actionPerformed(guibutton);
            if (guibutton == this.arrowAdd) {
                ((ValueTypeIngredientsLPElement)this.element).setLength(((ValueTypeIngredientsLPElement)this.element).getLength() + 1);
            }
        }

        @Override
        public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            this.valueTypeSelector.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
        }

        public void onChanged() {
            ((ValueTypeIngredientsLPElement)this.element).setCurrentType((IngredientComponent)this.valueTypeSelector.getActiveElement());
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static class MasterSubGuiRenderPattern
    extends RenderPattern<ValueTypeIngredientsLPElement, GuiLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IRenderPatternValueTypeTooltip {
        private final int baseX;
        private final int baseY;
        private final int maxWidth;
        private final int maxHeight;
        private final GuiLogicProgrammerBase gui;
        private final ContainerLogicProgrammerBase container;
        protected ListElementSubGui elementSubGui = null;
        protected int lastGuiLeft;
        protected int lastGuiTop;
        private boolean renderTooltip = true;

        public MasterSubGuiRenderPattern(ValueTypeIngredientsLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            this.subGuiHolder.addSubGui(new SelectionSubGui(element, baseX, baseY, maxWidth, maxHeight, gui, container));
            this.baseX = baseX;
            this.baseY = baseY;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.gui = gui;
            this.container = container;
        }

        public void setActiveElement(int index) {
            if (this.elementSubGui != null) {
                this.subGuiHolder.removeSubGui(this.elementSubGui);
            }
            if (index >= 0) {
                this.elementSubGui = new ListElementSubGui((ValueTypeIngredientsLPElement)this.element, this.baseX, this.baseY + this.getHeight() / 4, this.maxWidth, this.maxHeight, this.gui, this.container);
                this.subGuiHolder.addSubGui(this.elementSubGui);
                this.elementSubGui.initGui(this.lastGuiLeft, this.lastGuiTop);
            }
        }

        @Override
        public void initGui(int guiLeft, int guiTop) {
            super.initGui(guiLeft, guiTop);
            this.lastGuiLeft = guiLeft;
            this.lastGuiTop = guiTop;
        }

        @Override
        public void drawGuiContainerForegroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, int mouseX, int mouseY) {
            super.drawGuiContainerForegroundLayer(guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            this.drawTooltipForeground(this.gui, this.container, guiLeft, guiTop, mouseX, mouseY, ((ValueTypeIngredientsLPElement)this.element).getValueType());
        }

        @Override
        public boolean isRenderTooltip() {
            return this.renderTooltip;
        }

        @Override
        public void setRenderTooltip(boolean renderTooltip) {
            this.renderTooltip = renderTooltip;
        }
    }
}

