/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.advancement.criterion.JsonDeserializers;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.advancement.criterion.VariableFacadePredicate;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeCategory;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeRegistry;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;

public final class ValueTypeRegistry
implements IValueTypeRegistry {
    private static ValueTypeRegistry INSTANCE = new ValueTypeRegistry();
    private static final IValueTypeVariableFacade INVALID_FACADE = new ValueTypeVariableFacade<IValue>(false, null, (IValue)null);
    private final Map<String, IValueType> valueTypes = Maps.newHashMap();
    @SideOnly(value=Side.CLIENT)
    private Map<IValueType, ResourceLocation> valueTypeModels;

    private ValueTypeRegistry() {
        if (MinecraftHelpers.isClientSide()) {
            this.valueTypeModels = new IdentityHashMap<IValueType, ResourceLocation>();
        }
        if (MinecraftHelpers.isModdedEnvironment()) {
            ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).registerHandler(this);
        }
    }

    public static ValueTypeRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public <V extends IValue, T extends IValueType<V>> T register(T valueType) {
        this.valueTypes.put(valueType.getUnlocalizedName(), valueType);
        return valueType;
    }

    @Override
    public <V extends IValue, T extends IValueTypeCategory<V>> T registerCategory(T category) {
        return this.register(category);
    }

    @Override
    public IValueType getValueType(String name) {
        return this.valueTypes.get(name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public <V extends IValue, T extends IValueType<V>> void registerValueTypeModel(T valueType, ResourceLocation modelLocation) {
        this.valueTypeModels.put(valueType, modelLocation);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public <V extends IValue, T extends IValueType<V>> ResourceLocation getValueTypeModel(T valueType) {
        return this.valueTypeModels.get(valueType);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Collection<ResourceLocation> getValueTypeModels() {
        return Collections.unmodifiableCollection(this.valueTypeModels.values());
    }

    @Override
    public Collection<IValueType> getValueTypes() {
        return Collections.unmodifiableCollection(this.valueTypes.values());
    }

    @Override
    public String getTypeId() {
        return "valuetype";
    }

    @Override
    public IValueTypeVariableFacade getVariableFacade(int id, NBTTagCompound tag) {
        if (!tag.func_150297_b("typeName", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal()) || !tag.func_150297_b("value", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal())) {
            return INVALID_FACADE;
        }
        IValueType type = this.getValueType(tag.func_74779_i("typeName"));
        if (type == null) {
            return INVALID_FACADE;
        }
        Object value = ValueHelpers.deserializeRaw(type, tag.func_74779_i("value"));
        return new ValueTypeVariableFacade(id, type, value);
    }

    @Override
    public void setVariableFacade(NBTTagCompound tag, IValueTypeVariableFacade variableFacade) {
        tag.func_74778_a("typeName", variableFacade.getValueType().getUnlocalizedName());
        tag.func_74778_a("value", ValueHelpers.serializeRaw(variableFacade.getValue()));
    }

    @Override
    public VariableFacadePredicate deserializeVariableFacadePredicate(JsonObject element) {
        IValueType valueType = JsonDeserializers.deserializeValueType(element);
        return new AspectVariableFacadePredicate(valueType, JsonDeserializers.deserializeValue(element, valueType));
    }

    public static class AspectVariableFacadePredicate
    extends VariableFacadePredicate<IValueTypeVariableFacade> {
        private final IValueType valueType;
        private final ValuePredicate valuePredicate;

        public AspectVariableFacadePredicate(@Nullable IValueType valueType, ValuePredicate valuePredicate) {
            super(IValueTypeVariableFacade.class);
            this.valueType = valueType;
            this.valuePredicate = valuePredicate;
        }

        @Override
        protected boolean testTyped(IValueTypeVariableFacade variableFacade) {
            return super.testTyped(variableFacade) && (this.valueType == null || ValueHelpers.correspondsTo(variableFacade.getValueType(), this.valueType)) && this.valuePredicate.test((IValue)variableFacade.getValue());
        }
    }
}

