/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.client.render.valuetype.IngredientsValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.client.render.valuetype.ValueTypeWorldRenderers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;

public class RecipeValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    private static final IValueTypeWorldRenderer INGREDIENTS_RENDERER = ValueTypeWorldRenderers.REGISTRY.getRenderer(ValueTypes.OBJECT_INGREDIENTS);

    @Override
    public void renderValue(IPartContainer partContainer, double x, double y, double z, float partialTick, int destroyStage, EnumFacing direction, IPartType partType, IValue value, TileEntityRendererDispatcher rendererDispatcher, float alpha) {
        Optional recipeOptional = ((ValueObjectTypeRecipe.ValueRecipe)value).getRawValue();
        if (recipeOptional.isPresent()) {
            IRecipeDefinition recipe = (IRecipeDefinition)recipeOptional.get();
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.3, (double)0.3, (double)1.0);
            rendererDispatcher.func_147548_a().func_78276_b(L10NHelpers.localize((String)"gui.integrateddynamics.input_short", (Object[])new Object[0]), 8, 15, Helpers.RGBToInt((int)255, (int)255, (int)255));
            rendererDispatcher.func_147548_a().func_78276_b(L10NHelpers.localize((String)"gui.integrateddynamics.output_short", (Object[])new Object[0]), 46, 15, Helpers.RGBToInt((int)255, (int)255, (int)255));
            GlStateManager.func_179121_F();
            GlStateManager.func_179109_b((float)0.0f, (float)8.333333f, (float)0.0f);
            this.renderInput(partContainer, x, y, z, partialTick, destroyStage, direction, partType, recipe, rendererDispatcher, alpha);
            GlStateManager.func_179109_b((float)12.5f, (float)0.0f, (float)0.0f);
            INGREDIENTS_RENDERER.renderValue(partContainer, x, y, z, partialTick, destroyStage, direction, partType, ValueObjectTypeIngredients.ValueIngredients.of(recipe.getOutput()), rendererDispatcher, alpha);
            GlStateManager.func_179121_F();
        }
    }

    protected void renderInput(IPartContainer partContainer, double x, double y, double z, float partialTick, int destroyStage, EnumFacing direction, IPartType partType, IRecipeDefinition recipe, TileEntityRendererDispatcher rendererDispatcher, float alpha) {
        int ingredientCount = recipe.getInputComponents().stream().mapToInt(c -> recipe.getInputs(c).size()).sum();
        ArrayList values = Lists.newArrayListWithExpectedSize((int)ingredientCount);
        int tick = (int)Minecraft.func_71410_x().field_71441_e.func_82737_E() / 30;
        for (IngredientComponent component : recipe.getInputComponents()) {
            IIngredientMatcher matcher = component.getMatcher();
            IIngredientComponentHandler componentHandler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
            Stream<List<IPrototypedIngredient>> inputs = this.enhanceRecipeInputs(component, recipe);
            inputs.forEach(element -> values.add(componentHandler.toValue(((IPrototypedIngredient)IngredientsValueTypeWorldRenderer.prepareElementForTick(element, tick, () -> new PrototypedIngredient(component, matcher.getEmptyInstance(), matcher.getAnyMatchCondition()))).getPrototype())));
        }
        IngredientsValueTypeWorldRenderer.renderGrid(partContainer, x, y, z, partialTick, destroyStage, direction, partType, values, rendererDispatcher, alpha);
    }

    protected <T, M> Stream<List<IPrototypedIngredient>> enhanceRecipeInputs(IngredientComponent<T, M> ingredientComponent, IRecipeDefinition recipe) {
        Stream<List<IPrototypedIngredient>> inputs = recipe.getInputs(ingredientComponent).stream();
        if (ingredientComponent == IngredientComponent.ITEMSTACK) {
            IIngredientMatcher matcher = ingredientComponent.getMatcher();
            return inputs.map(input -> input.getAlternatives().stream().map(prototypedIngredient -> {
                if (!matcher.hasCondition(prototypedIngredient.getCondition(), (Object)2)) {
                    return ItemStackHelpers.getSubItems((ItemStack)((ItemStack)prototypedIngredient.getPrototype())).stream().map(stack -> new PrototypedIngredient(IngredientComponent.ITEMSTACK, stack, prototypedIngredient.getCondition())).collect(Collectors.toList());
                }
                return Collections.singletonList(prototypedIngredient);
            }).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        return inputs;
    }
}

