/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.api.command;

import com.buuz135.togetherforever.api.command.SubCommandAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TogetherForeverCommand
extends CommandBase {
    public static TogetherForeverCommand command;
    private final List<SubCommandAction> subCommandActions;

    public TogetherForeverCommand(List<SubCommandAction> subCommandActions) {
        this.subCommandActions = subCommandActions;
        command = this;
    }

    @Nonnull
    public String func_71517_b() {
        return "togetherforever";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        StringBuilder builder = new StringBuilder("Usage: /tf <");
        for (SubCommandAction action : this.subCommandActions) {
            builder.append(action.getSubCommandName()).append('|');
        }
        return builder.deleteCharAt(builder.length() - 1).append('>').toString();
    }

    @Nonnull
    public List<String> func_71514_a() {
        return Arrays.asList("tf", "together");
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
        if (args.length >= 1) {
            for (SubCommandAction action : this.subCommandActions) {
                if (!action.getSubCommandName().equalsIgnoreCase(args[0])) continue;
                if (!action.execute(server, sender, args)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Usage: /tf " + action.getSubCommandName() + ' ' + action.getUsage() + " - " + action.getInfo()));
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Use '/tf help' for more information!"));
                }
                return;
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + this.func_71518_a(sender)));
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return this.subCommandActions.stream().map(SubCommandAction::getSubCommandName).collect(Collectors.toList());
        }
        if (args.length > 1 && (args[0].equalsIgnoreCase("invite") || args[0].equalsIgnoreCase("accept") || args[0].equalsIgnoreCase("decline") || args[0].equalsIgnoreCase("kick"))) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v().stream().map(EntityPlayer::func_70005_c_).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<SubCommandAction> getSubCommandActions() {
        return this.subCommandActions;
    }
}

