/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.api;

import com.buuz135.togetherforever.api.IOfflineSyncRecovery;
import com.buuz135.togetherforever.api.IPlayerInformation;
import com.buuz135.togetherforever.api.ITogetherTeam;
import com.buuz135.togetherforever.api.data.DataManager;
import com.buuz135.togetherforever.api.data.TeamInvite;
import com.buuz135.togetherforever.api.event.TeamEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TogetherForeverAPI {
    public static final String MOD_ID = "togetherforever";
    public static final String API_VERSION = "1";
    public static final String API_ID = "togetherforeverapi";
    private static TogetherForeverAPI ourInstance = new TogetherForeverAPI();
    private List<TeamInvite> teamInvites = new ArrayList<TeamInvite>();

    private TogetherForeverAPI() {
    }

    public static TogetherForeverAPI getInstance() {
        return ourInstance;
    }

    public List<ITogetherTeam> getTeams() {
        World world = this.getWorld();
        if (world == null) {
            return new ArrayList<ITogetherTeam>();
        }
        return this.getDataManager(world).getTeams();
    }

    public void addTeam(ITogetherTeam togetherTeam) {
        DataManager dataManager = this.getDataManager(this.getWorld());
        if (dataManager == null) {
            return;
        }
        TeamEvent.Create create = new TeamEvent.Create(togetherTeam);
        MinecraftForge.EVENT_BUS.post((Event)create);
        if (!create.isCanceled()) {
            dataManager.getTeams().add(create.getTogetherTeam());
            dataManager.func_76185_a();
        }
    }

    public void addPlayerToTeam(ITogetherTeam team, IPlayerInformation playerInformation) {
        DataManager manager = this.getDataManager(this.getWorld());
        if (manager == null) {
            return;
        }
        for (ITogetherTeam togetherTeam : manager.getTeams()) {
            if (!togetherTeam.getOwner().equals(team.getOwner()) || !togetherTeam.getTeamName().equalsIgnoreCase(team.getTeamName())) continue;
            TeamEvent.PlayerAdd playerAdd = new TeamEvent.PlayerAdd(togetherTeam, playerInformation);
            MinecraftForge.EVENT_BUS.post((Event)playerAdd);
            if (playerAdd.isCanceled()) continue;
            playerAdd.getTogetherTeam().addPlayer(playerAdd.getPlayerInformation());
            manager.func_76185_a();
        }
    }

    public void removePlayerFromTeam(ITogetherTeam team, IPlayerInformation playerInformation) {
        DataManager manager = this.getDataManager(this.getWorld());
        if (manager == null) {
            return;
        }
        for (ITogetherTeam togetherTeam : manager.getTeams()) {
            TeamEvent.RemovePlayer removePlayer;
            if (!togetherTeam.getOwner().equals(team.getOwner()) || !togetherTeam.getTeamName().equalsIgnoreCase(team.getTeamName()) || (removePlayer = new TeamEvent.RemovePlayer(togetherTeam, playerInformation)).isCanceled()) continue;
            removePlayer.getTogetherTeam().removePlayer(removePlayer.getPlayerInformation());
            manager.func_76185_a();
        }
    }

    @Nullable
    public ITogetherTeam getPlayerTeam(UUID playerUUID) {
        for (ITogetherTeam togetherTeam : this.getTeams()) {
            for (IPlayerInformation playerInformation : togetherTeam.getPlayers()) {
                if (!playerInformation.getUUID().equals(playerUUID)) continue;
                return togetherTeam;
            }
        }
        return null;
    }

    public TeamInvite createTeamInvite(IPlayerInformation sender, IPlayerInformation receiver, boolean announceInvite) {
        TeamInvite invite = new TeamInvite(sender, receiver);
        if (announceInvite) {
            TextComponentString accept = new TextComponentString("[ACCEPT]");
            accept.func_150256_b().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tf accept " + sender.getName())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to accept")));
            TextComponentString decline = new TextComponentString("[DECLINE]");
            decline.func_150256_b().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.RED).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tf decline " + sender.getName())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to accept")));
            receiver.getPlayer().func_145747_a(new TextComponentString("You have been invited to join " + sender.getName() + "'s team. Click ").func_150257_a((ITextComponent)accept).func_150258_a(" ").func_150257_a((ITextComponent)decline));
        }
        this.teamInvites.add(invite);
        return invite;
    }

    public void addPlayerToOfflineRecovery(Class<? extends IOfflineSyncRecovery> recoveryClass, IPlayerInformation iPlayerInformation, NBTTagCompound compound) {
        DataManager manager = this.getDataManager(this.getWorld());
        if (manager == null) {
            return;
        }
        for (IOfflineSyncRecovery recovery : manager.getRecoveries()) {
            if (!recovery.getClass().equals(recoveryClass)) continue;
            recovery.storeMissingPlayer(iPlayerInformation, compound);
            manager.func_76185_a();
            return;
        }
        try {
            IOfflineSyncRecovery recovery = recoveryClass.newInstance();
            recovery.storeMissingPlayer(iPlayerInformation, compound);
            manager.getRecoveries().add(recovery);
            manager.func_76185_a();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public DataManager getDataManager(World world) {
        if (world == null) {
            return null;
        }
        DataManager dataManager = (DataManager)world.func_175693_T().func_75742_a(DataManager.class, "TogetherForever");
        if (dataManager == null) {
            dataManager = new DataManager();
            world.func_175693_T().func_75745_a("TogetherForever", (WorldSavedData)dataManager);
        }
        return dataManager;
    }

    @Nullable
    public EntityPlayerMP getPlayer(String string) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(string);
    }

    @Nullable
    public EntityPlayerMP getPlayer(UUID uuid) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(uuid);
    }

    public List<TeamInvite> getTeamInvites() {
        return this.teamInvites;
    }

    public World getWorld() {
        if (DimensionManager.getWorld((int)0) == null || FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return null;
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
    }
}

