/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedInEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamCreatedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDataEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDeletedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamLoadedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerLeftEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamSavedEvent;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.TeamData;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.MessageChangedTeam;
import com.feed_the_beast.ftbquests.net.MessageClaimRewardResponse;
import com.feed_the_beast.ftbquests.net.MessageCreateTeamData;
import com.feed_the_beast.ftbquests.net.MessageDeleteTeamData;
import com.feed_the_beast.ftbquests.net.MessageSyncQuests;
import com.feed_the_beast.ftbquests.net.MessageUpdateTaskProgress;
import com.feed_the_beast.ftbquests.net.MessageUpdateVariable;
import com.feed_the_beast.ftbquests.quest.EnumChangeProgress;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestVariable;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.task.DimensionTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.util.FTBQuestsInventoryListener;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="ftbquests")
public class FTBQuestsTeamData
extends TeamData
implements ITeamData {
    private final Int2ObjectOpenHashMap<QuestTaskData> taskData = new Int2ObjectOpenHashMap();
    private final Map<UUID, IntOpenHashSet> claimedPlayerRewards = new HashMap<UUID, IntOpenHashSet>();
    private final IntOpenHashSet claimedTeamRewards = new IntOpenHashSet();
    private final Int2LongOpenHashMap variables = new Int2LongOpenHashMap();

    public static FTBQuestsTeamData get(ForgeTeam team) {
        return (FTBQuestsTeamData)team.getData().get("ftbquests");
    }

    @SubscribeEvent
    public static void registerTeamData(ForgeTeamDataEvent event) {
        event.register((TeamData)new FTBQuestsTeamData(event.getTeam()));
    }

    @SubscribeEvent
    public static void onTeamSaved(ForgeTeamSavedEvent event) {
        NBTTagCompound nbt = new NBTTagCompound();
        FTBQuestsTeamData data = FTBQuestsTeamData.get(event.getTeam());
        data.writeData(nbt);
        File file = event.getTeam().getDataFile("ftbquests");
        if (nbt.func_82582_d()) {
            FileUtils.deleteSafe((File)file);
        } else {
            NBTUtils.writeNBTSafe((File)file, (NBTTagCompound)nbt);
        }
    }

    @SubscribeEvent
    public static void onTeamLoaded(ForgeTeamLoadedEvent event) {
        FTBQuestsTeamData data = FTBQuestsTeamData.get(event.getTeam());
        for (QuestChapter chapter : ServerQuestFile.INSTANCE.chapters) {
            for (Quest quest : chapter.quests) {
                for (QuestTask task : quest.tasks) {
                    data.createTaskData(task);
                }
            }
        }
        NBTTagCompound nbt = NBTUtils.readNBT((File)event.getTeam().getDataFile("ftbquests"));
        data.readData(nbt == null ? new NBTTagCompound() : nbt);
    }

    @SubscribeEvent
    public static void onTeamCreated(ForgeTeamCreatedEvent event) {
        FTBQuestsTeamData data = FTBQuestsTeamData.get(event.getTeam());
        for (QuestChapter chapter : ServerQuestFile.INSTANCE.chapters) {
            for (Quest quest : chapter.quests) {
                for (QuestTask task : quest.tasks) {
                    data.createTaskData(task);
                }
            }
        }
        new MessageCreateTeamData(event.getTeam()).sendToAll();
    }

    @SubscribeEvent
    public static void onTeamDeleted(ForgeTeamDeletedEvent event) {
        FileUtils.deleteSafe((File)event.getTeam().getDataFile("ftbquests"));
        new MessageDeleteTeamData(event.getTeam().getUID()).sendToAll();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(ForgePlayerLoggedInEvent event) {
        EntityPlayerMP player = event.getPlayer().getPlayer();
        ArrayList<MessageSyncQuests.TeamInst> teamData = new ArrayList<MessageSyncQuests.TeamInst>();
        for (ForgeTeam team : event.getUniverse().getTeams()) {
            FTBQuestsTeamData data = FTBQuestsTeamData.get(team);
            MessageSyncQuests.TeamInst t = new MessageSyncQuests.TeamInst();
            t.uid = team.getUID();
            t.id = team.getID();
            t.name = team.getTitle();
            int size = 0;
            for (QuestTaskData taskData : data.taskData.values()) {
                if (taskData.toNBT() == null) continue;
                ++size;
            }
            t.taskKeys = new int[size];
            t.taskValues = new NBTBase[size];
            int i = 0;
            for (QuestTaskData taskData : data.taskData.values()) {
                NBTBase nbt = taskData.toNBT();
                if (nbt == null) continue;
                t.taskKeys[i] = ((QuestTask)taskData.task).id;
                t.taskValues[i] = nbt;
                ++i;
            }
            size = 0;
            for (Int2LongMap.Entry entry : data.variables.int2LongEntrySet()) {
                if (entry.getLongValue() <= 0L) continue;
                ++size;
            }
            t.variableKeys = new int[size];
            t.variableValues = new long[size];
            i = 0;
            for (Int2LongMap.Entry entry : data.variables.int2LongEntrySet()) {
                long value = entry.getLongValue();
                if (value <= 0L) continue;
                t.variableKeys[i] = entry.getIntKey();
                t.variableValues[i] = value;
                ++i;
            }
            teamData.add(t);
        }
        FTBQuestsTeamData team = FTBQuestsTeamData.get(event.getTeam());
        IntOpenHashSet rewards = team.claimedPlayerRewards.get(event.getPlayer().getId());
        if (rewards == null) {
            rewards = team.claimedTeamRewards;
        } else {
            rewards = new IntOpenHashSet((IntCollection)rewards);
            rewards.addAll((IntCollection)team.claimedTeamRewards);
        }
        new MessageSyncQuests(ServerQuestFile.INSTANCE, event.getPlayer().team.getUID(), teamData, FTBQuests.canEdit(player), (IntCollection)rewards).sendTo(player);
        event.getPlayer().getPlayer().field_71069_bz.func_75132_a((IContainerListener)new FTBQuestsInventoryListener(event.getPlayer().getPlayer()));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            event.getEntityPlayer().field_71069_bz.func_75132_a((IContainerListener)new FTBQuestsInventoryListener((EntityPlayerMP)event.getEntityPlayer()));
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ITeamData data;
        if (event.player instanceof EntityPlayerMP && (data = ServerQuestFile.INSTANCE.getData(FTBLibAPI.getTeamID((UUID)event.player.func_110124_au()))) != null) {
            for (QuestChapter chapter : ServerQuestFile.INSTANCE.chapters) {
                for (Quest quest : chapter.quests) {
                    for (QuestTask task : quest.tasks) {
                        if (!(task instanceof DimensionTask)) continue;
                        data.getQuestTaskData(task).submitTask((EntityPlayerMP)event.player, Collections.emptyList(), false);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP && !(event.getContainer() instanceof ContainerPlayer)) {
            event.getContainer().func_75132_a((IContainerListener)new FTBQuestsInventoryListener((EntityPlayerMP)event.getEntityPlayer()));
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftTeam(ForgeTeamPlayerLeftEvent event) {
        if (event.getPlayer().isOnline()) {
            new MessageChangedTeam(0).sendTo(event.getPlayer().getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinedTeam(ForgeTeamPlayerJoinedEvent event) {
        if (event.getPlayer().isOnline()) {
            new MessageChangedTeam(event.getTeam().getUID()).sendTo(event.getPlayer().getPlayer());
        }
    }

    private FTBQuestsTeamData(ForgeTeam team) {
        super(team);
        this.variables.defaultReturnValue(0L);
    }

    public String getID() {
        return "ftbquests";
    }

    @Override
    public void syncTask(QuestTaskData data) {
        this.team.markDirty();
        if (EnumChangeProgress.sendUpdates) {
            new MessageUpdateTaskProgress(this.team.getUID(), ((QuestTask)data.task).id, data.toNBT()).sendToAll();
        }
        if (!data.isComplete && ((QuestTask)data.task).isComplete(this)) {
            data.isComplete = true;
            ArrayList<EntityPlayerMP> onlinePlayers = new ArrayList<EntityPlayerMP>();
            for (ForgePlayer player : this.team.getMembers()) {
                if (!player.isOnline()) continue;
                onlinePlayers.add(player.getPlayer());
            }
            ((QuestTask)data.task).onCompleted(this, onlinePlayers);
        }
    }

    @Override
    public void removeTask(QuestTask task) {
        this.taskData.remove(task.id);
    }

    @Override
    public void createTaskData(QuestTask task) {
        QuestTaskData data = task.createData(this);
        this.taskData.put(task.id, (Object)data);
        data.isComplete = data.getProgress() >= ((QuestTask)data.task).getMaxProgress();
    }

    public void claimReward(EntityPlayerMP player, QuestReward reward) {
        if (reward.isTeamReward()) {
            if (this.claimedTeamRewards.add(reward.id)) {
                reward.claim(player);
                this.team.markDirty();
                for (ForgePlayer player1 : this.team.getMembers()) {
                    if (!player1.isOnline()) continue;
                    new MessageClaimRewardResponse(reward.id).sendTo(player1.getPlayer());
                }
            }
        } else {
            IntOpenHashSet set = this.claimedPlayerRewards.get(player.func_110124_au());
            if (set == null) {
                set = new IntOpenHashSet();
            }
            if (set.add(reward.id)) {
                if (set.size() == 1) {
                    this.claimedPlayerRewards.put(player.func_110124_au(), set);
                }
                reward.claim(player);
                this.team.markDirty();
                new MessageClaimRewardResponse(reward.id).sendTo(player);
            }
        }
        if (reward.parent instanceof Quest) {
            ((Quest)reward.parent).checkRepeatableQuests(FTBQuestsTeamData.get(this.team), player.func_110124_au());
        }
    }

    @Override
    public boolean isRewardClaimed(UUID player, QuestReward reward) {
        if (reward.isTeamReward()) {
            return this.claimedTeamRewards.contains(reward.id);
        }
        IntOpenHashSet rewards = this.claimedPlayerRewards.get(player);
        return rewards != null && rewards.contains(reward.id);
    }

    @Override
    public void unclaimRewards(Collection<QuestReward> rewards) {
        for (QuestReward reward : rewards) {
            if (reward.isTeamReward()) {
                this.claimedTeamRewards.rem(reward.id);
                continue;
            }
            Iterator<IntOpenHashSet> iterator = this.claimedPlayerRewards.values().iterator();
            while (iterator.hasNext()) {
                IntOpenHashSet set = iterator.next();
                if (set == null || !set.rem(reward.id) || !set.isEmpty()) continue;
                iterator.remove();
            }
        }
        for (ForgePlayer player : this.team.getMembers()) {
            if (!player.isOnline()) continue;
            for (QuestReward questReward : rewards) {
            }
        }
        this.team.markDirty();
    }

    @Override
    public long getVariable(int variable) {
        return this.variables.get(variable);
    }

    @Override
    public void setVariable(int variable, long value) {
        long prevValue = this.getVariable(variable);
        if (value <= 0L) {
            this.variables.remove(variable);
        } else {
            QuestVariable v = ServerQuestFile.INSTANCE.getVariable(variable);
            if (v != null) {
                value = Math.min(value, v.maxValue);
            }
            this.variables.put(variable, value);
        }
        if (prevValue != value) {
            this.team.markDirty();
            if (EnumChangeProgress.sendUpdates) {
                new MessageUpdateVariable(this.team.getUID(), variable, value).sendToAll();
            }
        }
    }

    private void writeData(NBTTagCompound nbt) {
        NBTTagCompound nbt1 = new NBTTagCompound();
        for (QuestTaskData questTaskData : this.taskData.values()) {
            NBTBase nbt2 = questTaskData.toNBT();
            if (nbt2 == null) continue;
            nbt1.func_74782_a(((QuestObjectBase)questTaskData.task).getCodeString(), nbt2);
        }
        nbt.func_74782_a("Tasks", (NBTBase)nbt1);
        if (!this.claimedTeamRewards.isEmpty()) {
            nbt.func_74783_a("ClaimedTeamRewards", this.claimedTeamRewards.toIntArray());
        }
        if (!this.claimedPlayerRewards.isEmpty()) {
            nbt1 = new NBTTagCompound();
            for (Map.Entry entry : this.claimedPlayerRewards.entrySet()) {
                if (((IntOpenHashSet)entry.getValue()).isEmpty()) continue;
                nbt1.func_74783_a(StringUtils.fromUUID((UUID)((UUID)entry.getKey())), ((IntOpenHashSet)entry.getValue()).toIntArray());
            }
            if (!nbt1.func_82582_d()) {
                nbt.func_74782_a("ClaimedPlayerRewards", (NBTBase)nbt1);
            }
        }
        if (!this.variables.isEmpty()) {
            nbt1 = new NBTTagCompound();
            for (Int2LongMap.Entry entry : this.variables.int2LongEntrySet()) {
                QuestVariable variable = ServerQuestFile.INSTANCE.getVariable(entry.getIntKey());
                if (variable == null) continue;
                nbt1.func_74772_a(variable.getCodeString(), entry.getLongValue());
            }
            nbt.func_74782_a("Variables", (NBTBase)nbt1);
        }
    }

    private void readData(NBTTagCompound nbt) {
        NBTTagCompound nbt1 = nbt.func_74775_l("Tasks");
        if (!nbt1.func_82582_d()) {
            for (String s : nbt1.func_150296_c()) {
                QuestTask task = ServerQuestFile.INSTANCE.getTask(ServerQuestFile.INSTANCE.getID(s));
                if (task == null) continue;
                ((QuestTaskData)this.taskData.get(task.id)).fromNBT(nbt1.func_74781_a(s));
            }
        } else {
            this.team.markDirty();
            nbt1 = nbt.func_74775_l("TaskData");
            for (QuestTaskData data : this.taskData.values()) {
                data.fromNBT(null);
            }
            for (String c : nbt1.func_150296_c()) {
                NBTTagCompound nbt2 = nbt1.func_74775_l(c);
                for (String q : nbt2.func_150296_c()) {
                    NBTTagCompound nbt3 = nbt2.func_74775_l(q);
                    for (String t : nbt3.func_150296_c()) {
                        QuestTaskData data = (QuestTaskData)this.taskData.get(ServerQuestFile.INSTANCE.getID(c + ':' + q + ':' + t));
                        if (data == null) continue;
                        data.fromNBT(nbt3.func_74781_a(t));
                    }
                }
            }
        }
        this.claimedTeamRewards.clear();
        for (Object r : (Object)nbt.func_74759_k("ClaimedTeamRewards")) {
            this.claimedTeamRewards.add((int)r);
        }
        this.claimedPlayerRewards.clear();
        nbt1 = nbt.func_74775_l("ClaimedPlayerRewards");
        for (String s : nbt1.func_150296_c()) {
            int[] ar;
            UUID id = StringUtils.fromString((String)s);
            if (id == null || (ar = nbt1.func_74759_k(s)).length <= 0) continue;
            IntOpenHashSet set = new IntOpenHashSet(ar.length);
            for (int r : ar) {
                set.add(r);
            }
            this.claimedPlayerRewards.put(id, set);
        }
        this.variables.clear();
        nbt1 = nbt.func_74775_l("Variables");
        for (String s : nbt1.func_150296_c()) {
            QuestVariable variable = ServerQuestFile.INSTANCE.getVariable(ServerQuestFile.INSTANCE.getID(s));
            if (variable == null) continue;
            this.variables.put(variable.id, nbt1.func_74763_f(s));
        }
    }

    @Override
    public short getTeamUID() {
        return this.team.getUID();
    }

    @Override
    public String getTeamID() {
        return this.team.getID();
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.team.getTitle();
    }

    @Override
    public QuestFile getFile() {
        return ServerQuestFile.INSTANCE;
    }

    @Override
    public QuestTaskData getQuestTaskData(QuestTask task) {
        QuestTaskData data = (QuestTaskData)this.taskData.get(task.id);
        if (data == null) {
            return task.createData(this);
        }
        return data;
    }
}

