/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigBlockState;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.block.BlockProgressScreen;
import com.feed_the_beast.ftbquests.block.FTBQuestsBlocks;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.tile.IProgressScreen;
import com.feed_the_beast.ftbquests.tile.TileWithTeam;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import javax.annotation.Nullable;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class TileProgressScreenCore
extends TileWithTeam
implements IConfigCallback,
IProgressScreen {
    public EnumFacing facing;
    public int chapter = 0;
    public int width = 0;
    public int height = 0;
    public IBlockState skin = BlockUtils.AIR_STATE;
    public boolean fullscreen = false;
    public boolean hideIcons = false;
    private QuestChapter cChapter;

    @Override
    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        super.writeData(nbt, type);
        if (!type.item) {
            nbt.func_74778_a("Facing", this.getFacing().func_176610_l());
        }
        this.cChapter = this.getChapter();
        if (this.cChapter != null) {
            this.chapter = this.cChapter.id;
        }
        if (this.chapter != 0) {
            nbt.func_74768_a("Chapter", this.chapter);
        }
        if (this.width > 0) {
            nbt.func_74774_a("Width", (byte)this.width);
        }
        if (this.height > 0) {
            nbt.func_74774_a("Height", (byte)this.height);
        }
        if (this.skin != BlockUtils.AIR_STATE) {
            nbt.func_74778_a("Skin", BlockUtils.getNameFromState((IBlockState)this.skin));
        }
        if (this.fullscreen) {
            nbt.func_74757_a("Fullscreen", true);
        }
        if (this.hideIcons) {
            nbt.func_74757_a("HideIcons", true);
        }
    }

    @Override
    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        super.readData(nbt, type);
        if (!type.item) {
            this.facing = EnumFacing.func_176739_a((String)nbt.func_74779_i("Facing"));
        }
        this.chapter = nbt.func_74762_e("Chapter");
        this.width = nbt.func_74771_c("Width");
        this.height = nbt.func_74771_c("Height");
        this.skin = BlockUtils.getStateFromName((String)nbt.func_74779_i("Skin"));
        this.fullscreen = nbt.func_74767_n("Fullscreen");
        this.hideIcons = nbt.func_74767_n("HideIcons");
        this.func_145836_u();
    }

    public EnumFacing getFacing() {
        if (this.facing == null) {
            IBlockState state = this.getBlockState();
            this.facing = state.func_177230_c() == FTBQuestsBlocks.PROGRESS_SCREEN ? (EnumFacing)this.getBlockState().func_177229_b((IProperty)BlockHorizontal.field_185512_D) : EnumFacing.NORTH;
        }
        return this.facing;
    }

    @Override
    public TileProgressScreenCore getScreen() {
        return this;
    }

    @Override
    public void func_145836_u() {
        super.func_145836_u();
        this.facing = null;
        this.cChapter = null;
    }

    protected boolean notifyBlock() {
        return !this.field_145850_b.field_72995_K;
    }

    @Nullable
    public QuestChapter getChapter() {
        if (this.chapter == 0) {
            return null;
        }
        if (this.cChapter == null || this.cChapter.invalid) {
            QuestFile file = FTBQuests.PROXY.getQuestFile(this.field_145850_b);
            if (file == null) {
                return null;
            }
            this.cChapter = file.getChapter(this.chapter);
        }
        return this.cChapter;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return BlockProgressScreen.getScreenAABB(this.field_174879_c, this.getFacing(), this.width, this.height);
    }

    public double func_145833_n() {
        double d = 32.0 * (double)(2 + this.height);
        return d * d;
    }

    public void onClicked(EntityPlayerMP player, double x, double y) {
        boolean editor = FTBQuests.canEdit(player);
        if (player.func_70093_af()) {
            if (editor || this.isOwner((EntityPlayer)player)) {
                this.cChapter = this.getChapter();
                boolean editorOrDestructible = editor || !this.indestructible;
                ConfigGroup group0 = ConfigGroup.newGroup((String)"tile");
                group0.setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.progress_screen.name", new Object[0]));
                ConfigGroup config = group0.getGroup("ftbquests.screen");
                if (editor) {
                    config.add("team", (ConfigValue)this.createTeamConfig(), (ConfigValue)ConfigNull.INSTANCE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.team", new Object[0]));
                }
                config.add("chapter", (ConfigValue)new ConfigQuestObject(ServerQuestFile.INSTANCE, this.cChapter, new QuestObjectType[]{QuestObjectType.CHAPTER}){

                    @Override
                    public void setObject(@Nullable QuestObjectBase v) {
                        if (v instanceof QuestChapter) {
                            TileProgressScreenCore.this.cChapter = (QuestChapter)v;
                            TileProgressScreenCore.this.chapter = ((TileProgressScreenCore)TileProgressScreenCore.this).cChapter.id;
                        }
                    }
                }, (ConfigValue)ConfigNull.INSTANCE).setCanEdit(editorOrDestructible).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.chapter", new Object[0]));
                config.add("skin", (ConfigValue)new ConfigBlockState(this.skin){

                    public void setBlockState(IBlockState v) {
                        TileProgressScreenCore.this.skin = v;
                    }
                }, (ConfigValue)new ConfigBlockState(BlockUtils.AIR_STATE)).setCanEdit(editorOrDestructible);
                config.addBool("fullscreen", () -> this.fullscreen, v -> {
                    this.fullscreen = v;
                }, false).setCanEdit(editorOrDestructible);
                config.addBool("hide_icons", () -> this.hideIcons, v -> {
                    this.hideIcons = v;
                }, false).setCanEdit(editorOrDestructible);
                if (editor) {
                    config.addBool("indestructible", () -> this.indestructible, v -> {
                        this.indestructible = v;
                    }, false);
                }
                FTBLibAPI.editServerConfig((EntityPlayerMP)player, (ConfigGroup)group0, (IConfigCallback)this);
            }
        } else if (!this.indestructible) {
            this.cChapter = this.getChapter();
            if (this.cChapter != null) {
                this.chapter = this.cChapter.file.chapters.get((int)((this.cChapter.file.chapters.indexOf((Object)this.cChapter) + 1) % this.cChapter.file.chapters.size())).id;
                this.func_145836_u();
                this.func_70296_d();
                BlockUtils.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IBlockState)this.getBlockState());
            }
        }
    }

    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.func_145836_u();
        this.func_70296_d();
        BlockUtils.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IBlockState)this.getBlockState());
    }

    public void onLoad() {
        if (this.func_145838_q() != FTBQuestsBlocks.PROGRESS_SCREEN) {
            boolean xaxis = this.getFacing().func_176740_k() == EnumFacing.Axis.X;
            for (int y = 0; y < this.height + 1; ++y) {
                for (int x = -this.width; x <= this.width; ++x) {
                    int offX = xaxis ? 0 : x;
                    int offZ = xaxis ? x : 0;
                    this.field_145850_b.func_175698_g(new BlockPos(this.field_174879_c.func_177958_n() + offX, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + offZ));
                }
            }
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        this.sendDirtyUpdate();
    }
}

