/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.net.MessageSubmitTask;
import com.feed_the_beast.ftbquests.quest.EnumChangeProgress;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenCore;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenPart;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class QuestTask
extends QuestObject {
    public final Quest quest;

    public QuestTask(Quest q) {
        this.quest = q;
    }

    @Override
    public final QuestObjectType getObjectType() {
        return QuestObjectType.TASK;
    }

    @Override
    public final QuestFile getQuestFile() {
        return this.quest.chapter.file;
    }

    @Override
    public final QuestChapter getQuestChapter() {
        return this.quest.chapter;
    }

    @Override
    public final int getParentID() {
        return this.quest.id;
    }

    public abstract QuestTaskType getType();

    public abstract QuestTaskData createData(ITeamData var1);

    @Override
    public final long getProgress(ITeamData data) {
        return data.getQuestTaskData(this).getProgress();
    }

    @Override
    public final int getRelativeProgress(ITeamData data) {
        return data.getQuestTaskData(this).getRelativeProgress();
    }

    @Override
    public final boolean isComplete(ITeamData data) {
        long max = this.getMaxProgress();
        return max > 0L && this.getProgress(data) >= max;
    }

    @Override
    public final void onCompleted(ITeamData data, List<EntityPlayerMP> onlineMembers) {
        super.onCompleted(data, onlineMembers);
        new ObjectCompletedEvent.TaskEvent(data, this).post();
        boolean questComplete = this.quest.isComplete(data);
        if (this.quest.tasks.size() > 1 && !questComplete) {
            for (EntityPlayerMP player : onlineMembers) {
                new MessageDisplayCompletionToast(this.id).sendTo(player);
            }
        }
        if (questComplete) {
            this.quest.onCompleted(data, onlineMembers);
        }
    }

    @Override
    public long getMaxProgress() {
        return 1L;
    }

    public String getMaxProgressString() {
        return StringUtils.formatDouble((double)this.getMaxProgress(), (boolean)true);
    }

    @Override
    public final void changeProgress(ITeamData data, EnumChangeProgress type) {
        QuestTaskData taskData = data.getQuestTaskData(this);
        taskData.changeProgress(type);
        if (type.reset) {
            taskData.isComplete = false;
        }
        taskData.sync();
    }

    @Override
    public final void deleteSelf() {
        this.quest.tasks.remove(this);
        for (ITeamData iTeamData : this.quest.chapter.file.getAllData()) {
            iTeamData.removeTask(this);
        }
        super.deleteSelf();
    }

    @Override
    public final void deleteChildren() {
        for (ITeamData iTeamData : this.quest.chapter.file.getAllData()) {
            iTeamData.removeTask(this);
        }
        super.deleteChildren();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void editedFromGUI() {
        GuiQuestTree gui = (GuiQuestTree)((Object)ClientUtils.getCurrentGuiAs(GuiQuestTree.class));
        if (gui != null && gui.getSelectedQuest() != null) {
            gui.questLeft.refreshWidgets();
        }
        if (gui != null) {
            gui.quests.refreshWidgets();
        }
    }

    @Override
    public final void onCreated() {
        this.quest.tasks.add(this);
        for (ITeamData iTeamData : this.quest.chapter.file.getAllData()) {
            iTeamData.createTaskData(this);
        }
    }

    @Override
    public Icon getAltIcon() {
        return this.getType().getIcon();
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return this.getType().getDisplayName();
    }

    @Override
    public final ConfigGroup createSubGroup(ConfigGroup group) {
        QuestTaskType type = this.getType();
        return group.getGroup(this.getObjectType().func_176610_l()).getGroup(type.getRegistryName().func_110624_b()).getGroup(type.getRegistryName().func_110623_a());
    }

    public Class<? extends TileTaskScreenCore> getScreenCoreClass() {
        return TileTaskScreenCore.class;
    }

    public Class<? extends TileTaskScreenPart> getScreenPartClass() {
        return TileTaskScreenPart.class;
    }

    public TileTaskScreenCore createScreenCore(World world) {
        return new TileTaskScreenCore();
    }

    public TileTaskScreenPart createScreenPart(World world) {
        return new TileTaskScreenPart();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawGUI(@Nullable QuestTaskData data, int x, int y, int w, int h) {
        this.getIcon().draw(x, y, w, h);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawScreen(@Nullable QuestTaskData data) {
        this.getIcon().draw3D(Icon.EMPTY);
    }

    public boolean canInsertItem() {
        return false;
    }

    public boolean hideProgressNumbers() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addMouseOverText(List<String> list, @Nullable QuestTaskData data) {
        if (data != null && this.canInsertItem()) {
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.task.click_to_submit", (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked() {
        new MessageSubmitTask(this.id).sendToServer();
    }

    public boolean submitItemsOnInventoryChange() {
        return false;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Object getJEIFocus() {
        return null;
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }
}

