/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfig;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftbquests.gui.GuiSelectQuestObject;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public final class QuestRewardType
extends IForgeRegistryEntry.Impl<QuestRewardType> {
    private static ForgeRegistry<QuestRewardType> REGISTRY;
    public final Provider provider;
    private ITextComponent displayName;
    private Icon icon;
    private GuiProvider guiProvider;
    private boolean excludeFromListRewards;

    public static void createRegistry() {
        if (REGISTRY == null) {
            ResourceLocation registryName = new ResourceLocation("ftbquests", "rewards");
            REGISTRY = (ForgeRegistry)new RegistryBuilder().setType(QuestRewardType.class).setName(registryName).create();
            MinecraftForge.EVENT_BUS.post((Event)new RegistryEvent.Register(registryName, REGISTRY));
        }
    }

    public static ForgeRegistry<QuestRewardType> getRegistry() {
        return REGISTRY;
    }

    @Nullable
    public static QuestReward createReward(Quest quest, String id) {
        if (id.isEmpty()) {
            id = "ftbquests:item";
        } else if (id.indexOf(58) == -1) {
            id = "ftbquests:" + id;
        }
        QuestRewardType type = (QuestRewardType)REGISTRY.getValue(new ResourceLocation(id));
        if (type == null) {
            if (id.equals("ftbquests:ftb_money")) {
                return QuestRewardType.createReward(quest, "ftbmoney:money");
            }
            return null;
        }
        return type.provider.create(quest);
    }

    public QuestRewardType(Provider p) {
        this.provider = p;
        this.displayName = null;
        this.icon = GuiIcons.MONEY_BAG;
        this.guiProvider = new GuiProvider(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void openCreationGui(IOpenableGui gui, QuestObjectBase parent, Consumer<QuestReward> callback) {
                QuestReward reward = QuestRewardType.this.provider.create(parent);
                if (reward instanceof RandomReward) {
                    ConfigQuestObject config = new ConfigQuestObject(parent.getQuestFile(), null, QuestObjectType.REWARD_TABLE);
                    new GuiSelectQuestObject(config, gui, () -> {
                        ((RandomReward)reward).table = (RewardTable)config.getObject();
                        callback.accept(reward);
                    }).openGui();
                    return;
                }
                ConfigGroup group = ConfigGroup.newGroup((String)"ftbquests");
                reward.getConfig(reward.createSubGroup(group));
                new GuiEditConfig(group, (g1, sender) -> callback.accept(reward)).openGui();
            }
        };
    }

    public String getTypeForNBT() {
        return this.getRegistryName().func_110624_b().equals("ftbquests") ? this.getRegistryName().func_110623_a() : this.getRegistryName().toString();
    }

    public QuestRewardType setDisplayName(ITextComponent name) {
        this.displayName = name;
        return this;
    }

    public ITextComponent getDisplayName() {
        if (this.displayName != null) {
            return this.displayName.func_150259_f();
        }
        ResourceLocation id = this.getRegistryName();
        return new TextComponentTranslation("ftbquests.reward." + id.func_110624_b() + '.' + id.func_110623_a(), new Object[0]);
    }

    public QuestRewardType setIcon(Icon i) {
        this.icon = i;
        return this;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public QuestRewardType setGuiProvider(GuiProvider p) {
        this.guiProvider = p;
        return this;
    }

    public GuiProvider getGuiProvider() {
        return this.guiProvider;
    }

    public QuestRewardType setExcludeFromListRewards(boolean v) {
        this.excludeFromListRewards = v;
        return this;
    }

    public boolean getExcludeFromListRewards() {
        return this.excludeFromListRewards;
    }

    public static interface GuiProvider {
        @SideOnly(value=Side.CLIENT)
        public void openCreationGui(IOpenableGui var1, QuestObjectBase var2, Consumer<QuestReward> var3);
    }

    @FunctionalInterface
    public static interface Provider {
        public QuestReward create(QuestObjectBase var1);
    }
}

